/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import oracle.eclipse.tools.webtier.jsf.refactoring.internal.FacesConfigRefactoringHelper;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class FacesConfigRenameParticipant
extends RenameParticipant {
    private IFile webXml;
    private IPath facesConfigPath;

    protected boolean initialize(Object element) {
        IPath filePath;
        IPath containerPath;
        IContainer containter;
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile facesConfiguration = (IFile)element;
        this.webXml = FacesConfigRefactoringHelper.getWebXmlFile(facesConfiguration);
        if (this.webXml == null) {
            return false;
        }
        if (!FacesConfigRefactoringHelper.hasWebXmlReferenceFor(facesConfiguration) && (containter = FacesConfigRefactoringHelper.getWebContentResource(facesConfiguration.getProject())) != null && (containerPath = containter.getProjectRelativePath()).isPrefixOf(filePath = facesConfiguration.getParent().getProjectRelativePath())) {
            this.facesConfigPath = filePath.makeRelativeTo(containerPath);
            this.facesConfigPath = this.facesConfigPath.append(this.getArguments().getNewName());
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.FacesConfigRenameParticipant_participantName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        deltaFactory.change(this.webXml);
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return FacesConfigRefactoringHelper.createChangeForWebXml(this.facesConfigPath, this.webXml);
    }
}

