/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    SUBMIT(0, "submit", "submit"),
    BUTTON(1, "button", "button"),
    RESET(2, "reset", "reset");

    public static final int SUBMIT_VALUE = 0;
    public static final int BUTTON_VALUE = 1;
    public static final int RESET_VALUE = 2;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Type[]{SUBMIT, BUTTON, RESET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 0: {
                return SUBMIT;
            }
            case 1: {
                return BUTTON;
            }
            case 2: {
                return RESET;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

