/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MediaType implements Enumerator
{
    ALL(0, "all", "all"),
    AURAL(1, "aural", "aural"),
    BRAILLE(2, "braille", "braille"),
    HANDHELD(3, "handheld", "handheld"),
    PROJECTION(4, "projection", "projection"),
    PRINT(5, "print", "print"),
    SCREEN(6, "screen", "screen"),
    TTY(7, "tty", "tty"),
    TV(8, "tv", "tv");

    public static final int ALL_VALUE = 0;
    public static final int AURAL_VALUE = 1;
    public static final int BRAILLE_VALUE = 2;
    public static final int HANDHELD_VALUE = 3;
    public static final int PROJECTION_VALUE = 4;
    public static final int PRINT_VALUE = 5;
    public static final int SCREEN_VALUE = 6;
    public static final int TTY_VALUE = 7;
    public static final int TV_VALUE = 8;
    private static final MediaType[] VALUES_ARRAY;
    public static final List<MediaType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MediaType[]{ALL, AURAL, BRAILLE, HANDHELD, PROJECTION, PRINT, SCREEN, TTY, TV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MediaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MediaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MediaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MediaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MediaType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return AURAL;
            }
            case 2: {
                return BRAILLE;
            }
            case 3: {
                return HANDHELD;
            }
            case 4: {
                return PROJECTION;
            }
            case 5: {
                return PRINT;
            }
            case 6: {
                return SCREEN;
            }
            case 7: {
                return TTY;
            }
            case 8: {
                return TV;
            }
        }
        return null;
    }

    private MediaType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

