/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Layout implements Enumerator
{
    LIST(0, "list", "list"),
    TABLE(1, "table", "table");

    public static final int LIST_VALUE = 0;
    public static final int TABLE_VALUE = 1;
    private static final Layout[] VALUES_ARRAY;
    public static final List<Layout> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Layout[]{LIST, TABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Layout get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Layout result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Layout getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Layout result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Layout get(int value) {
        switch (value) {
            case 0: {
                return LIST;
            }
            case 1: {
                return TABLE;
            }
        }
        return null;
    }

    private Layout(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

