/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.model.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PhaseType implements Enumerator
{
    INVOKE_APPLICATION(0, "INVOKE_APPLICATION", "INVOKE_APPLICATION"),
    APPLY_REQUEST_VALUES(1, "APPLY_REQUEST_VALUES", "APPLY_REQUEST_VALUES"),
    PROCESS_VALIDATIONS(2, "PROCESS_VALIDATIONS", "PROCESS_VALIDATIONS"),
    UPDATE_MODEL_VALUES(3, "UPDATE_MODEL_VALUES", "UPDATE_MODEL_VALUES");

    public static final int INVOKE_APPLICATION_VALUE = 0;
    public static final int APPLY_REQUEST_VALUES_VALUE = 1;
    public static final int PROCESS_VALIDATIONS_VALUE = 2;
    public static final int UPDATE_MODEL_VALUES_VALUE = 3;
    private static final PhaseType[] VALUES_ARRAY;
    public static final List<PhaseType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PhaseType[]{INVOKE_APPLICATION, APPLY_REQUEST_VALUES, PROCESS_VALIDATIONS, UPDATE_MODEL_VALUES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PhaseType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhaseType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhaseType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PhaseType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PhaseType get(int value) {
        switch (value) {
            case 0: {
                return INVOKE_APPLICATION;
            }
            case 1: {
                return APPLY_REQUEST_VALUES;
            }
            case 2: {
                return PROCESS_VALIDATIONS;
            }
            case 3: {
                return UPDATE_MODEL_VALUES;
            }
        }
        return null;
    }

    private PhaseType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

