/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.jsp.document;

import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.ValueBindableComponentProviderForJSF;
import oracle.eclipse.tools.webtier.jsf.internal.Messages;
import oracle.eclipse.tools.webtier.jsf.model.core.FacetType;
import oracle.eclipse.tools.webtier.jsf.model.html.MessageType;
import oracle.eclipse.tools.webtier.jsf.model.html.OutputTextType;
import oracle.eclipse.tools.webtier.jsf.model.html.PanelGridType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PanelGridFieldsGenerator
extends FieldsGenerator {
    private IValueBindableComponentProvider _valueBindableComponentProvider = new ValueBindableComponentProviderForJSF(this.getDocument());

    public PanelGridFieldsGenerator(IDocument document) {
        this(document, Messages.PanelGridFieldsGenerator_generator_name);
    }

    public PanelGridFieldsGenerator(IDocument document, String displayName) {
        super(document, displayName);
    }

    public EObject getFragment() {
        PanelGridType panelGrid = (PanelGridType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "panelGrid");
        panelGrid.setColumns(this.doValidationMessage() ? "3" : "2");
        this.createHeaderIfNecessary(panelGrid);
        for (FieldGenerationInfo field : this.getFieldsGenerationInfos()) {
            this.addField(panelGrid, field);
        }
        this.createFooterIfNecessary(panelGrid);
        return panelGrid;
    }

    private void createHeaderIfNecessary(PanelGridType panelGrid) {
        if (this.doHeader()) {
            this.createFacet(panelGrid, "header", this.getHeaderText());
        }
    }

    private void createFooterIfNecessary(PanelGridType panelGrid) {
        if (this.doFooter()) {
            this.createFacet(panelGrid, "footer", this.getFooterText());
        }
    }

    private void createFacet(PanelGridType panelGrid, String facetName, String facetText) {
        FacetType facet = (FacetType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/core", "facet");
        facet.setName(facetName);
        OutputTextType label = (OutputTextType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "outputText");
        label.setValue(facetText);
        facet.getChildTags().add((Object)label);
        panelGrid.getChildTags().add((Object)facet);
    }

    private String getHeaderText() {
        FieldGenerationInfo fgi = (FieldGenerationInfo)this.getFieldsGenerationInfos().get(0);
        return fgi.getValueReference().getVariable().getName();
    }

    private String getFooterText() {
        return "Footer Text";
    }

    private void addField(PanelGridType panelGridElement, FieldGenerationInfo fieldGenInfo) {
        if (this.getDocumentBinderProvider() != null) {
            IValueBindableComponent bc = this.getValueBindableComponent(fieldGenInfo);
            AbstractBaseTag bindableTag = (AbstractBaseTag)bc.getComponent();
            IObservableValue target = EMFObservables.observeValue((EObject)bindableTag, (EStructuralFeature)bc.getBindableValueAttribute());
            Binding binder = this.getDocumentBinderProvider().createBinding(null, target, (IObservableValue)new ValueReferenceObservableValue(fieldGenInfo.getValueReference()));
            if (binder != null) {
                binder.updateModelToTarget();
                binder.dispose();
                String id = this.generateId(fieldGenInfo);
                bindableTag.eSet(bc.getIdAttribute(), (Object)id);
                OutputTextType labelText = (OutputTextType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "outputText");
                String fieldLabel = fieldGenInfo.getLabel();
                labelText.setValue(String.valueOf(fieldLabel) + ":");
                panelGridElement.getChildTags().add((Object)labelText);
                if (!fieldGenInfo.getComponentGenerationInfo().isEnabled() && bindableTag.eClass().getEStructuralFeature("disabled") != null) {
                    bindableTag.eSet(bindableTag.eClass().getEStructuralFeature("disabled"), (Object)Boolean.TRUE.toString());
                }
                panelGridElement.getChildTags().add((Object)bindableTag);
                if (this.doValidationMessage()) {
                    panelGridElement.getChildTags().add((Object)this.getValidationMessageTag(id));
                }
            }
        }
    }

    private AbstractBaseTag getValidationMessageTag(String id) {
        MessageType msgTag = (MessageType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "message");
        msgTag.setFor(id);
        if (this.getValidationStyleClassName() != null) {
            msgTag.setStyleClass(this.getValidationStyleClassName());
        }
        return msgTag;
    }

    protected AbstractBaseTag getBindableTag() {
        return (OutputTextType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "outputText");
    }

    protected IValueBindableComponentProvider getValueBindableComponentProvider() {
        return this._valueBindableComponentProvider;
    }
}

