/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.jsp.document;

import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.ValueBindableComponentProviderForJSF;
import oracle.eclipse.tools.webtier.jsf.internal.Messages;
import oracle.eclipse.tools.webtier.jsf.model.core.FacetType;
import oracle.eclipse.tools.webtier.jsf.model.facestagbase.UIOutputTag;
import oracle.eclipse.tools.webtier.jsf.model.html.ColumnType;
import oracle.eclipse.tools.webtier.jsf.model.html.DataTableType;
import oracle.eclipse.tools.webtier.jsf.model.html.MessagesType;
import oracle.eclipse.tools.webtier.jsf.model.html.OutputTextType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.context.IModelContext;

public class DataTableGenerator
extends EnumVarGenerator {
    private static final String HEADER_FACET = "header";
    private static final String FOOTER_FACET = "footer";
    private boolean _shouldGenerateColumnHeaders = true;
    private boolean _shouldGenerateColumnFooters = false;
    private boolean _shouldGenerateSortHeaders = false;
    private DataTableType _dataTableElem;
    private IValueBindableComponentProvider _valueBindableComponentProvider = new ValueBindableComponentProviderForJSF(this.getDocument());

    private static String getContentGeneratorDisplayName() {
        return Messages.DataTableGenerator_generator_name;
    }

    public DataTableGenerator(IDocument document) {
        super(document, DataTableGenerator.getContentGeneratorDisplayName());
    }

    public DataTableGenerator(IDocument document, DataTableType dataTableElem) {
        this(document);
        this._dataTableElem = dataTableElem;
    }

    public EObject getFragment() {
        FacetType facet;
        Variable iterationVariable = this.getIterationVariable();
        List fields = this.getFieldsGenerationInfos();
        if (this._dataTableElem == null) {
            this._dataTableElem = (DataTableType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "dataTable");
        }
        if (this.getDocumentBinderProvider() != null) {
            IObservableValue tagObservable = EMFObservables.observeValue((EObject)this._dataTableElem, (EStructuralFeature)this.getDefaultBindableFeature(this._dataTableElem.eClass()));
            ValueReferenceObservableValue modelObservable = new ValueReferenceObservableValue(this.getEnumeration());
            Binding binding = this.getDocumentBinderProvider().createBinding(null, tagObservable, (IObservableValue)modelObservable);
            if (binding != null) {
                binding.updateModelToTarget();
                binding.dispose();
            }
        }
        this._dataTableElem.setVar(this.getIterationVariable().getName());
        EnumVarGenerator.IDataTypeHint hint = this.createDataTypeHint();
        hint.getFlag();
        if (this.doHeader()) {
            facet = this.createFacetWithLabel(HEADER_FACET, "Header");
            this._dataTableElem.getChildTags().add((Object)facet);
        }
        if (fields.size() == 0 && iterationVariable.getType().getFields((IModelContext)new FilePositionContext(this.getDocument().getFile())).isEmpty()) {
            fields.add(new FieldGenerationInfo(new ValueReference(iterationVariable, null), (IComponentGenerationInfoProvider)this, this.getDocument().getFile()));
        }
        if (fields.size() != 0) {
            this.addTableColumns(this._dataTableElem, fields);
        }
        this.createValidationIfNecessary(fields);
        if (this.doFooter()) {
            facet = this.createFacetWithLabel(FOOTER_FACET, "Footer");
            this._dataTableElem.getChildTags().add((Object)facet);
        }
        return this._dataTableElem;
    }

    private void createValidationIfNecessary(List<FieldGenerationInfo> fields) {
        if (this.doValidationMessage()) {
            ColumnType column = (ColumnType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "column");
            this._dataTableElem.getChildTags().add((Object)column);
            if (this._shouldGenerateColumnHeaders && fields.size() > 1) {
                String fieldName = Messages.DataTableGenerator_validationColHeading;
                FacetType headerFacet = this.createFacetWithLabel(HEADER_FACET, fieldName);
                column.getChildTags().add((Object)headerFacet);
            }
            MessagesType validationMsgs = (MessagesType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "messages");
            if (this.getValidationStyleClassName() != null) {
                validationMsgs.setStyleClass(this.getValidationStyleClassName());
            }
            validationMsgs.setShowDetail("true");
            column.getChildTags().add((Object)validationMsgs);
            if (this._shouldGenerateColumnFooters) {
                FacetType footerFacet = this.createFacetWithLabel(FOOTER_FACET, FOOTER_FACET);
                column.getChildTags().add((Object)footerFacet);
            }
        }
    }

    private FacetType createFacetWithLabel(String type, String display) {
        FacetType facet = (FacetType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/core", "facet");
        facet.setName(type);
        UIOutputTag label = (UIOutputTag)this.getValueBindableComponentProvider().getValueBindableComponent(ComponentGenerationInfo.ComponentType.Label).getComponent();
        label.setValue(display);
        facet.getChildTags().add((Object)label);
        return facet;
    }

    private void addTableColumns(DataTableType dataTableElem, List<FieldGenerationInfo> fields) {
        for (FieldGenerationInfo fieldGenInfo : fields) {
            ColumnType column = (ColumnType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "column");
            dataTableElem.getChildTags().add((Object)column);
            if (this._shouldGenerateColumnHeaders && fields.size() > 1) {
                String fieldName = fieldGenInfo.getValueReference().getFieldName();
                assert (fieldName != null);
                FacetType headerFacet = this.createFacetWithLabel(HEADER_FACET, fieldGenInfo.getLabel());
                column.getChildTags().add((Object)headerFacet);
            }
            IValueBindableComponent fieldComp = this.getValueBindableComponent(fieldGenInfo);
            Object bindableValueTag = null;
            EStructuralFeature bindableValueFeature = null;
            if (fieldComp != null) {
                bindableValueTag = (AbstractBaseTag)fieldComp.getComponent();
                bindableValueFeature = fieldComp.getBindableValueAttribute();
            }
            if (bindableValueTag == null) {
                bindableValueTag = (OutputTextType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/html", "outputText");
                bindableValueFeature = this.getDefaultBindableFeature(bindableValueTag.eClass());
            }
            if (fieldComp != null) {
                bindableValueTag.eSet(fieldComp.getIdAttribute(), (Object)this.generateId(fieldGenInfo));
            }
            if (!fieldGenInfo.getComponentGenerationInfo().isEnabled() && bindableValueTag.eClass().getEStructuralFeature("disabled") != null) {
                bindableValueTag.eSet(bindableValueTag.eClass().getEStructuralFeature("disabled"), (Object)"true");
            }
            if (this.getDocumentBinderProvider() != null) {
                IObservableValue tagAttrObservable = EMFObservables.observeValue((EObject)bindableValueTag, (EStructuralFeature)bindableValueFeature);
                ValueReferenceObservableValue valRefObservable = new ValueReferenceObservableValue(fieldGenInfo.getValueReference());
                Binding binder = this.getDocumentBinderProvider().createBinding(null, tagAttrObservable, (IObservableValue)valRefObservable);
                if (binder != null) {
                    binder.updateModelToTarget();
                    binder.dispose();
                    column.getChildTags().add(bindableValueTag);
                }
            }
            if (!this._shouldGenerateColumnFooters) continue;
            FacetType footerFacet = this.createFacetWithLabel(FOOTER_FACET, FOOTER_FACET);
            column.getChildTags().add((Object)footerFacet);
        }
    }

    public boolean shouldGenerateColumnFooters() {
        return this._shouldGenerateColumnFooters;
    }

    public void setShouldGenerateColumnFooters(boolean shouldGenerateColumnFooters) {
        this._shouldGenerateColumnFooters = shouldGenerateColumnFooters;
    }

    public boolean shouldGenerateColumnHeaders() {
        return this._shouldGenerateColumnHeaders;
    }

    public void setShouldGenerateColumnHeaders(boolean shouldGenerateHeaders) {
        this._shouldGenerateColumnHeaders = shouldGenerateHeaders;
    }

    public boolean shouldGenerateSortHeaders() {
        return this._shouldGenerateSortHeaders;
    }

    public void setShouldGenerateSortHeaders(boolean shouldGenerateSortHeaders) {
        this._shouldGenerateSortHeaders = shouldGenerateSortHeaders;
    }

    protected IValueBindableComponentProvider getValueBindableComponentProvider() {
        return this._valueBindableComponentProvider;
    }
}

