/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableReferenceIterator;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.AbstractSimpleCollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigBeanArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.FaceletTagCollector;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import oracle.eclipse.tools.webtier.jsp.collection.JSPTagCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class ManagedBeanReferenceCollectionParticipant
extends AbstractSimpleCollectionParticipant
implements ICollectionParticipant {
    private static final Set<String> TYPES;
    private static ICollectionFilter sFILTER;
    private static final String COLLECTOR_ID = "ManagedBeanVariableTypeReferenceCollectionParticipant";

    static {
        HashSet<String> types = new HashSet<String>();
        types.addAll(JSPTagCollector.JSP_CONTENT_TYPES);
        types.addAll(FaceletTagCollector.FACELET_CONTENT_TYPES);
        TYPES = Collections.unmodifiableSet(types);
        sFILTER = new ContentTypeCollectionFilter(TYPES);
    }

    public void collect(IResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IResource res = resourceContext.getResource();
        if (res != null && res.getType() == 1 && sFILTER.match((IResourceContext)resourceContext)) {
            IFile file = (IFile)res;
            ResourceArtifact artifact = this.getContext().ensureResourceArtifact((IResource)file);
            this.getContext().resetCollection((IArtifact)artifact, COLLECTOR_ID);
            VariableReferenceIterator iter = VariablesController.getInstance().referenceIterator(file, false);
            while (iter.hasNext() && (monitor == null || !monitor.isCanceled())) {
                ValueReference ref = iter.next();
                Variable var = ref.getVariable();
                if (!(var instanceof FacesExternalVariable)) continue;
                FacesConfigBeanArtifactLocator locator = new FacesConfigBeanArtifactLocator(file.getProject(), var.getName());
                if (((FacesExternalVariable)var).isManagedBean()) {
                    this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)new ManagedBeanArtifactRef(locator, (IArtifact)artifact, var.getName(), ref.getFieldName(), new ResourceLocation((IResource)file, ref.getLocation()), COLLECTOR_ID), false, (byte)0);
                    continue;
                }
                if (!((FacesExternalVariable)var).isReferencedBean()) continue;
                this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)new ReferencedBeanArtifactRef(locator, (IArtifact)artifact, var.getName(), ref.getFieldName(), new ResourceLocation((IResource)file, ref.getLocation()), COLLECTOR_ID), false, (byte)0);
            }
        }
    }
}

