/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.WebApplicationDescriptorTypeFilter;
import oracle.eclipse.tools.webtier.jsf.config.annotation.AnnotatedFacesModelLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ComponentArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.RenderKitArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.FacesConfigVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebApplicationModelParticipant
implements IStructuredModelCollectionVisitor {
    private static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    private static final String MY_FACES_SERVLET_CLASS = "org.apache.myfaces.webapp.MyFacesServlet";
    private static final String WEB_APP_ELEMENT_NAME = "web-app";
    private static final String SERVLET_ELEMENT_NAME = "servlet";
    private static final String SERVLET_CLASS_ELEMENT_NAME = "servlet-class";
    private static final String CONTEXT_PARAM_ELEMENT_NAME = "context-param";
    private static final String PARAM_NAME_ELEMENT_NAME = "param-name";
    private static final String PARAM_VALUE_ELEMENT_NAME = "param-value";
    private static final String DEFAULT_FACES_CONFIG_PATH_STRING = "/WEB-INF/faces-config.xml";
    private static final IPath DEFAULT_FACES_CONFIG_PATH = new Path("/WEB-INF/faces-config.xml");
    private static final String CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String COLLECTOR_ID = "FACES-WEB";
    private IStructuredDocumentCollectionContext structuredContext = null;
    private FacesConfigArtifact facesConfigArtifact = null;
    private ResourceArtifact webXmlArtifact = null;
    private boolean isWebXml = false;

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IResource resource = resourceContext.getResource();
        this.webXmlArtifact = this.structuredContext.ensureResourceArtifact(resource);
        resourceContext.resetCollection(this.getID());
        if (this.webXmlArtifact != null && WebApplicationModelParticipant.isWebRootWebXml(resource)) {
            this.isWebXml = true;
            if (this.facesConfigArtifact == null) {
                this.facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance(this.webXmlArtifact);
                if (this.facesConfigArtifact == null) {
                    this.facesConfigArtifact = new FacesConfigArtifact(this.webXmlArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)this.facesConfigArtifact, COLLECTOR_ID);
                }
            }
            this.facesConfigArtifact.clearFacesConfigFiles((CollectionContext)this.structuredContext);
            this.structuredContext.addArtifact((IArtifact)this.facesConfigArtifact, this.getID());
        }
    }

    public void endResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IResource resource = resourceContext.getResource();
        if (this.isWebXml && WebApplicationModelParticipant.isWebRootWebXml(resource)) {
            IVirtualFile virtualDefaultFacesConfigFile = ComponentCore.createFile((IProject)resource.getProject(), (IPath)DEFAULT_FACES_CONFIG_PATH);
            if (virtualDefaultFacesConfigFile.exists()) {
                IFile defaultFacesConfigFile = virtualDefaultFacesConfigFile.getUnderlyingFile();
                if (!this.facesConfigArtifact.getFacesConfigFiles().contains(defaultFacesConfigFile)) {
                    this.structuredContext.addReferencedResource((IArtifact)this.webXmlArtifact, (IResource)defaultFacesConfigFile, false, this.webXmlArtifact.getLocation(), (byte)0, this.getID());
                    this.facesConfigArtifact.addFacesConfigFile(defaultFacesConfigFile, (CollectionContext)this.structuredContext);
                }
            }
            this.collectFacesConfigFiles();
        }
        this.isWebXml = false;
        this.webXmlArtifact = null;
        this.facesConfigArtifact = null;
    }

    private static boolean isWebRootWebXml(IResource resource) {
        if (resource == null || !resource.exists()) {
            return false;
        }
        IResource root = IWebRootResolver.Util.getRoot((IProject)resource.getProject());
        if (root == null) {
            return false;
        }
        if (root instanceof IFolder) {
            IFolder rootFolder = (IFolder)root;
            IFolder webInfFolder = rootFolder.getFolder("WEB-INF");
            return webInfFolder.getFullPath().equals((Object)resource.getParent().getFullPath());
        }
        return false;
    }

    private void collectFacesConfigFiles() {
        for (IFile facesConfigFile : this.facesConfigArtifact.getFacesConfigFiles()) {
            if (!facesConfigFile.isAccessible()) continue;
            FacesConfigVisitor visitor = new FacesConfigVisitor(this.structuredContext, facesConfigFile, this.facesConfigArtifact, this.getID());
            try {
                IVisitableDOMModel model = StructuredModelFactory.getVisitableModelForRead((IFile)facesConfigFile);
                model.accept((IStructuredXMLModelVisitor)visitor);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsf", (CoreException)e);
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsf", (Throwable)e);
            }
        }
        this.colleactAnnotatedFacesObjects();
    }

    public String getID() {
        return COLLECTOR_ID;
    }

    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        this.structuredContext = context;
    }

    public IStatus stopCollecting(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        String nodeName;
        String string = nodeName = element == null ? null : element.getNodeName();
        if (SERVLET_ELEMENT_NAME.equals(nodeName) || WEB_APP_ELEMENT_NAME.equals(nodeName)) {
            return true;
        }
        if (SERVLET_CLASS_ELEMENT_NAME.equals(nodeName)) {
            this.parseServletClassElement(element);
        } else if (CONTEXT_PARAM_ELEMENT_NAME.equals(nodeName)) {
            this.parseContextParamElement(element);
        }
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return this.isWebXml;
    }

    private void parseServletClassElement(IDOMElement element) {
        String servletClassName = this.structuredContext.getNodeText((Node)element);
        if (!MY_FACES_SERVLET_CLASS.equals(servletClassName)) {
            JSF_SERVLET_CLASS.equals(servletClassName);
        }
    }

    private void parseContextParamElement(IDOMElement element) {
        NodeList paramValues;
        NodeList paramNames = element.getElementsByTagName(PARAM_NAME_ELEMENT_NAME);
        if (paramNames.getLength() > 0 && CONTEXT_PARAM.equals(this.structuredContext.getNodeText(paramNames.item(0))) && (paramValues = element.getElementsByTagName(PARAM_VALUE_ELEMENT_NAME)).getLength() > 0) {
            String paramValue = this.structuredContext.getNodeText(paramValues.item(0));
            HashSet configPaths = new HashSet(StringUtil.split((String)paramValue, (char)',', (boolean)true, new ArrayList()));
            for (String configPath : configPaths) {
                IResource facesConfigFile = this.structuredContext.createResourceReferenceFromElement((IArtifact)this.webXmlArtifact, (IDOMElement)paramValues.item(0), paramValue.indexOf(configPath), configPath.length(), false, this.getID());
                if (facesConfigFile == null || facesConfigFile.getType() != 1) continue;
                this.facesConfigArtifact.addFacesConfigFile((IFile)facesConfigFile, (CollectionContext)this.structuredContext);
            }
        }
    }

    public boolean match(IResourceCollectionContext context) {
        return WebApplicationDescriptorTypeFilter.getInstance().match((IResourceContext)context);
    }

    public final Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        for (IResource res : changedResources) {
            FacesConfigArtifact instance;
            if (res.getType() != 1 || (instance = FacesConfigArtifact.FACTORY.getInstance(res.getProject())) == null) continue;
            for (IArtifactReference ref : instance.getReferences()) {
                IArtifact targetArtifact = ref.getTargetArtifact();
                if (!(targetArtifact instanceof NavigationRuleArtifact)) continue;
                ((NavigationRuleArtifact)targetArtifact).isImplicitRule();
            }
        }
        return Collections.emptySet();
    }

    private void colleactAnnotatedFacesObjects() {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.structuredContext.getProject());
        AnnotatedFacesModelLocator locator = new AnnotatedFacesModelLocator();
        locator.setJSFAppConfigManager(manager);
        try {
            FacesConfigType fc;
            locator.startLocating();
            Set providers = locator.getJSFAppConfigProviders();
            if (providers != null && providers.size() == 1 && (fc = ((IJSFAppConfigProvider)providers.iterator().next()).getFacesConfigModel()) != null) {
                IJavaProject jProject = JavaCore.create((IProject)this.structuredContext.getProject());
                this.collectManagedBeansFromFacesConfigModel(jProject, fc);
                this.collectReferencedBeansFromFacesConfigModel(jProject, fc);
                this.collectComponentsFromFacesConfigModel(jProject, fc);
                this.collectConvertersFromFacesConfigModel(jProject, fc);
                this.collectRenderKitsFromFacesConfigModel(jProject, fc);
                this.collectValidatorsFromFacesConfigModel(jProject, fc);
            }
        }
        finally {
            if (locator != null) {
                locator.stopLocating();
            }
        }
    }

    private void collectValidatorsFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList validators = fc.getValidator();
        if (validators != null) {
            int i = 0;
            int k = validators.size();
            while (i < k) {
                ValidatorType validator = (ValidatorType)validators.get(i);
                String className = validator.getValidatorClass().getTextContent();
                ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.validator.FacesValidator");
                if (resourceLocation != null) {
                    ValidatorArtifact artifact = new ValidatorArtifact(validator.getValidatorId().getTextContent(), resourceLocation, resourceLocation, this.facesConfigArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                }
                ++i;
            }
        }
    }

    private void collectRenderKitsFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList renderKits = fc.getRenderKit();
        if (renderKits != null) {
            int i = 0;
            int k = renderKits.size();
            while (i < k) {
                RenderKitType renderKit = (RenderKitType)renderKits.get(i);
                EList renderers = renderKit.getRenderer();
                int j = 0;
                int l = renderers.size();
                while (j < l) {
                    RendererType renderer = (RendererType)renderers.get(j);
                    String className = renderer.getRendererClass().getTextContent();
                    ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.render.FacesRenderer");
                    if (resourceLocation != null) {
                        RenderKitArtifact artifact = new RenderKitArtifact(renderKit.getRenderKitId().getTextContent(), resourceLocation, resourceLocation, this.facesConfigArtifact, COLLECTOR_ID);
                        this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void collectConvertersFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList converters = fc.getConverter();
        if (converters != null) {
            int i = 0;
            int k = converters.size();
            while (i < k) {
                ConverterType converter = (ConverterType)converters.get(i);
                String className = converter.getConverterClass().getTextContent();
                ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.converter.FacesConverter");
                if (resourceLocation != null) {
                    ConverterIdType converterID = converter.getConverterId();
                    String converterIDString = null;
                    if (converterID != null) {
                        converterIDString = converterID.getTextContent();
                    }
                    ConverterForClassType converterForClass = converter.getConverterForClass();
                    String converterForClassString = null;
                    if (converterForClass != null) {
                        converterForClassString = converterForClass.getTextContent();
                    }
                    ConverterArtifact artifact = new ConverterArtifact(converterIDString, converterForClassString, resourceLocation, resourceLocation, this.facesConfigArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                }
                ++i;
            }
        }
    }

    private void collectComponentsFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList components = fc.getComponent();
        if (components != null) {
            int i = 0;
            int k = components.size();
            while (i < k) {
                ComponentType component = (ComponentType)components.get(i);
                String className = component.getComponentClass().getTextContent();
                ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.component.FacesComponent");
                if (resourceLocation != null) {
                    ComponentArtifact artifact = new ComponentArtifact(component.getComponentType().getTextContent(), resourceLocation, resourceLocation, this.facesConfigArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                }
                ++i;
            }
        }
    }

    private void collectManagedBeansFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList managedBeans = fc.getManagedBean();
        if (managedBeans != null) {
            int i = 0;
            int k = managedBeans.size();
            while (i < k) {
                ManagedBeanType mBean = (ManagedBeanType)managedBeans.get(i);
                String className = mBean.getManagedBeanClass().getTextContent();
                ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.bean.ManagedBean");
                if (resourceLocation != null) {
                    ManagedBeanArtifact artifact = new ManagedBeanArtifact(mBean.getManagedBeanName().getTextContent(), resourceLocation, resourceLocation, (IArtifact)this.facesConfigArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                }
                ++i;
            }
        }
    }

    private void collectReferencedBeansFromFacesConfigModel(IJavaProject jProject, FacesConfigType fc) {
        EList referencedBeans = fc.getReferencedBean();
        if (referencedBeans != null) {
            int i = 0;
            int k = referencedBeans.size();
            while (i < k) {
                ReferencedBeanType rBean = (ReferencedBeanType)referencedBeans.get(i);
                String className = rBean.getReferencedBeanClass().getTextContent();
                ResourceLocation resourceLocation = this.getLocationOfAnnotation(jProject, className, "javax.faces.bean.ReferencedBean");
                if (resourceLocation != null) {
                    ReferencedBeanArtifact artifact = new ReferencedBeanArtifact(rBean.getReferencedBeanName().getTextContent(), resourceLocation, resourceLocation, this.facesConfigArtifact, COLLECTOR_ID);
                    this.structuredContext.addArtifact((IArtifact)artifact, COLLECTOR_ID);
                }
                ++i;
            }
        }
    }

    private ResourceLocation getLocationOfAnnotation(IJavaProject jProject, String className, String annotationName) {
        ResourceLocation resourceLocation = null;
        try {
            IType beanType = jProject.findType(className);
            if (!beanType.isBinary()) {
                ISourceRange range;
                IResource sourceFile = beanType.getUnderlyingResource();
                IAnnotation anno = beanType.getAnnotation(annotationName);
                if (anno != null && anno.exists() && (range = anno.getSourceRange()) != null) {
                    resourceLocation = new ResourceLocation(sourceFile, new Range((long)range.getOffset(), (long)range.getLength()));
                }
                if (resourceLocation == null) {
                    resourceLocation = new ResourceLocation(sourceFile, null);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsf", (CoreException)((Object)e));
        }
        return resourceLocation;
    }
}

