/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.webtier.javawebapp.resource.WebRootUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class NavigationRuleArtifactLocator
implements IArtifactLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IFile referencingFile;
    private volatile transient int hashCode = 0;
    private IFile sourceLocationFile;

    public NavigationRuleArtifactLocator(IFile referencingFile) {
        this(referencingFile, null);
    }

    public NavigationRuleArtifactLocator(IFile referencingFile, IFile sourceLocationFile) {
        this.referencingFile = referencingFile;
        this.sourceLocationFile = sourceLocationFile;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        Set navRuleArtifacts = model.queryArtifactsByTypes(Collections.singleton("navigation-rule"), this.referencingFile.getProject());
        NavigationRuleArtifact bestNRA = null;
        int matchingChars = -1;
        String runtimePathToReferencingFile = WebRootUtil.getRuntimePath((IFile)this.referencingFile);
        for (IArtifact navRuleArtifact : navRuleArtifacts) {
            if (!(navRuleArtifact instanceof NavigationRuleArtifact)) continue;
            NavigationRuleArtifact nra = (NavigationRuleArtifact)navRuleArtifact;
            String name = nra.getName();
            if (nra.hasNoFromViewIdElement()) {
                bestNRA = nra;
                matchingChars = 0;
                continue;
            }
            if (name != null && name.length() > matchingChars && name.endsWith("*")) {
                String pattern = name.substring(0, name.length() - 1);
                if (!runtimePathToReferencingFile.startsWith(pattern)) continue;
                matchingChars = pattern.length();
                bestNRA = nra;
                continue;
            }
            if (name == null || !name.equals(runtimePathToReferencingFile) || this.sourceLocationFile != null && !nra.getLocation().getResource().equals((Object)this.sourceLocationFile)) continue;
            bestNRA = nra;
            break;
        }
        return bestNRA;
    }

    public boolean equals(Object other) {
        if (other instanceof NavigationRuleArtifactLocator) {
            NavigationRuleArtifactLocator otherNRAL = (NavigationRuleArtifactLocator)other;
            return otherNRAL.referencingFile.equals((Object)this.referencingFile);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.referencingFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.referencingFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFileFromStream((Object)this, "referencingFile");
    }
}

