/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.NavigationRuleArtifactLocator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class NavigationCaseArtifactLocator
implements IArtifactLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String navCaseName;
    private final IFile referencingFile;
    private volatile transient int hashCode = 0;
    private IFile sourceFile;

    public NavigationCaseArtifactLocator(String navCaseName, IFile referencingFile) {
        this(navCaseName, referencingFile, null);
    }

    public NavigationCaseArtifactLocator(String navCaseName, IFile referencingFile, IFile sourceFile) {
        this.navCaseName = navCaseName;
        this.referencingFile = referencingFile;
        this.sourceFile = sourceFile;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model;
        IArtifact navCaseArtifact;
        NavigationRuleArtifactLocator nral = new NavigationRuleArtifactLocator(this.referencingFile, this.sourceFile);
        IArtifact nra = nral.locateArtifact();
        if (nra instanceof NavigationRuleArtifact && (navCaseArtifact = (model = DependencyModelManager.getInstance().getModel()).queryArtifactsByOwnerNameAndType(nra, this.navCaseName, "navigation-case")) instanceof NavigationCaseArtifact) {
            return navCaseArtifact;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof NavigationCaseArtifactLocator) {
            NavigationCaseArtifactLocator otherNCAL = (NavigationCaseArtifactLocator)other;
            if (otherNCAL.referencingFile.equals((Object)this.referencingFile)) {
                return this.navCaseName == null ? otherNCAL.navCaseName == null : this.navCaseName.equals(otherNCAL.navCaseName);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.navCaseName);
            hcu.hash((Object)this.referencingFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.navCaseName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.referencingFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "navCaseName", String.class);
        su.readFinalFileFromStream((Object)this, "referencingFile");
    }
}

