/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractTagCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.collection.TagCollector;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ActionNavCaseMatcher;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ConverterArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.NavigationCaseArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.NavigationRuleArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.ValidatorArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.jsp.document.FacesJSPUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.FeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class FacesTagCollector
extends TagCollector {
    private static final Set<SubTypes> ALL_INTERESTING_TYPES;
    private static final String NO_NAME = "<no-name-specified>";

    static {
        LinkedHashSet<SubTypes> types = new LinkedHashSet<SubTypes>(3, 1.0f);
        types.add(SubTypes.JSF_ACTION_SUBTYPE);
        types.add(SubTypes.JSF_CONVERTER_ID_SUBTYPE);
        types.add(SubTypes.JSF_VALIDATOR_ID_SUBTYPE);
        ALL_INTERESTING_TYPES = Collections.unmodifiableSet(types);
    }

    public FacesTagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagCollector.AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
        super(namespaceContext, mdContext, collectionContext, contextUriResolver, locationFactory, baseFile, collectorID);
    }

    public void collectArtifacts(IDOMElement element, IFile targetFile, IProgressMonitor monitor) throws ArtifactException {
        ResourceArtifact fileArtifact = this.getCollectionContext().ensureResourceArtifact((IResource)targetFile);
        List featuresWithSubtype = this.getTagMetadata().findFeaturesWithSubtype((Node)element, ALL_INTERESTING_TYPES);
        for (IFeatureData featureData : featuresWithSubtype) {
            this.collectAttributes(targetFile, element, (IFeatureData<Object>)featureData, fileArtifact);
        }
    }

    protected void collectAttributes(IFile targetFile, IDOMElement element, IFeatureData<Object> tagAttr, ResourceArtifact fileArtifact) {
        for (FeatureData.ValueHolder valueHolder : tagAttr.getValues()) {
            IDOMAttr attribute;
            String attributeValue;
            Node valueSourceNode;
            Object value = valueHolder.getValue();
            if (!(value instanceof String) || !((valueSourceNode = valueHolder.getNode()) instanceof IDOMAttr) || (attributeValue = (attribute = (IDOMAttr)valueSourceNode).getValue()) == null || attributeValue.length() <= 0) continue;
            SubTypes subType = TleiAccess.INSTANCE.getSubtype(this.getMetadataContext(), (IStructuredModel)attribute.getModel(), tagAttr.getFeature());
            if (this.isAction(subType)) {
                this.collectAction(attributeValue, targetFile, fileArtifact, attribute);
                continue;
            }
            if (this.isConverter(subType)) {
                this.collectConverter(attributeValue, targetFile, fileArtifact, attribute);
                continue;
            }
            if (!this.isValidator(subType)) continue;
            this.collectValidator(attributeValue, targetFile, fileArtifact, attribute);
        }
    }

    protected boolean isAction(SubTypes subType) {
        return SubTypes.JSF_ACTION_SUBTYPE.equals((Object)subType);
    }

    protected boolean isConverter(SubTypes subType) {
        return SubTypes.JSF_CONVERTER_ID_SUBTYPE.equals((Object)subType);
    }

    protected boolean isValidator(SubTypes subType) {
        return SubTypes.JSF_VALIDATOR_ID_SUBTYPE.equals((Object)subType);
    }

    private void collectAction(String action, IFile file, ResourceArtifact fileArtifact, IDOMAttr actionAttr) {
        ResourceLocation location = this.getCollectionContext().getLocationOfNode((IResource)file, (IDOMNode)actionAttr);
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression actionExpression = parser.getELExpression(action);
        String fromOutcome = actionExpression == null ? action : null;
        String fromViewID = this.getRuntimePath(file);
        ActionNavCaseMatcher actionNavCaseMatcher = new ActionNavCaseMatcher(file.getProject(), fromViewID);
        boolean resolved = false;
        IDOMElement actionElem = (IDOMElement)actionAttr.getOwnerElement();
        Set<String> outcomes = FacesJSPUtil.getActionOutcomes(file, actionElem, actionAttr);
        if (outcomes.isEmpty()) {
            NavigationCaseType navCase = actionNavCaseMatcher.matchOutcome(action, fromOutcome);
            if (navCase != null) {
                NavigationRuleType navRule = (NavigationRuleType)navCase.eContainer();
                String navRuleName = this.getNavigationRuleName(navRule);
                NavigationRuleArtifactRef ruleRef = new NavigationRuleArtifactRef(navRuleName, new NavigationRuleArtifactLocator(file), (IArtifact)fileArtifact, location, this.getID());
                this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ruleRef, true, (byte)0);
                String navCaseName = this.getNavigationCaseName(navCase);
                NavigationCaseArtifactRef caseRef = new NavigationCaseArtifactRef(navCaseName, navCase.getFromOutcome() == null ? null : navCase.getFromOutcome().getTextContent(), new NavigationCaseArtifactLocator(navCaseName, file), (IArtifact)fileArtifact, location, this.getID());
                this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)caseRef, true, (byte)0);
                resolved = true;
            }
        } else {
            for (String outcome : outcomes) {
                NavigationCaseType navCase = actionNavCaseMatcher.matchOutcome(action, outcome);
                if (navCase == null) continue;
                NavigationRuleType navRule = (NavigationRuleType)navCase.eContainer();
                String navRuleName = this.getNavigationRuleName(navRule);
                NavigationRuleArtifactRef ruleRef = new NavigationRuleArtifactRef(navRuleName, new NavigationRuleArtifactLocator(file), (IArtifact)fileArtifact, location, this.getID());
                this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ruleRef, true, (byte)0);
                String navCaseName = this.getNavigationCaseName(navCase);
                NavigationCaseArtifactRef caseRef = new NavigationCaseArtifactRef(navCaseName, navCase.getFromOutcome() == null ? null : navCase.getFromOutcome().getTextContent(), new NavigationCaseArtifactLocator(navCaseName, file), (IArtifact)fileArtifact, location, this.getID());
                this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)caseRef, true, (byte)0);
                resolved = true;
            }
        }
    }

    private void collectConverter(String converterID, IFile file, ResourceArtifact fileArtifact, IDOMAttr converterAttr) {
        ResourceLocation location = this.getCollectionContext().getLocationOfNode((IResource)file, (IDOMNode)converterAttr);
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(converterID);
        if (expression == null) {
            ConverterArtifactLocator locator = new ConverterArtifactLocator(converterID, file.getProject());
            ConverterArtifactRef ref = new ConverterArtifactRef(converterID, locator, (IArtifact)fileArtifact, location, this.getID());
            this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ref, true, (byte)0);
        }
    }

    private void collectValidator(String validatorId, IFile file, ResourceArtifact fileArtifact, IDOMAttr validatorAttr) {
        ResourceLocation location = this.getCollectionContext().getLocationOfNode((IResource)file, (IDOMNode)validatorAttr);
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(validatorId);
        if (expression == null) {
            ValidatorArtifactLocator locator = new ValidatorArtifactLocator(validatorId, file.getProject());
            ValidatorArtifactRef ref = new ValidatorArtifactRef(validatorId, locator, (IArtifact)fileArtifact, location, this.getID());
            this.getCollectionContext().addReferencedArtifact((IArtifact)fileArtifact, (IArtifactReference)ref, true, (byte)0);
        }
    }

    private String getRuntimePath(IFile file) {
        IPath rootRelativeFilePath;
        IVirtualResource vr;
        IPath designTimeFilePath;
        IContainer designTimeRoot;
        IPath designTimeRootPath;
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)file.getProject());
        if (vc != null && (rootFolder = vc.getRootFolder()) != null && (designTimeRootPath = (designTimeRoot = rootFolder.getUnderlyingFolder()).getProjectRelativePath()).isPrefixOf(designTimeFilePath = file.getProjectRelativePath()) && (vr = rootFolder.findMember(rootRelativeFilePath = designTimeFilePath.removeFirstSegments(designTimeRootPath.segmentCount()))) != null) {
            return vr.getRuntimePath().toString();
        }
        return "";
    }

    private String getNavigationRuleName(NavigationRuleType navRule) {
        String navRuleName = navRule.getFromViewId() == null ? "*" : navRule.getFromViewId().getTextContent();
        return navRuleName == null || navRuleName.equals("") ? "*" : navRuleName;
    }

    private String getNavigationCaseName(NavigationCaseType navCase) {
        String fromOutcome;
        String fromAction;
        String string = fromAction = navCase.getFromAction() == null ? null : navCase.getFromAction().getTextContent();
        if (fromAction != null) {
            return fromAction;
        }
        String string2 = fromOutcome = navCase.getFromOutcome() == null ? null : navCase.getFromOutcome().getTextContent();
        if (fromOutcome == null) {
            return NO_NAME;
        }
        return fromOutcome;
    }
}

