/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.webtier.common.services.webapp.JavaLocalizer;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ActionOutcomeArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ComponentArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanMapEntriesArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanProperty;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.RenderKitArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FacesConfigVisitor
implements IStructuredXMLModelVisitor {
    private static final String JAVA_STRING_TYPE = "java.lang.String";
    private static final String FACES_CONFIG_ELEMENT_NAME = "faces-config";
    private static final String NAVIGATION_RULE_ELEMENT_NAME = "navigation-rule";
    private static final String NAVIGATION_CASE_ELEMENT_NAME = "navigation-case";
    private static final String FROM_VIEW_ID_ELEMENT_NAME = "from-view-id";
    private static final String TO_VIEW_ID_ELEMENT_NAME = "to-view-id";
    private static final String VALIDATOR_ELEMENT_NAME = "validator";
    private static final String CONVERTER_ELEMENT_NAME = "converter";
    private static final String MANAGED_BEAN_ELEMENT_NAME = "managed-bean";
    private static final String REFERENCED_BEAN_ELEMENT_NAME = "referenced-bean";
    private static final String RENDER_KIT_ELEMENT_NAME = "render-kit";
    private static final String COMPONENT_ELEMENT_NAME = "component";
    private static final String APPLICATION_ELEMENT_NAME = "application";
    private static final String NO_NAME = "<no-specified-name>";
    private static final String PROPERTIES_EXT = ".properties";
    private final IStructuredDocumentCollectionContext structuredContext;
    private final IFile facesConfigFile;
    private final String collectorID;
    private final FacesConfigArtifact facesConfigArtifact;

    FacesConfigVisitor(IStructuredDocumentCollectionContext structuredContext, IFile facesConfigFile, FacesConfigArtifact facesConfigArtifact, String collectorID) {
        this.structuredContext = structuredContext;
        this.facesConfigFile = facesConfigFile;
        this.facesConfigArtifact = facesConfigArtifact;
        this.collectorID = collectorID;
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return true;
    }

    public boolean visit(IDOMElement element) {
        String nodeName;
        String string = nodeName = element == null ? null : element.getNodeName();
        if (FACES_CONFIG_ELEMENT_NAME.equals(nodeName)) {
            return true;
        }
        if (VALIDATOR_ELEMENT_NAME.equals(nodeName)) {
            this.collectValidatorElement(element);
        } else if (CONVERTER_ELEMENT_NAME.equals(nodeName)) {
            this.collectConverterElement(element);
        } else if (MANAGED_BEAN_ELEMENT_NAME.equals(nodeName)) {
            this.collectManagedBeanElement(element);
        } else if (NAVIGATION_RULE_ELEMENT_NAME.equals(nodeName)) {
            this.collectNavigationRuleElement(element);
        } else if (REFERENCED_BEAN_ELEMENT_NAME.equals(nodeName)) {
            this.collectReferencedBeanElement(element);
        } else if (RENDER_KIT_ELEMENT_NAME.equals(nodeName)) {
            this.collectRenderKitElement(element);
        } else if (COMPONENT_ELEMENT_NAME.equals(nodeName)) {
            this.collectComponentElement(element);
        } else if (APPLICATION_ELEMENT_NAME.equals(nodeName)) {
            this.collectApplicationElement(element);
        }
        return false;
    }

    private void collectApplicationElement(IDOMElement applicationElement) {
        this.collectResourceBundleDeclaration(applicationElement);
        this.collectMessageBundleLocales(applicationElement);
    }

    private void collectResourceBundleDeclaration(IDOMElement applicationElement) {
        IDOMElement resourceBundle;
        NodeList baseNameList;
        NodeList resourceBundles = applicationElement.getElementsByTagName("resource-bundle");
        if (resourceBundles.getLength() > 0 && (baseNameList = (resourceBundle = (IDOMElement)resourceBundles.item(0)).getElementsByTagName("base-name")) != null && baseNameList.getLength() > 0) {
            IDOMElement baseNameElement = (IDOMElement)baseNameList.item(0);
            String baseName = this.structuredContext.getNodeText((Node)baseNameElement);
            Project project = (Project)this.facesConfigFile.getProject().getAdapter(Project.class);
            IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
            IBundleResource bundleResource = appService.resolveBundle(baseName, new Locale(""));
            if (bundleResource != null) {
                IFile bundleFile = bundleResource.getUnderlyingResource();
                if (bundleFile == null) {
                    bundleFile = this.resolveBundle(baseName, null);
                }
                if (bundleFile != null) {
                    this.structuredContext.addReferencedResource((IArtifact)this.facesConfigArtifact, (IResource)bundleFile, true, this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)baseNameElement), (byte)0, this.collectorID);
                }
            }
        }
    }

    private void collectMessageBundleLocales(IDOMElement applicationElement) {
        Node messageBundleNode;
        IBundleResource bundleResource;
        Project project = (Project)this.facesConfigFile.getProject().getAdapter(Project.class);
        IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
        if (appService == null) {
            return;
        }
        String baseName = null;
        NodeList messageBundles = applicationElement.getElementsByTagName("message-bundle");
        if (messageBundles != null && messageBundles.getLength() > 0 && (bundleResource = appService.resolveBundle(baseName = this.structuredContext.getNodeText(messageBundleNode = messageBundles.item(0)), new Locale(""))) != null) {
            IFile bundleFile = bundleResource.getUnderlyingResource();
            if (bundleFile == null) {
                bundleFile = this.resolveBundle(baseName, null);
            }
            if (bundleFile != null) {
                this.structuredContext.addReferencedResource((IArtifact)this.facesConfigArtifact, (IResource)bundleFile, true, this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)messageBundleNode), (byte)0, this.collectorID);
            }
        }
        NodeList localeConfigs = applicationElement.getElementsByTagName("locale-config");
        if (baseName != null && localeConfigs != null && localeConfigs.getLength() > 0 && localeConfigs.item(0) instanceof IDOMElement) {
            String localeString;
            Locale defaultLocale;
            IBundleResource bundleResource2;
            IDOMElement localeConfig = (IDOMElement)localeConfigs.item(0);
            NodeList defaultLocales = localeConfig.getElementsByTagName("default-locale");
            if (defaultLocales.getLength() == 1 && (bundleResource2 = appService.resolveBundle(baseName, defaultLocale = JavaLocalizer.parse((String)(localeString = this.structuredContext.getNodeText(defaultLocales.item(0)))))) != null) {
                IFile bundleFile = bundleResource2.getUnderlyingResource();
                if (bundleFile == null) {
                    bundleFile = this.resolveBundle(baseName, localeString);
                }
                if (bundleFile != null) {
                    this.structuredContext.addReferencedResource((IArtifact)this.facesConfigArtifact, (IResource)bundleFile, true, this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)defaultLocales.item(0)), (byte)0, this.collectorID);
                }
            }
            NodeList supportedLocaleNodes = localeConfig.getElementsByTagName("supported-locale");
            int i = 0;
            while (i < supportedLocaleNodes.getLength()) {
                String localeString2 = this.structuredContext.getNodeText(supportedLocaleNodes.item(i));
                Locale locale = JavaLocalizer.parse((String)localeString2);
                IBundleResource bundleResource3 = appService.resolveBundle(baseName, locale);
                if (bundleResource3 != null) {
                    IFile bundleFile = bundleResource3.getUnderlyingResource();
                    if (bundleFile == null) {
                        bundleFile = this.resolveBundle(baseName, localeString2);
                    }
                    if (bundleFile != null) {
                        this.structuredContext.addReferencedResource((IArtifact)this.facesConfigArtifact, (IResource)bundleFile, true, this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)supportedLocaleNodes.item(i)), (byte)0, this.collectorID);
                    }
                }
                ++i;
            }
        }
    }

    private void collectValidatorElement(IDOMElement validatorElement) {
        String validatorID;
        Node validatorIDNode;
        NodeList validatorIDs = validatorElement.getElementsByTagName("validator-id");
        if (validatorIDs.getLength() > 0 && (validatorIDNode = validatorIDs.item(0)) instanceof IDOMElement && (validatorID = this.structuredContext.getNodeText(validatorIDNode)) != null) {
            String validatorClass;
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)validatorElement);
            ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)validatorIDNode));
            ValidatorArtifact validatorArtifact = new ValidatorArtifact(validatorID, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)validatorArtifact, this.collectorID);
            NodeList validatorClasses = validatorElement.getElementsByTagName("validator-class");
            if (validatorClasses.getLength() > 0 && validatorClasses.item(0) instanceof IDOMElement && (validatorClass = this.structuredContext.getNodeText(validatorClasses.item(0))) != null) {
                this.structuredContext.addTypeReference((IArtifact)validatorArtifact, this.facesConfigFile.getProject(), validatorClass, (IResource)this.facesConfigFile, (IDOMElement)validatorClasses.item(0), false, this.collectorID);
            }
        }
    }

    private IFile resolveBundle(String name, String locale) {
        int lastDot = name.lastIndexOf(".");
        String finalBaseName = lastDot > 0 ? name.substring(lastDot + 1) : name;
        String folderBaseName = lastDot > 0 ? name.substring(0, lastDot).replace(".", "/") : "";
        List sourcePaths = JavaUtil.getProjectRelativeSourcePaths((IProject)this.facesConfigFile.getProject());
        for (IPath path : sourcePaths) {
            String[] countries;
            IFile file;
            IFolder sourceFolder = this.facesConfigFile.getProject().getFolder(path.append(folderBaseName));
            if (sourceFolder == null || !sourceFolder.exists()) continue;
            if (locale == null) {
                file = sourceFolder.getFile(String.valueOf(finalBaseName) + PROPERTIES_EXT);
                if (file == null || !file.exists()) continue;
                return file;
            }
            file = sourceFolder.getFile(String.valueOf(finalBaseName) + "_" + locale + PROPERTIES_EXT);
            if (file != null && file.exists()) {
                return file;
            }
            if (locale.indexOf("_") != -1) continue;
            String[] stringArray = countries = Locale.getISOCountries();
            int n = countries.length;
            int n2 = 0;
            while (n2 < n) {
                String country = stringArray[n2];
                file = sourceFolder.getFile(String.valueOf(finalBaseName) + "_" + locale + "_" + country + PROPERTIES_EXT);
                if (file != null && file.exists()) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    private void collectConverterElement(IDOMElement converterElement) {
        Node converterClassElement;
        NodeList converterForClasses;
        Node converterIDElement;
        String converterID = null;
        String converterForClass = null;
        ResourceLocation boundedLocation = null;
        NodeList converterIDs = converterElement.getElementsByTagName("converter-id");
        if (converterIDs.getLength() > 0 && (converterIDElement = converterIDs.item(0)) instanceof IDOMElement) {
            converterID = this.structuredContext.getNodeText(converterIDElement);
            boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)converterIDElement);
        }
        if ((converterForClasses = converterElement.getElementsByTagName("converter-for-class")).getLength() > 0 && (converterClassElement = converterForClasses.item(0)) instanceof IDOMElement) {
            converterForClass = this.structuredContext.getNodeText(converterForClasses.item(0));
            boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)converterClassElement);
        }
        if (converterID != null || converterForClass != null) {
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)converterElement);
            ConverterArtifact converterArtifact = new ConverterArtifact(converterID, converterForClass, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)converterArtifact, this.collectorID);
            NodeList converterClasses = converterElement.getElementsByTagName("converter-class");
            if (converterClasses.getLength() > 0 && converterClasses.item(0) instanceof IDOMElement) {
                String converterClass = this.structuredContext.getNodeText(converterClasses.item(0));
                if (converterClass != null && converterClass.length() > 0) {
                    this.structuredContext.addTypeReference((IArtifact)converterArtifact, this.facesConfigFile.getProject(), converterClass, (IResource)this.facesConfigFile, (IDOMElement)converterClasses.item(0), false, this.collectorID);
                } else {
                    NodeList convertForClasses = converterElement.getElementsByTagName("converter-for-class");
                    if (converterForClass != null && converterForClass.length() > 0) {
                        this.structuredContext.addTypeReference((IArtifact)converterArtifact, this.facesConfigFile.getProject(), converterForClass, (IResource)this.facesConfigFile, (IDOMElement)convertForClasses.item(0), false, this.collectorID);
                    }
                }
            }
        }
    }

    private void collectManagedBeanElement(IDOMElement managedBeanElement) {
        String managedBeanName;
        Node managedBeanNameNode;
        NodeList managedBeanNames = managedBeanElement.getElementsByTagName("managed-bean-name");
        if (managedBeanNames.getLength() > 0 && (managedBeanNameNode = managedBeanNames.item(0)) instanceof IDOMElement && (managedBeanName = this.structuredContext.getNodeText(managedBeanNameNode)) != null) {
            NodeList mapEntriesElements;
            NodeList propertiesElements;
            String managedBeanClass;
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)managedBeanElement);
            ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)managedBeanNameNode));
            ManagedBeanArtifact managedBeanArtifact = new ManagedBeanArtifact(managedBeanName, location, boundedLocation, (IArtifact)this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)managedBeanArtifact, this.collectorID);
            NodeList managedBeanClasses = managedBeanElement.getElementsByTagName("managed-bean-class");
            if (managedBeanClasses.getLength() > 0 && managedBeanClasses.item(0) instanceof IDOMElement && (managedBeanClass = this.structuredContext.getNodeText(managedBeanClasses.item(0))) != null) {
                this.structuredContext.addTypeReference((IArtifact)managedBeanArtifact, this.facesConfigFile.getProject(), managedBeanClass, (IResource)this.facesConfigFile, (IDOMElement)managedBeanClasses.item(0), false, this.collectorID);
            }
            if ((propertiesElements = managedBeanElement.getElementsByTagName("managed-property")) != null && propertiesElements.getLength() > 0) {
                int i = 0;
                while (i < propertiesElements.getLength()) {
                    IDOMElement propertyNode = (IDOMElement)propertiesElements.item(i);
                    this.collectManagedBeanProperty(propertyNode, managedBeanArtifact);
                    ++i;
                }
            }
            if ((mapEntriesElements = managedBeanElement.getElementsByTagName("map-entries")) != null && mapEntriesElements.getLength() > 0) {
                int i = 0;
                while (i < mapEntriesElements.getLength()) {
                    IDOMElement mapEntryNode = (IDOMElement)mapEntriesElements.item(i);
                    this.collectManagedBeansMapEntries(mapEntryNode, managedBeanArtifact);
                    ++i;
                }
            }
        }
    }

    private void collectManagedBeansMapEntries(IDOMElement mapEntryNode, ManagedBeanArtifact managedBeanArtifact) {
        NodeList mapEntries;
        NodeList keyClassElement = mapEntryNode.getElementsByTagName("key-class");
        NodeList valueClassElement = mapEntryNode.getElementsByTagName("value-class");
        String keyClassName = keyClassElement == null || keyClassElement.getLength() == 0 ? JAVA_STRING_TYPE : this.structuredContext.getNodeText(keyClassElement.item(0));
        String valueClassName = valueClassElement == null || valueClassElement.getLength() == 0 ? JAVA_STRING_TYPE : this.structuredContext.getNodeText(valueClassElement.item(0));
        ResourceLocation entrieslocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)mapEntryNode);
        ManagedBeanMapEntriesArtifact entriesArtifact = new ManagedBeanMapEntriesArtifact(entrieslocation, entrieslocation, managedBeanArtifact, this.collectorID);
        this.structuredContext.addArtifact((IArtifact)entriesArtifact, this.collectorID);
        if (keyClassElement != null && keyClassElement.getLength() > 0) {
            this.structuredContext.addTypeReference((IArtifact)entriesArtifact, this.facesConfigFile.getProject(), keyClassName, (IResource)this.facesConfigFile, (IDOMElement)keyClassElement.item(0), false, this.collectorID);
        }
        if (valueClassElement != null && valueClassElement.getLength() > 0) {
            this.structuredContext.addTypeReference((IArtifact)entriesArtifact, this.facesConfigFile.getProject(), valueClassName, (IResource)this.facesConfigFile, (IDOMElement)valueClassElement.item(0), false, this.collectorID);
        }
        if ((mapEntries = mapEntryNode.getElementsByTagName("map-entry")) != null && mapEntries.getLength() > 0) {
            int i = 0;
            while (i < mapEntries.getLength()) {
                IDOMElement mapEntry = (IDOMElement)mapEntries.item(i);
                NodeList keys = mapEntry.getElementsByTagName("key");
                if (keys != null && keys.getLength() > 0) {
                    String key = this.structuredContext.getNodeText(keys.item(0));
                    ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)mapEntry);
                    ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)keys.item(0));
                    ManagedBeanProperty property = new ManagedBeanProperty(key, location, boundedLocation, (IVirtualArtifact)entriesArtifact, this.collectorID);
                    this.structuredContext.addArtifact((IArtifact)property, this.collectorID);
                }
                ++i;
            }
        }
    }

    private void collectManagedBeanProperty(IDOMElement propertyElement, ManagedBeanArtifact managedBeanArtifact) {
        Node nameElementNode;
        NodeList nameElement = propertyElement.getElementsByTagName("property-name");
        NodeList classElement = propertyElement.getElementsByTagName("property-class");
        if (nameElement != null && nameElement.getLength() > 0 && classElement != null && classElement.getLength() > 0 && (nameElementNode = nameElement.item(0)) instanceof IDOMElement) {
            String propertyName = this.structuredContext.getNodeText(nameElementNode);
            String className = this.structuredContext.getNodeText(classElement.item(0));
            if (propertyName != null && className != null) {
                ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)propertyElement);
                long offset = ((IDOMElement)nameElementNode).getStartEndOffset();
                long length = (long)((IDOMElement)nameElementNode).getEndStartOffset() - offset;
                ResourceLocation boundedLocation = new ResourceLocation((IResource)this.facesConfigFile, new Range(offset, length));
                ManagedBeanProperty property = new ManagedBeanProperty(propertyName, location, boundedLocation, (IVirtualArtifact)managedBeanArtifact, this.collectorID);
                this.structuredContext.addArtifact((IArtifact)property, this.collectorID);
                this.structuredContext.addTypeReference((IArtifact)property, this.facesConfigFile.getProject(), className, (IResource)this.facesConfigFile, (IDOMElement)classElement.item(0), false, this.collectorID);
            }
        }
    }

    private void collectNavigationRuleElement(IDOMElement navigationRuleElement) {
        String fromViewID = null;
        NodeList fromViewIDs = navigationRuleElement.getElementsByTagName(FROM_VIEW_ID_ELEMENT_NAME);
        if (fromViewIDs.getLength() > 0 && fromViewIDs.item(0) instanceof IDOMElement) {
            fromViewID = this.structuredContext.getNodeText(fromViewIDs.item(0));
        }
        ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)navigationRuleElement);
        NavigationRuleArtifact navigationRuleArtifact = null;
        if (fromViewID == null || fromViewID.length() == 0) {
            navigationRuleArtifact = new NavigationRuleArtifact("*", location, location, this.facesConfigArtifact, true, this.collectorID);
        } else {
            Node fromViewElement = fromViewIDs.item(0);
            if (fromViewElement instanceof IDOMElement) {
                ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)fromViewElement));
                navigationRuleArtifact = new NavigationRuleArtifact(fromViewID, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
                this.structuredContext.createResourceReferenceFromElement((IArtifact)navigationRuleArtifact, (IDOMElement)fromViewIDs.item(0), false, this.collectorID);
            }
        }
        this.structuredContext.addArtifact((IArtifact)navigationRuleArtifact, this.collectorID);
        NodeList navigationCases = navigationRuleElement.getElementsByTagName(NAVIGATION_CASE_ELEMENT_NAME);
        int numCases = navigationCases.getLength();
        int i = 0;
        while (i < numCases) {
            if (navigationCases.item(i) instanceof IDOMElement) {
                this.collectNavigationCaseElement((IDOMElement)navigationCases.item(i), navigationRuleArtifact);
            }
            ++i;
        }
    }

    private void collectReferencedBeanElement(IDOMElement referencedBeanElement) {
        String referencedBeanClass;
        NodeList referencedBeanClasses;
        String referencedBeanName;
        Node referencedBeanNameNode;
        NodeList referencedBeanNames = referencedBeanElement.getElementsByTagName("referenced-bean-name");
        if (referencedBeanNames.getLength() > 0 && (referencedBeanNameNode = referencedBeanNames.item(0)) instanceof IDOMElement && (referencedBeanName = this.structuredContext.getNodeText(referencedBeanNameNode)) != null && (referencedBeanClasses = referencedBeanElement.getElementsByTagName("referenced-bean-class")).getLength() > 0 && referencedBeanClasses.item(0) instanceof IDOMElement && (referencedBeanClass = this.structuredContext.getNodeText(referencedBeanClasses.item(0))) != null) {
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)referencedBeanElement);
            ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)referencedBeanNameNode));
            ReferencedBeanArtifact referencedBeanArtifact = new ReferencedBeanArtifact(referencedBeanName, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)referencedBeanArtifact, this.collectorID);
            this.structuredContext.addTypeReference((IArtifact)referencedBeanArtifact, this.facesConfigFile.getProject(), referencedBeanClass, (IResource)this.facesConfigFile, (IDOMElement)referencedBeanClasses.item(0), false, this.collectorID);
        }
    }

    private void collectRenderKitElement(IDOMElement renderKitElement) {
        Node renderKitIDNode;
        NodeList renderKitIDs = renderKitElement.getElementsByTagName("render-kit-id");
        if (renderKitIDs.getLength() > 0 && (renderKitIDNode = renderKitIDs.item(0)) instanceof IDOMElement) {
            String renderKitClass;
            String renderKitID = this.structuredContext.getNodeText(renderKitIDNode);
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)renderKitElement);
            ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)renderKitIDNode));
            RenderKitArtifact renderKitArtifact = new RenderKitArtifact(renderKitID == null ? "HTML_BASIC" : renderKitID, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)renderKitArtifact, this.collectorID);
            NodeList renderKitClasses = renderKitElement.getElementsByTagName("render-kit-class");
            if (renderKitClasses.getLength() > 0 && renderKitClasses.item(0) instanceof IDOMElement && (renderKitClass = this.structuredContext.getNodeText(renderKitClasses.item(0))) != null) {
                this.structuredContext.addTypeReference((IArtifact)renderKitArtifact, this.facesConfigFile.getProject(), renderKitClass, (IResource)this.facesConfigFile, (IDOMElement)renderKitClasses.item(0), false, this.collectorID);
            }
        }
    }

    private void collectComponentElement(IDOMElement componentElement) {
        String componentType;
        Node componentTypeNode;
        NodeList componentTypes = componentElement.getElementsByTagName("component-type");
        if (componentTypes.getLength() > 0 && (componentTypeNode = componentTypes.item(0)) instanceof IDOMElement && (componentType = this.structuredContext.getNodeText(componentTypeNode)) != null) {
            String componentClass;
            ResourceLocation location = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)componentElement);
            ResourceLocation boundedLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)((IDOMElement)componentTypeNode));
            ComponentArtifact componentArtifact = new ComponentArtifact(componentType, location, boundedLocation, this.facesConfigArtifact, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)componentArtifact, this.collectorID);
            NodeList componentClasses = componentElement.getElementsByTagName("component-class");
            if (componentClasses.getLength() > 0 && componentClasses.item(0) instanceof IDOMElement && (componentClass = this.structuredContext.getNodeText(componentClasses.item(0))) != null) {
                this.structuredContext.addTypeReference((IArtifact)componentArtifact, this.facesConfigFile.getProject(), componentClass, (IResource)this.facesConfigFile, (IDOMElement)componentClasses.item(0), false, this.collectorID);
            }
        }
    }

    private void collectNavigationCaseElement(IDOMElement navigationCaseElement, NavigationRuleArtifact navigationRuleArtifact) {
        NodeList toViewIDs;
        NodeList fromActionNodes = navigationCaseElement.getElementsByTagName("from-action");
        IDOMElement fromActionElement = null;
        NodeList fromOutcomeNodes = navigationCaseElement.getElementsByTagName("from-outcome");
        IDOMElement fromOutcomeElement = null;
        if (fromActionNodes.getLength() > 0 && fromActionNodes.item(0) instanceof IDOMElement) {
            fromActionElement = (IDOMElement)fromActionNodes.item(0);
        }
        if (fromOutcomeNodes.getLength() > 0 && fromOutcomeNodes.item(0) instanceof IDOMElement) {
            fromOutcomeElement = (IDOMElement)fromOutcomeNodes.item(0);
        }
        String fromOutcome = fromOutcomeElement == null ? null : this.structuredContext.getNodeText(fromOutcomeElement);
        String caseName = null;
        IDOMElement caseElement = null;
        String action = null;
        if (fromActionElement == null) {
            if (fromOutcome == null) {
                caseName = NO_NAME;
            } else {
                caseName = fromOutcome;
                caseElement = fromOutcomeElement;
            }
        } else {
            caseName = action = this.structuredContext.getNodeText((Node)fromActionElement);
            caseElement = fromActionElement;
        }
        NavigationCaseArtifact navigationCaseArtifact = navigationRuleArtifact.getNavigationCase(caseName);
        if (navigationCaseArtifact == null) {
            ResourceLocation caseLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)navigationCaseElement);
            ResourceLocation boundedLocation = caseElement == null ? caseLocation : this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)caseElement);
            navigationCaseArtifact = new NavigationCaseArtifact(caseName, action, fromOutcome, navigationRuleArtifact, caseLocation, boundedLocation, this.collectorID);
            navigationRuleArtifact.addNavigationCase(navigationCaseArtifact);
            this.structuredContext.addArtifact((IArtifact)navigationCaseArtifact, this.collectorID);
        }
        if (fromActionElement != null && fromOutcomeElement != null) {
            ResourceLocation actionOutcomeLocation = this.structuredContext.getLocationOfNode((IResource)this.facesConfigFile, (IDOMNode)fromOutcomeElement);
            ActionOutcomeArtifact actionOutcomeArtifact = new ActionOutcomeArtifact(fromOutcome, navigationCaseArtifact, actionOutcomeLocation, actionOutcomeLocation, this.collectorID);
            this.structuredContext.addArtifact((IArtifact)actionOutcomeArtifact, this.collectorID);
        }
        if ((toViewIDs = navigationCaseElement.getElementsByTagName(TO_VIEW_ID_ELEMENT_NAME)).getLength() > 0 && toViewIDs.item(0) instanceof IDOMElement) {
            this.structuredContext.createResourceReferenceFromElement((IArtifact)navigationCaseArtifact, (IDOMElement)toViewIDs.item(0), false, this.collectorID);
        }
    }
}

