/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;

public class ActionNavCaseMatcher {
    public static final String DEFAULT_VIEW_ID = "*";
    private final List<NavigationCaseType> mNavCases = new ArrayList<NavigationCaseType>();

    public ActionNavCaseMatcher(IProject project, String viewId) {
        this.sortNavigationCases(project, viewId);
    }

    private void sortNavigationCases(IProject project, String viewId) {
        List<NavigationRuleType> navigationRules = this.getNavigationRules(project);
        int countExactMatch = 0;
        for (NavigationRuleType navRule : navigationRules) {
            String prefix;
            String fromViewId;
            String string = fromViewId = navRule.getFromViewId() == null ? "" : navRule.getFromViewId().getTextContent();
            if (viewId.equals(fromViewId)) {
                EList navCases = navRule.getNavigationCase();
                this.mNavCases.addAll(countExactMatch, (Collection<NavigationCaseType>)navCases);
                countExactMatch += navCases.size();
                continue;
            }
            if (fromViewId == null || fromViewId.length() == 0 || fromViewId.equals(DEFAULT_VIEW_ID)) {
                this.mNavCases.addAll((Collection<NavigationCaseType>)navRule.getNavigationCase());
                continue;
            }
            if (!fromViewId.endsWith(DEFAULT_VIEW_ID) || !viewId.startsWith(prefix = fromViewId.substring(0, fromViewId.length() - DEFAULT_VIEW_ID.length()))) continue;
            this.mNavCases.addAll(countExactMatch, (Collection<NavigationCaseType>)navRule.getNavigationCase());
        }
    }

    private List<NavigationRuleType> getNavigationRules(IProject project) {
        ArrayList<NavigationRuleType> navigationRules = new ArrayList<NavigationRuleType>();
        IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)project);
        if (mgr != null) {
            List navRules = mgr.getNavigationRules();
            for (NavigationRuleType navRule : navRules) {
                navigationRules.add(navRule);
            }
        }
        return navigationRules;
    }

    public Map<String, NavigationCaseType> getPossibleOutcomes() {
        HashMap<String, NavigationCaseType> map = new HashMap<String, NavigationCaseType>();
        int count = this.mNavCases.size();
        int i = count - 1;
        while (i >= 0) {
            NavigationCaseType navCase = this.mNavCases.get(i);
            if (navCase.getFromAction() == null) {
                String fromOutcome;
                String string = fromOutcome = navCase.getFromOutcome() == null ? null : navCase.getFromOutcome().getTextContent();
                if (fromOutcome != null && fromOutcome.length() != 0) {
                    map.put(fromOutcome, navCase);
                }
            }
            --i;
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NavigationCaseType matchAction(String action, boolean isMethodBinding, String outcome) {
        NavigationCaseType match = null;
        int matchSpecifity = 0;
        int i = 0;
        int n = this.mNavCases.size();
        while (i < n) {
            String fromOutcome;
            NavigationCaseType navCase = this.mNavCases.get(i);
            String fromAction = navCase.getFromAction() == null ? null : navCase.getFromAction().getTextContent();
            String string = fromOutcome = navCase.getFromOutcome() == null ? null : navCase.getFromOutcome().getTextContent();
            if (fromAction != null) {
                if (isMethodBinding && action.equals(fromAction)) {
                    if (fromOutcome == null) {
                        if (matchSpecifity < 2) {
                            match = navCase;
                            matchSpecifity = 2;
                        }
                    } else if (outcome.equals(fromOutcome)) {
                        return navCase;
                    }
                }
            } else if (fromOutcome != null) {
                if (outcome.equals(fromOutcome)) {
                    if (!isMethodBinding) return navCase;
                    if (matchSpecifity < 2) {
                        match = navCase;
                        matchSpecifity = 2;
                    }
                }
            } else if (matchSpecifity == 0) {
                match = navCase;
                matchSpecifity = 1;
            }
            ++i;
        }
        return match;
    }

    public NavigationCaseType matchOutcome(String action, String outcome) {
        if (outcome == null || outcome.length() == 0) {
            return null;
        }
        return this.matchAction(action, false, outcome);
    }
}

