/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class FacesConfigArtifact
extends AbstractVirtualArtifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "faces-config";
    private static final String TYPE = "faces-config";
    private final ResourceArtifact owner;
    private final Set<IFile> facesConfigFiles = new LinkedHashSet<IFile>();
    private final FacesConfigArtifactLocator locator = new FacesConfigArtifactLocator();

    public FacesConfigArtifact(ResourceArtifact owner, String collectorID) {
        super(owner.getLocation(), owner.getLocation(), collectorID);
        this.owner = owner;
    }

    public boolean isMissing() {
        return false;
    }

    public final String getName() {
        return "faces-config";
    }

    public IArtifact getOwner() {
        return this.owner;
    }

    public final String getType() {
        return "faces-config";
    }

    public final void addFacesConfigFile(IFile facesConfigFile, CollectionContext ctx) {
        if (this.facesConfigFiles.add(facesConfigFile)) {
            ResourceArtifact facesConfigFileArtifact = ctx == null ? DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)facesConfigFile) : ctx.ensureResourceArtifact((IResource)facesConfigFile);
            facesConfigFileArtifact.addReference((IArtifactReference)new FacesConfigArtifactReference(facesConfigFileArtifact));
        }
    }

    public Set<IFile> getFacesConfigFiles() {
        return Collections.unmodifiableSet(this.facesConfigFiles);
    }

    public void clearFacesConfigFiles(CollectionContext context) {
        for (IFile facesConfigFile : this.facesConfigFiles) {
            ResourceArtifact facesConfigFileArtifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)facesConfigFile);
            context.removeReferences(facesConfigFileArtifact, "faces-config");
        }
        this.facesConfigFiles.clear();
    }

    public boolean equals(Object object) {
        if (object instanceof FacesConfigArtifact) {
            boolean ownerIsEqual;
            FacesConfigArtifact otherArtifact = (FacesConfigArtifact)object;
            if (this.owner != null) {
                ownerIsEqual = this.owner.equals((Object)otherArtifact.owner);
            } else {
                boolean bl = ownerIsEqual = otherArtifact.owner == null;
            }
            return super.equals(object) && ownerIsEqual;
        }
        return false;
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(super.hashCode());
        hcu.hash((Object)this.owner);
        return hcu.getHashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.owner);
        out.writeObject(this.locator);
        out.writeInt(this.facesConfigFiles.size());
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        for (IFile file : this.facesConfigFiles) {
            su.writeResource((IResource)file);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "owner", ResourceArtifact.class);
        su.readFinalFieldFromStream((Object)this, "locator", FacesConfigArtifactLocator.class);
        int size = in.readInt();
        LinkedHashSet<IFile> configFiles = new LinkedHashSet<IFile>();
        int i = 0;
        while (i < size) {
            configFiles.add(su.readFile());
            ++i;
        }
        su.setFinalField((Object)this, "facesConfigFiles", Set.class, configFiles);
    }

    public IResource[] getAffectedResources() {
        IResource[] superResources = super.getAffectedResources();
        ArrayList<Object> resourceList = new ArrayList<Object>();
        if (superResources != null && superResources.length > 0) {
            resourceList.addAll(Arrays.asList(superResources));
        }
        resourceList.addAll(this.facesConfigFiles);
        return resourceList.toArray(new IResource[resourceList.size()]);
    }

    public static class FACTORY {
        public static FacesConfigArtifact getInstance(ResourceArtifact webXmlArtifact) {
            IDependencyModel model = DependencyModelManager.getInstance().getModel();
            IArtifact fca = model.queryArtifactsByOwnerNameAndType((IArtifact)webXmlArtifact, "faces-config", "faces-config");
            if (fca instanceof FacesConfigArtifact) {
                return (FacesConfigArtifact)fca;
            }
            return null;
        }

        private static FacesConfigArtifact getInstance(IFile webXmlFile) {
            ResourceArtifact webXmlArtifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)webXmlFile);
            return webXmlArtifact == null ? null : FACTORY.getInstance(webXmlArtifact);
        }

        public static FacesConfigArtifact getInstance(IProject project) {
            IResource webXmlFile;
            IWebRootResolver webRootResolver;
            Project oepeProj = (Project)project.getAdapter(Project.class);
            if (oepeProj != null && (webRootResolver = (IWebRootResolver)oepeProj.getAppService(IWebRootResolver.class)) != null && (webXmlFile = webRootResolver.getResourceForPath("WEB-INF/web.xml")) != null && webXmlFile.getType() == 1) {
                return FACTORY.getInstance((IFile)webXmlFile);
            }
            return null;
        }
    }

    private final class FacesConfigArtifactLocator
    implements IArtifactLocator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FacesConfigArtifactLocator() {
        }

        public IArtifact locateArtifact() {
            return FacesConfigArtifact.this;
        }

        public boolean equals(Object object) {
            if (object instanceof FacesConfigArtifactLocator) {
                FacesConfigArtifactLocator otherLoc = (FacesConfigArtifactLocator)object;
                return FacesConfigArtifact.this.equals(otherLoc.locateArtifact());
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 37 + (FacesConfigArtifact.this == null ? 0 : FacesConfigArtifact.this.hashCode());
            return hash;
        }
    }

    private class FacesConfigArtifactReference
    extends AbstractArtifactReference
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected FacesConfigArtifactReference(ResourceArtifact source) {
            super((IArtifactLocator)FacesConfigArtifact.this.locator, (IArtifact)source);
            this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(source.getLocation(), true, "faces-config"));
        }

        public String getName() {
            return super.getOwner().getName();
        }

        public String getType() {
            return "faces-config";
        }

        public boolean isMissing() {
            return false;
        }

        protected IArtifact createMissingArtifact() {
            return FacesConfigArtifact.this;
        }

        public boolean isTargetDefinedByReferringSource() {
            return ((FacesConfigArtifact)this.getTargetArtifact()).facesConfigFiles.contains(super.getOwner().getLocation().getResource());
        }

        public boolean equals(Object object) {
            if (object instanceof FacesConfigArtifactReference) {
                return super.equals(object);
            }
            return false;
        }

        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            return hcu.getHashCode();
        }
    }
}

