/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.config.annotation;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.config.annotation.AnnotatedFacesModelSearchRequestor;
import oracle.eclipse.tools.webtier.jsf.config.annotation.FacesAnnotatedPackageFragmentRoot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;

public class AnnotatedFacesModelAppConfigProvider
extends AbstractJSFAppConfigProvider {
    static final String MANAGED_BEAN_ANNOTATION_CLASS = "javax.faces.bean.ManagedBean";
    static final String REFERENCED_BEAN_ANNOTATION_CALSS = "javax.faces.bean.ReferencedBean";
    static final String FACES_COMPONENT_ANNOTATION_CLASS = "javax.faces.component.FacesComponent";
    static final String FACES_CONVERTER_ANNOTATION_CLASS = "javax.faces.convert.FacesConverter";
    static final String FACES_RENDERER_ANNOTATION_CLASS = "javax.faces.render.FacesRenderer";
    static final String FACES_VALIDATOR_ANNOTATION_CLASS = "javax.faces.validator.FacesValidator";
    static final String VIEW_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.ViewScoped";
    static final String APPLICATION_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.ApplicationScoped";
    static final String NONE_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.NoneScoped";
    static final String SESSION_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.SessionScoped";
    static final String CUSTON_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.CustomScoped";
    private FacesConfigType facesConfig = null;

    public synchronized FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null) {
            try {
                this.discoverFacesConfig();
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsp", (CoreException)ce);
                this.facesConfig = null;
            }
            if (this.facesConfig != null) {
                this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
            }
        }
        return this.facesConfig;
    }

    public void releaseFacesConfigModel() {
        this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
        this.facesConfig = null;
    }

    private void discoverFacesConfig() throws CoreException {
        this.facesConfig = FacesConfigFactory.eINSTANCE.createFacesConfigType();
        IJavaProject jProject = JavaCore.create((IProject)this.jsfAppConfigLocater.getJSFAppConfigManager().getProject());
        IPackageFragmentRoot[] roots = jProject.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> scannableRoots = new ArrayList<IPackageFragmentRoot>();
        if (roots != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                FacesAnnotatedPackageFragmentRoot facesRoot = new FacesAnnotatedPackageFragmentRoot(root);
                if (facesRoot.canContainAnnotatedComponents()) {
                    scannableRoots.add(root);
                }
                ++n2;
            }
        }
        if (!scannableRoots.isEmpty()) {
            this.findAnnotatedComponents(jProject, scannableRoots);
        }
    }

    private final void findAnnotatedComponents(IJavaProject jProject, List<IPackageFragmentRoot> scannableRoots) throws CoreException {
        SearchPattern pattern = this.orPattern(null, (IJavaElement)jProject.findType(MANAGED_BEAN_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(REFERENCED_BEAN_ANNOTATION_CALSS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_COMPONENT_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_CONVERTER_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_RENDERER_ANNOTATION_CLASS));
        if ((pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_VALIDATOR_ANNOTATION_CLASS))) != null) {
            SearchEngine engine = new SearchEngine();
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])scannableRoots.toArray(new IJavaElement[scannableRoots.size()]), (int)3);
            AnnotatedFacesModelSearchRequestor requestor = new AnnotatedFacesModelSearchRequestor(this.facesConfig);
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private SearchPattern orPattern(SearchPattern pattern, IJavaElement element) {
        if (element == null) {
            return pattern;
        }
        if (pattern == null) {
            return SearchPattern.createPattern((IJavaElement)element, (int)2);
        }
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)element, (int)2));
    }
}

