/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class JsfUtil {
    public static final String JSF_TECH_EXTENSION_ID = "jsf";
    public static final String FACES_CONFIG_DEFAULT_RELATIVE_PATH = "/WEB-INF/faces-config.xml";
    public static final String FACES_CONFIG_FILE_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";

    public static ITechnologyExtension getJsfTechExtension(IProject project) {
        return ((Project)project.getAdapter(Project.class)).getTechnologyExtensionById(JSF_TECH_EXTENSION_ID);
    }

    public static String getJsfTechExtensionVersion(IProject project) {
        ITechnologyExtension jsfTechExtension = JsfUtil.getJsfTechExtension(project);
        if (jsfTechExtension == null) {
            return null;
        }
        return jsfTechExtension.getVersion().trim();
    }

    public static boolean isPartOfJsfProject(IResource resource) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        ITechnologyExtension jsfTechExtension = ((Project)project.getAdapter(Project.class)).getTechnologyExtensionById(JSF_TECH_EXTENSION_ID);
        return jsfTechExtension != null;
    }

    public static ValidatorType createValidator() {
        ValidatorType validator = FacesConfigFactory.eINSTANCE.createValidatorType();
        validator.setValidatorId(FacesConfigFactory.eINSTANCE.createValidatorIdType());
        validator.setValidatorClass(FacesConfigFactory.eINSTANCE.createValidatorClassType());
        validator.getDescription().add((Object)FacesConfigFactory.eINSTANCE.createDescriptionType());
        return validator;
    }

    public static List<String> getExistingValidatorIds(IProject project, String facesConfigFilename) {
        ArrayList<String> existingValidatorIds = new ArrayList<String>();
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)facesConfigFilename);
            for (Object conv : facesConfigEdit.getFacesConfig().getValidator()) {
                String validatorIdString;
                ValidatorIdType validatorId;
                ValidatorType validatorObject;
                if (!(conv instanceof ValidatorType) || (validatorObject = (ValidatorType)conv) == null || (validatorId = validatorObject.getValidatorId()) == null || (validatorIdString = validatorId.getTextContent()) == null) continue;
                existingValidatorIds.add(validatorIdString.trim());
            }
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
                assert (facesConfigEdit.isDisposed());
                facesConfigEdit = null;
            }
        }
        return existingValidatorIds;
    }
}

