/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.jsf.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JsfFacetUtil {
    public static final String JSF_FACET_ID = "jst.jsf";
    static final String FACES_CONFIG_RESOURCES_BUNDLE_NAME = "resources.application";
    static final String FACES_CONFIG_DEFAULT_LOCALE_TYPE = "en";
    public static final String TEMPLATES_FOLDER = "templates/";
    private static final String[] jspFiles = new String[]{"index.jsp", "index.xhtml"};
    private static final String[] configFiles = new String[]{"WEB-INF/faces-config.xml"};
    private static final String[] resourceBundle = new String[]{"resources/application.properties"};
    private static final Map<String, String> TEMPLATE_FILE_MAP;

    static {
        HashMap<String, String> templateFileMap = new HashMap<String, String>();
        templateFileMap.put("index.jsp", "templates/new-app/web-app-common/web/index.jsp");
        templateFileMap.put("application.properties", "templates/new-app/web-app-common/src/resources/application.properties");
        TEMPLATE_FILE_MAP = Collections.unmodifiableMap(templateFileMap);
    }

    public static List<IFile> getExistingTemplateFilesInProject(IProject project, IProjectFacetVersion fv) throws CoreException {
        ArrayList<IFile> existingIfiles = new ArrayList<IFile>();
        try {
            String WEB_CONTENT_FOLDER_NAME = FacetUtil.getWebContentFolderName((IProject)project);
            JsfFacetUtil.addFilesIfExistingToExistingIfilesList(jspFiles, existingIfiles, project, String.valueOf(WEB_CONTENT_FOLDER_NAME) + "/");
            JsfFacetUtil.addFilesIfExistingToExistingIfilesList(configFiles, existingIfiles, project, String.valueOf(WEB_CONTENT_FOLDER_NAME) + "/");
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.jsf", (String)e.getLocalizedMessage());
        }
        JsfFacetUtil.addFilesIfExistingToExistingIfilesList(resourceBundle, existingIfiles, project, String.valueOf(OperationUtil.getSrcFolderName((IProject)project)) + "/");
        return existingIfiles;
    }

    public static File getTemplateFile(IFile ifile, IProjectFacetVersion fv) throws IOException, URISyntaxException {
        String templateFileRelativePath = TEMPLATE_FILE_MAP.get(ifile.getName());
        if (templateFileRelativePath == null) {
            throw new IllegalArgumentException("Template file \"" + ifile.getName() + "\" not found in map.");
        }
        File templateFile = FacetUtil.getFileFromPlugin((Plugin)Activator.getDefault(), (String)templateFileRelativePath);
        if (templateFile == null) {
            throw new IllegalArgumentException("Template file \"" + templateFileRelativePath + "\" not found in plugin " + Activator.getDefault().toString());
        }
        return templateFile;
    }

    private static void addFilesIfExistingToExistingIfilesList(String[] filenames, List<IFile> iFileList, IProject project, String filenamePrefix) {
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filenameToAdd = stringArray[n2];
            IFile iFile = project.getFile(String.valueOf(filenamePrefix) + filenameToAdd);
            if (iFile.isAccessible()) {
                iFileList.add(iFile);
            }
            ++n2;
        }
    }

    public static final boolean isJsfFacet(IProjectFacetActionEvent event) {
        return event.getProjectFacet().getId().equals(JSF_FACET_ID);
    }
}

