/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CompoundOperationExecutor;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.JsfFacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JsfFacetPostUninstallListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent facetEvent = (IProjectFacetActionEvent)event;
        if (!JsfFacetUtil.isJsfFacet(facetEvent)) {
            return;
        }
        IProject project = event.getProject().getProject();
        IProjectFacetVersion projectFacetVersion = facetEvent.getProjectFacetVersion();
        try {
            String WEB_CONTENT_FOLDER = OperationUtil.getWebContentFolderName((IProject)project);
            String SRC_FOLDER = OperationUtil.getSrcFolderName((IProject)project);
            CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(WEB_CONTENT_FOLDER) + "/" + this.getIndexFileName(projectFacetVersion)));
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF/faces-config.xml", true));
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(SRC_FOLDER) + "/resources/application.properties"));
            CompoundOperationExecutor.executeWithPrompt((IProgressMonitor)new NullProgressMonitor(), (ICompoundOperation)compoundOperation);
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.jsf", (String)e.getLocalizedMessage());
        }
    }

    private String getIndexFileName(IProjectFacetVersion fv) {
        if (fv.getVersionString().startsWith("1.")) {
            return "index.jsp";
        }
        return "index.xhtml";
    }

    static final class Strings
    extends NLS {
        public static String compoundOperationTitle;

        static {
            Strings.initializeMessages((String)JsfFacetPostUninstallListener.class.getName(), Strings.class);
        }

        Strings() {
        }
    }
}

