/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.JsfFacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JsfFacetPostInstallListener
implements IFacetedProjectListener {
    private static final String JSF_2_0_VERSION_STRING = "2.0";
    private static final String TEMPLATES_WEB_CONTENT_FOLDER_PATH = "new-app/web-app-common/web";
    private static final String TEMPLATES_RESOURCE_BUNDLE_FOLDER_PATH = "new-app/web-app-common/src";
    private static final String TEMPLATES_WEB_CONTENT_FOLDER_PATH_FOR_JSF_2_0 = "new-app/web-app-jsf-2.0/web";
    private static final String TEMPLATES_RESOURCE_BUNDLE_FOLDER_PATH_FOR_JSF_2_0 = "new-app/web-app-jsf-2.0/src";

    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent facetEvent = (IProjectFacetActionEvent)event;
        IProject project = event.getProject().getProject();
        IProjectFacetVersion fv = facetEvent.getProjectFacetVersion();
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (JsfFacetUtil.isJsfFacet(facetEvent)) {
            try {
                String configPath;
                this.copyJspTemplates(project, fv, (IProgressMonitor)monitor);
                Object actionConfig = facetEvent.getActionConfig();
                if (actionConfig instanceof IDataModel && (configPath = ((IDataModel)actionConfig).getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) != null && !configPath.isEmpty()) {
                    if (configPath.startsWith("/")) {
                        configPath = configPath.substring(1);
                    }
                    this.updateFacesConfig(project, configPath);
                }
            }
            catch (FileNotFoundException e) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
            catch (IOException e) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
            catch (URISyntaxException e) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
            catch (CoreException e) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
        }
    }

    private void updateFacesConfig(IProject project, String configPath) {
        FacesConfigArtifactEdit edit = null;
        try {
            FacesConfigType facesConfig;
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)configPath);
            if (edit != null && (facesConfig = edit.getFacesConfig()) != null) {
                ApplicationType applicationType;
                FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
                FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
                EList applications = facesConfig.getApplication();
                if (applications.isEmpty()) {
                    applicationType = facesConfigFactory.createApplicationType();
                    applications.add(applicationType);
                } else {
                    applicationType = (ApplicationType)applications.get(0);
                }
                boolean messageBundleFound = false;
                EList messageBundles = applicationType.getMessageBundle();
                for (Object messageBundleTypeObj : messageBundles) {
                    MessageBundleType messageBundleType = (MessageBundleType)messageBundleTypeObj;
                    String messageBundle = messageBundleType.getTextContent();
                    if (!"resources.application".equals(messageBundle)) continue;
                    messageBundleFound = true;
                    break;
                }
                if (!messageBundleFound) {
                    MessageBundleType messageBundleType = facesConfigFactory.createMessageBundleType();
                    messageBundleType.setTextContent("resources.application");
                    messageBundles.add(messageBundleType);
                }
                boolean defaultLocaleFound = false;
                EList localeConfigs = applicationType.getLocaleConfig();
                for (Object localeConfigTypeObj : localeConfigs) {
                    String defaultLocale;
                    LocaleConfigType localeConfigType = (LocaleConfigType)localeConfigTypeObj;
                    DefaultLocaleType defaultLocaleType = localeConfigType.getDefaultLocale();
                    if (defaultLocaleType == null || !"en".equals(defaultLocale = defaultLocaleType.getTextContent())) continue;
                    defaultLocaleFound = true;
                    break;
                }
                if (!defaultLocaleFound) {
                    LocaleConfigType localeConfigType = facesConfigFactory.createLocaleConfigType();
                    DefaultLocaleType defaultLocaleType = facesConfigFactory.createDefaultLocaleType();
                    defaultLocaleType.setTextContent("en");
                    localeConfigType.setDefaultLocale(defaultLocaleType);
                    localeConfigs.add(localeConfigType);
                }
                edit.save(null);
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
                edit = null;
            }
        }
    }

    private void copyJspTemplates(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) throws IOException, URISyntaxException, CoreException {
        boolean isAtLeastJSF20 = JsfFacetPostInstallListener.isAtLeastJSF20(fv);
        String templatesWebContentFolderPath = isAtLeastJSF20 ? TEMPLATES_WEB_CONTENT_FOLDER_PATH_FOR_JSF_2_0 : TEMPLATES_WEB_CONTENT_FOLDER_PATH;
        String templatesResourceBundleFolderPath = isAtLeastJSF20 ? TEMPLATES_RESOURCE_BUNDLE_FOLDER_PATH_FOR_JSF_2_0 : TEMPLATES_RESOURCE_BUNDLE_FOLDER_PATH;
        File templatesWebContentFolder = FacetUtil.getBundleFolder((Plugin)Activator.getDefault(), (String)("templates/" + templatesWebContentFolderPath));
        File projectWebContentFolder = FacetUtil.getWebContentFolder((IProject)project);
        FacetUtil.copyFiles((File)templatesWebContentFolder, (File)projectWebContentFolder, null, (boolean)false, null);
        File templatesSrcFolder = FacetUtil.getBundleFolder((Plugin)Activator.getDefault(), (String)("templates/" + templatesResourceBundleFolderPath));
        File webProjectSrcFolder = FacetUtil.getWebProjectSrcFolder((IProject)project);
        FacetUtil.copyFiles((File)templatesSrcFolder, (File)webProjectSrcFolder, null, (boolean)false, null);
        FacetUtil.refreshProject((IProject)project);
    }

    private static boolean isAtLeastJSF20(IProjectFacetVersion facetVersion) {
        IProjectFacetVersion jsf20FacetVersion;
        IProjectFacet jsfFacet;
        boolean isAtLeastJSF20 = false;
        if (facetVersion != null && (jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf")) != null && (jsf20FacetVersion = jsfFacet.getVersion(JSF_2_0_VERSION_STRING)) != null) {
            isAtLeastJSF20 = facetVersion.compareTo((Object)jsf20FacetVersion) >= 0;
        }
        return isAtLeastJSF20;
    }
}

