/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceIdClassAnnotation
extends SourceAnnotation
implements IdClassAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.IdClass");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceIdClassAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private TextRange valueTextRange;
    private String fullyQualifiedClassName;
    private boolean fqClassNameStale = true;

    public SourceIdClassAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceModel)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(element, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.IdClass";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.fqClassNameStale = true;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        if (this.attributeValueHasChanged(this.value, astValue)) {
            this.syncValue_(astValue);
        }
    }

    private void syncValue_(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.fqClassNameStale = true;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(Annotation astAnnotation) {
        return (String)this.valueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(VALUE_ADAPTER, astAnnotation);
    }

    @Override
    public String getFullyQualifiedClassName() {
        if (this.fqClassNameStale) {
            this.fullyQualifiedClassName = this.buildFullyQualifiedClassName();
            this.fqClassNameStale = false;
        }
        return this.fullyQualifiedClassName;
    }

    private String buildFullyQualifiedClassName() {
        return this.value == null ? null : this.buildFullyQualifiedClassName_();
    }

    private String buildFullyQualifiedClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(this.buildASTRoot()));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", SimpleTypeStringExpressionConverter.instance());
    }
}

