/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.GeneratedAnnotation2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGeneratedAnnotation2_0
extends SourceAnnotation
implements GeneratedAnnotation2_0 {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.annotation.Generated");
    private static final DeclarationAnnotationElementAdapter<String[]> VALUE_ADAPTER = SourceGeneratedAnnotation2_0.buildValueAdapter();
    private final AnnotationElementAdapter<String[]> valueAdapter;
    private final Vector<String> values = new Vector();
    private static final DeclarationAnnotationElementAdapter<String> DATE_ADAPTER = SourceGeneratedAnnotation2_0.buildAdapter("date");
    private final AnnotationElementAdapter<String> dateAdapter;
    private String date;
    private static final DeclarationAnnotationElementAdapter<String> COMMENTS_ADAPTER = SourceGeneratedAnnotation2_0.buildAdapter("comments");
    private final AnnotationElementAdapter<String> commentsAdapter;
    private String comments;

    public SourceGeneratedAnnotation2_0(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceModel)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = this.buildAnnotationElementAdapter(VALUE_ADAPTER);
        this.dateAdapter = this.buildAdapter(DATE_ADAPTER);
        this.commentsAdapter = this.buildAdapter(COMMENTS_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.annotation.Generated";
    }

    private AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.initializeValues(astAnnotation);
        this.date = this.buildDate(astAnnotation);
        this.comments = this.buildComments(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValues(astAnnotation);
        this.syncDate(this.buildDate(astAnnotation));
        this.syncComments(this.buildComments(astAnnotation));
    }

    public boolean isUnset() {
        return super.isUnset() && this.values.isEmpty() && this.date == null && this.comments == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.values);
    }

    @Override
    public ListIterable<String> getValues() {
        return IterableTools.cloneLive(this.values);
    }

    @Override
    public int getValuesSize() {
        return this.values.size();
    }

    @Override
    public String getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public void addValue(String value) {
        this.addValue(this.values.size(), value);
    }

    @Override
    public void addValue(int index, String value) {
        this.values.add(index, value);
        this.writeValues();
    }

    @Override
    public void moveValue(int targetIndex, int sourceIndex) {
        ListTools.move(this.values, (int)targetIndex, (int)sourceIndex);
        this.writeValues();
    }

    @Override
    public void removeValue(String value) {
        this.values.remove(value);
        this.writeValues();
    }

    @Override
    public void removeValue(int index) {
        this.values.remove(index);
        this.writeValues();
    }

    private void writeValues() {
        this.valueAdapter.setValue((Object)this.values.toArray(new String[this.values.size()]));
    }

    private void initializeValues(Annotation astAnnotation) {
        String[] astValues = (String[])this.valueAdapter.getValue(astAnnotation);
        int i = 0;
        while (i < astValues.length) {
            this.values.add(astValues[i]);
            ++i;
        }
    }

    private void syncValues(Annotation astAnnotation) {
        String[] astValues = (String[])this.valueAdapter.getValue(astAnnotation);
        this.synchronizeList(Arrays.asList(astValues), this.values, "values");
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        if (this.attributeValueHasChanged(this.date, date)) {
            this.date = date;
            this.dateAdapter.setValue((Object)date);
        }
    }

    protected void syncDate(String astDate) {
        String old = this.date;
        this.date = astDate;
        this.firePropertyChanged("date", old, astDate);
    }

    private String buildDate(Annotation astAnnotation) {
        return (String)this.dateAdapter.getValue(astAnnotation);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        if (this.attributeValueHasChanged(this.comments, comments)) {
            this.comments = comments;
            this.commentsAdapter.setValue((Object)comments);
        }
    }

    protected void syncComments(String astComments) {
        String old = this.comments;
        this.comments = astComments;
        this.firePropertyChanged("comments", old, astComments);
    }

    private String buildComments(Annotation astAnnotation) {
        return (String)this.commentsAdapter.getValue(astAnnotation);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildValueAdapter() {
        return SourceGeneratedAnnotation2_0.buildArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceGeneratedAnnotation2_0.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String[]>)AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceGeneratedAnnotation2_0.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)annotationAdapter, (String)elementName);
    }
}

