/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumn
extends AbstractJavaNamedColumn<BaseJoinColumn.ParentAdapter, PrimaryKeyJoinColumnAnnotation>
implements JavaSpecifiedPrimaryKeyJoinColumn {
    protected PrimaryKeyJoinColumnAnnotation columnAnnotation;
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;

    public GenericJavaPrimaryKeyJoinColumn(BaseJoinColumn.ParentAdapter parentAdapter, PrimaryKeyJoinColumnAnnotation columnAnnotation) {
        super(parentAdapter, columnAnnotation);
    }

    @Override
    protected void initialize(PrimaryKeyJoinColumnAnnotation annotation) {
        super.initialize(annotation);
        this.specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName(annotation);
    }

    @Override
    public void synchronizeWithResourceModel(PrimaryKeyJoinColumnAnnotation annotation) {
        super.synchronizeWithResourceModel(annotation);
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName(annotation));
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public PrimaryKeyJoinColumnAnnotation getColumnAnnotation() {
        return this.columnAnnotation;
    }

    @Override
    protected void setColumnAnnotation(PrimaryKeyJoinColumnAnnotation columnAnnotation) {
        this.columnAnnotation = columnAnnotation;
    }

    @Override
    protected void removeColumnAnnotation() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        if (this.valuesAreDifferent(this.specifiedReferencedColumnName, name)) {
            this.columnAnnotation.setReferencedColumnName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedReferencedColumnName_(name);
        }
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName(PrimaryKeyJoinColumnAnnotation annotation) {
        return annotation.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((BaseJoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public String getTableName() {
        return ((BaseJoinColumn.ParentAdapter)this.parentAdapter).getDefaultTableName();
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos)) {
            return this.getJavaCandidateReferencedColumnNames();
        }
        return null;
    }

    protected boolean referencedColumnNameTouches(int pos) {
        return this.columnAnnotation.referencedColumnNameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateReferencedColumnNames() {
        return new TransformationIterable(this.getCandidateReferencedColumnNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((BaseJoinColumn.ParentAdapter)this.parentAdapter).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        return this.getValidationTextRange(this.columnAnnotation.getReferencedColumnNameTextRange());
    }

    @Override
    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append("=>");
        sb.append(this.getReferencedColumnName());
    }
}

