/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.jpa2.JpaMetamodelSynchronizer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.JpaContextModelRoot2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericContextModelRoot
extends AbstractJpaContextModel<JpaContextModel>
implements JpaContextModelRoot2_0 {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;

    public GenericContextModelRoot(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.persistenceXml = this.buildPersistenceXml();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncPersistenceXml();
    }

    @Override
    public void update() {
        super.update();
        this.updatePersistenceXml();
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    protected PersistenceXml buildPersistenceXml() {
        JptXmlResource xmlResource = this.resolvePersistenceXmlResource();
        return xmlResource == null ? null : this.buildPersistenceXml(xmlResource);
    }

    protected void syncPersistenceXml() {
        this.syncPersistenceXml(true);
    }

    protected void syncPersistenceXml(boolean sync) {
        JptXmlResource xmlResource = this.resolvePersistenceXmlResource();
        if (xmlResource == null) {
            if (this.persistenceXml != null) {
                this.persistenceXml.dispose();
                this.setPersistenceXml(null);
            }
        } else if (this.persistenceXml == null) {
            this.setPersistenceXml(this.buildPersistenceXml(xmlResource));
        } else if (sync) {
            this.persistenceXml.synchronizeWithResourceModel();
        } else {
            this.persistenceXml.update();
        }
    }

    protected JptXmlResource resolvePersistenceXmlResource() {
        JptXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JptResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    protected PersistenceXml buildPersistenceXml(JptXmlResource xmlResource) {
        return this.getJpaFactory().buildPersistenceXml(this, xmlResource);
    }

    protected void updatePersistenceXml() {
        this.syncPersistenceXml(false);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.jpaProject.stateChanged();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jpaProject.getProject();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public MappingFile.Root getMappingFileRoot() {
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.jpaProject.getName());
    }

    @Override
    public void initializeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).initializeMetamodel();
        }
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        return this.persistenceXml != null ? ((PersistenceXml2_0)this.persistenceXml).synchronizeMetamodel(monitor) : Status.OK_STATUS;
    }

    @Override
    public void disposeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).disposeMetamodel();
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return EmptyTextRange.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.persistenceXml == null) {
            messages.add(this.buildPersistenceXmlValidationMessage());
            return;
        }
        if (!this.jpaProject.discoversAnnotatedClasses()) {
            this.validateOrphanClasses(messages);
        }
        this.persistenceXml.validate(messages, reporter);
    }

    protected IMessage buildPersistenceXmlValidationMessage() {
        IFile file = this.getPlatformFile();
        if (file != null && file.exists()) {
            JptXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
            if (xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType())) {
                return ValidationMessageTools.buildValidationMessage((IResource)file, (ValidationMessage)JptJpaCoreValidationMessages.PERSISTENCE_XML_UNSUPPORTED_CONTENT);
            }
            return ValidationMessageTools.buildValidationMessage((IResource)file, (ValidationMessage)JptJpaCoreValidationMessages.PERSISTENCE_XML_INVALID_CONTENT);
        }
        return this.buildValidationMessage(JptJpaCoreValidationMessages.PROJECT_NO_PERSISTENCE_XML);
    }

    protected IFile getPlatformFile() {
        return this.jpaProject.getPlatformFile(XmlPersistence.DEFAULT_RUNTIME_PATH);
    }

    protected void validateOrphanClasses(List<IMessage> messages) {
        Persistence persistence = this.persistenceXml.getRoot();
        if (persistence == null) {
            return;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return;
        }
        PersistenceUnit persistenceUnit = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
        HashBag annotatedTypes = CollectionTools.bag(this.jpaProject.getAnnotatedJavaSourceTypes());
        HashBag orphans = annotatedTypes.clone();
        for (JavaResourceAbstractType jrat : annotatedTypes) {
            if (persistenceUnit.specifiesManagedType(jrat.getTypeBinding().getQualifiedName())) {
                orphans.remove((Object)jrat);
                continue;
            }
            if (!JpaMetamodelSynchronizer2_0.MetamodelTools.isMetamodel(jrat)) continue;
            orphans.remove((Object)jrat);
        }
        Iterable<String> managedTypeAnnotationNames = this.jpaProject.getManagedTypeAnnotationNames();
        for (JavaResourceAbstractType jrat : orphans) {
            if (jrat.isAnnotatedWithAnyOf(managedTypeAnnotationNames)) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)jrat.getFile(), (TextRange)jrat.getNameTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_MANAGED_BUT_NOT_LISTED_IN_PERSISTENCE_XML, (Object[])new Object[]{jrat.getTypeBinding().getQualifiedName()}));
                continue;
            }
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)jrat.getFile(), (TextRange)jrat.getNameTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.TYPE_ANNOTATED_BUT_NOT_LISTED_IN_PERSISTENCE_XML, (Object[])new Object[]{jrat.getTypeBinding().getQualifiedName()}));
        }
    }
}

