/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.DeleteTypeRefactoringParticipant;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextModel;
import org.eclipse.jpt.jpa.core.context.ManagedType;
import org.eclipse.jpt.jpa.core.context.ManagedTypeContainer;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.TypeRefactoringParticipant;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRefactoringParticipant;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.persistence.connection.NullConnection2_0;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.persistence.options.NullOptions2_0;
import org.eclipse.jpt.jpa.core.internal.jpa2_1.context.persistence.schemagen.NullGenericSchemaGeneration2_1;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MappingFilePersistenceUnitDefaults2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.PersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.connection.Connection2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.Options2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.ValidationMode2_0;
import org.eclipse.jpt.jpa.core.jpa2_1.context.persistence.PersistenceUnit2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.persistence.schemagen.SchemaGeneration2_1;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnit
extends AbstractPersistenceXmlContextModel<Persistence>
implements PersistenceUnit2_1 {
    protected final XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected Boolean specifiedExcludeUnlistedClasses;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType = PersistenceUnitTransactionType.JTA;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final Hashtable<String, ManagedType> managedTypeMap = new Hashtable();
    protected final AbstractJpaContextModel.ContextListContainer<MappingFileRef, XmlMappingFileRef> specifiedMappingFileRefContainer;
    protected MappingFileRef impliedMappingFileRef;
    protected final MappingFileRef potentialImpliedMappingFileRef;
    protected final AbstractJpaContextModel.ContextListContainer<JarFileRef, XmlJarFileRef> jarFileRefContainer;
    protected final AbstractJpaContextModel.ContextListContainer<ClassRef, XmlJavaClassRef> specifiedClassRefContainer;
    protected final AbstractJpaContextModel.ContextCollectionContainer<ClassRef, JavaResourceAbstractType> impliedClassRefContainer;
    protected final AbstractJpaContextModel.ContextListContainer<PersistenceUnit.Property, XmlProperty> propertyContainer;
    protected final Vector<Generator> generators = new Vector();
    protected final Vector<Query> queries = new Vector();
    protected boolean xmlMappingMetadataComplete;
    protected AccessType defaultAccess;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected boolean defaultCascadePersist;
    protected boolean defaultDelimitedIdentifiers;
    protected final Vector<JpaStructureNode> children = new Vector();
    protected Connection2_0 connection;
    protected Options2_0 options;
    protected SharedCacheMode2_0 specifiedSharedCacheMode;
    protected SharedCacheMode2_0 defaultSharedCacheMode;
    protected ValidationMode2_0 specifiedValidationMode;
    protected ValidationMode2_0 defaultValidationMode = DEFAULT_VALIDATION_MODE;
    protected final Set<IFile> metamodelFiles = Collections.synchronizedSet(new HashSet());
    protected SchemaGeneration2_1 schemaGeneration;
    protected static final Transformer<TypeMapping, Iterable<JavaGenerator>> TYPE_MAPPING_JAVA_GENERATORS_TRANSFORMER = TransformerTools.cast(TypeMapping.GENERATORS_TRANSFORMER);
    protected static final Transformer<TypeMapping, Iterable<JavaQuery>> TYPE_MAPPING_JAVA_QUERIES_TRANSFORMER = TransformerTools.cast(TypeMapping.QUERIES_TRANSFORMER);
    protected static final Transformer<ClassRef, ManagedType> CLASS_REF_MANAGED_TYPE_TRANSFORMER = TransformerTools.upcast(ClassRef.JAVA_MANAGED_TYPE_TRANSFORMER);
    protected static final Predicate<ManagedType> TYPE_IS_PERSISTENT_TYPE = new TypeIsPersistentType();

    protected AbstractPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent);
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.buildSpecifiedTransactionType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.propertyContainer = this.buildPropertyContainer();
        this.initializeProperties();
        this.specifiedMappingFileRefContainer = this.buildSpecifiedMappingFileRefContainer();
        this.potentialImpliedMappingFileRef = this.buildImpliedMappingFileRef();
        this.jarFileRefContainer = this.buildJarFileRefContainer();
        this.specifiedClassRefContainer = this.buildSpecifiedClassRefContainer();
        this.impliedClassRefContainer = this.buildImpliedClassRefContainer();
        this.specifiedSharedCacheMode = this.buildSpecifiedSharedCacheMode();
        this.specifiedValidationMode = this.buildSpecifiedValidationMode();
        this.initializeMetamodelFiles();
        this.initializeChildren();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlPersistenceUnit.getName());
        this.setSpecifiedExcludeUnlistedClasses_(this.xmlPersistenceUnit.getExcludeUnlistedClasses());
        this.setSpecifiedTransactionType_(this.buildSpecifiedTransactionType());
        this.setDescription_(this.xmlPersistenceUnit.getDescription());
        this.setProvider_(this.xmlPersistenceUnit.getProvider());
        this.setJtaDataSource_(this.xmlPersistenceUnit.getJtaDataSource());
        this.setNonJtaDataSource_(this.xmlPersistenceUnit.getNonJtaDataSource());
        this.syncSpecifiedMappingFileRefs();
        this.syncImpliedMappingFileRef();
        this.syncJarFileRefs();
        this.syncSpecifiedClassRefs();
        this.synchronizeModelsWithResourceModel(this.getImpliedClassRefs());
        this.syncProperties();
        this.setSpecifiedSharedCacheMode_(this.buildSpecifiedSharedCacheMode());
        this.setSpecifiedValidationMode_(this.buildSpecifiedValidationMode());
    }

    @Override
    public void update() {
        super.update();
        this.rebuildManagedTypeMap();
        this.setDefaultTransactionType(this.buildDefaultTransactionType());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedClassRefs());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedMappingFileRefs());
        this.updateImpliedMappingFileRef();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getJarFileRefs());
        this.updateImpliedClassRefs();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getProperties());
        this.updatePersistenceUnitMetadata();
        this.setGenerators(this.buildGenerators());
        this.setQueries(this.buildQueries());
        this.setDefaultSharedCacheMode(this.buildDefaultSharedCacheMode());
        this.setDefaultValidationMode(this.buildDefaultValidationMode());
        this.updateChildren();
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
    }

    protected Persistence getPersistence() {
        return (Persistence)this.parent;
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<PersistenceUnit> getType() {
        return PersistenceUnit.class;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    protected void initializeChildren() {
        CollectionTools.addAll(this.children, this.getMappingFileRefs());
        CollectionTools.addAll(this.children, this.getClassRefs());
        CollectionTools.addAll(this.children, this.getJarFileRefs());
    }

    protected void updateChildren() {
        Vector newChildren = new Vector();
        CollectionTools.addAll(newChildren, this.getMappingFileRefs());
        CollectionTools.addAll(newChildren, this.getClassRefs());
        CollectionTools.addAll(newChildren, this.getJarFileRefs());
        this.synchronizeCollection(newChildren, this.children, "children");
    }

    public Iterable<JpaStructureNode> getChildren() {
        return IterableTools.cloneLive(this.children);
    }

    @Override
    public int getChildrenSize() {
        return this.children.size();
    }

    @Override
    public TextRange getFullTextRange() {
        return this.xmlPersistenceUnit.getFullTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JpaStructureNode child : this.getChildren()) {
            if (!child.containsOffset(textOffset)) continue;
            return child;
        }
        return this;
    }

    @Override
    public void dispose() {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.dispose();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlPersistenceUnit.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.specifiedTransactionType != null ? this.specifiedTransactionType : this.defaultTransactionType;
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType transactionType) {
        this.setSpecifiedTransactionType_(transactionType);
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(transactionType));
    }

    protected void setSpecifiedTransactionType_(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.specifiedTransactionType;
        this.specifiedTransactionType = transactionType;
        this.firePropertyChanged("specifiedTransactionType", (Object)old, (Object)transactionType);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.defaultTransactionType;
        this.defaultTransactionType = transactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)old, (Object)transactionType);
    }

    protected PersistenceUnitTransactionType buildSpecifiedTransactionType() {
        return PersistenceUnitTransactionType.fromXmlResourceModel(this.xmlPersistenceUnit.getTransactionType());
    }

    protected PersistenceUnitTransactionType buildDefaultTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlPersistenceUnit.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        this.setProvider_(provider);
        this.xmlPersistenceUnit.setProvider(provider);
    }

    protected void setProvider_(String provider) {
        String old = this.provider;
        this.provider = provider;
        this.firePropertyChanged("provider", old, provider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String jtaDataSource) {
        this.setJtaDataSource_(jtaDataSource);
        this.xmlPersistenceUnit.setJtaDataSource(jtaDataSource);
    }

    protected void setJtaDataSource_(String jtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = jtaDataSource;
        this.firePropertyChanged("jtaDataSource", old, jtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String nonJtaDataSource) {
        this.setNonJtaDataSource_(nonJtaDataSource);
        this.xmlPersistenceUnit.setNonJtaDataSource(nonJtaDataSource);
    }

    protected void setNonJtaDataSource_(String nonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = nonJtaDataSource;
        this.firePropertyChanged("nonJtaDataSource", old, nonJtaDataSource);
    }

    @Override
    public ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefs() : this.getCombinedMappingFileRefs();
    }

    protected ListIterable<MappingFileRef> getCombinedMappingFileRefs() {
        return IterableTools.insert((Object)this.impliedMappingFileRef, this.getSpecifiedMappingFileRefs());
    }

    @Override
    public int getMappingFileRefsSize() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefsSize() : this.getCombinedMappingFileRefsSize();
    }

    protected int getCombinedMappingFileRefsSize() {
        return this.getSpecifiedMappingFileRefsSize() + 1;
    }

    @Override
    public Iterable<MappingFileRef> getMappingFileRefsContaining(String typeName) {
        return IterableTools.filter(this.getMappingFileRefs(), (Predicate)new ManagedTypeContainer.ContainsType(typeName));
    }

    protected Iterable<MappingFile> getMappingFiles() {
        return IterableTools.removeNulls(this.getMappingFiles_());
    }

    protected Iterable<MappingFile> getMappingFiles_() {
        return IterableTools.transform(this.getMappingFileRefs(), MappingFileRef.MAPPING_FILE_TRANSFORMER);
    }

    @Override
    public ListIterable<MappingFileRef> getSpecifiedMappingFileRefs() {
        return this.specifiedMappingFileRefContainer;
    }

    @Override
    public int getSpecifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefContainer.size();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(String fileName) {
        return this.addSpecifiedMappingFileRef(this.getSpecifiedMappingFileRefsSize(), fileName);
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index, String fileName) {
        XmlMappingFileRef xmlMappingFileRef = this.buildXmlMappingFileRef(fileName);
        MappingFileRef mappingFileRef = (MappingFileRef)this.specifiedMappingFileRefContainer.addContextElement(index, xmlMappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        return mappingFileRef;
    }

    protected XmlMappingFileRef buildXmlMappingFileRef(String fileName) {
        XmlMappingFileRef ref = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected MappingFileRef buildSpecifiedMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getContextModelFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefContainer.indexOf(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        this.removeSpecifiedMappingFileRef_(index);
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
    }

    protected void removeSpecifiedMappingFileRef_(int index) {
        this.specifiedMappingFileRefContainer.remove(index);
    }

    protected void syncSpecifiedMappingFileRefs() {
        this.specifiedMappingFileRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlMappingFileRef> getXmlMappingFileRefs() {
        return IterableTools.cloneLive(this.xmlPersistenceUnit.getMappingFiles());
    }

    protected AbstractJpaContextModel.ContextListContainer<MappingFileRef, XmlMappingFileRef> buildSpecifiedMappingFileRefContainer() {
        return new SpecifiedMappingFileRefContainer("specifiedMappingFileRefs", new SpecifiedMappingFileRefContainerAdapter());
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected void setImpliedMappingFileRef(MappingFileRef mappingFileRef) {
        MappingFileRef old = this.impliedMappingFileRef;
        this.impliedMappingFileRef = mappingFileRef;
        this.firePropertyChanged("impliedMappingFileRef", old, mappingFileRef);
    }

    protected MappingFileRef buildImpliedMappingFileRef() {
        return this.getContextModelFactory().buildVirtualMappingFileRef(this);
    }

    protected void syncImpliedMappingFileRef() {
        this.potentialImpliedMappingFileRef.synchronizeWithResourceModel();
    }

    protected void updateImpliedMappingFileRef() {
        if (this.usesImpliedMappingFile()) {
            this.setImpliedMappingFileRef(this.potentialImpliedMappingFileRef);
            this.impliedMappingFileRef.update();
        } else if (this.impliedMappingFileRef != null) {
            this.impliedMappingFileRef.dispose();
            this.setImpliedMappingFileRef(null);
        }
    }

    protected boolean usesImpliedMappingFile() {
        return this.impliedMappingFileIsNotSpecified() && this.impliedMappingFileExists();
    }

    protected boolean impliedMappingFileIsNotSpecified() {
        return !this.impliedMappingFileIsSpecified();
    }

    protected boolean impliedMappingFileIsSpecified() {
        return this.mappingFileIsSpecified("META-INF/orm.xml");
    }

    protected boolean mappingFileIsSpecified(String impliedMappingFileName) {
        for (MappingFileRef specifiedMappingFileRef : this.getSpecifiedMappingFileRefs()) {
            if (!ObjectTools.equals((Object)specifiedMappingFileRef.getFileName(), (Object)impliedMappingFileName)) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        return this.getJpaProject().getDefaultOrmXmlResource() != null;
    }

    @Override
    public ListIterable<JarFileRef> getJarFileRefs() {
        return this.jarFileRefContainer;
    }

    @Override
    public int getJarFileRefsSize() {
        return this.jarFileRefContainer.size();
    }

    @Override
    public JarFileRef addJarFileRef(String fileName) {
        return this.addJarFileRef(this.getJarFileRefsSize(), fileName);
    }

    @Override
    public JarFileRef addJarFileRef(int index, String fileName) {
        XmlJarFileRef xmlJarFileRef = this.buildXmlJarFileRef(fileName);
        JarFileRef jarFileRef = (JarFileRef)this.jarFileRefContainer.addContextElement(index, xmlJarFileRef);
        this.xmlPersistenceUnit.getJarFiles().add(index, (Object)xmlJarFileRef);
        return jarFileRef;
    }

    protected XmlJarFileRef buildXmlJarFileRef(String fileName) {
        XmlJarFileRef ref = PersistenceFactory.eINSTANCE.createXmlJarFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected JarFileRef buildJarFileRef(XmlJarFileRef xmlJarFileRef) {
        return this.getContextModelFactory().buildJarFileRef(this, xmlJarFileRef);
    }

    @Override
    public void removeJarFileRef(JarFileRef jarFileRef) {
        this.removeJarFileRef(this.jarFileRefContainer.indexOf(jarFileRef));
    }

    @Override
    public void removeJarFileRef(int index) {
        this.removeJarFileRef_(index);
        this.xmlPersistenceUnit.getJarFiles().remove(index);
    }

    protected void removeJarFileRef_(int index) {
        this.jarFileRefContainer.remove(index);
    }

    protected void syncJarFileRefs() {
        this.jarFileRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJarFileRef> getXmlJarFileRefs() {
        return IterableTools.cloneLive(this.xmlPersistenceUnit.getJarFiles());
    }

    protected AbstractJpaContextModel.ContextListContainer<JarFileRef, XmlJarFileRef> buildJarFileRefContainer() {
        return this.buildSpecifiedContextListContainer("jarFileRefs", new JarFileRefContainerAdapter());
    }

    @Override
    public Iterable<ClassRef> getClassRefs() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getSpecifiedClassRefs(), this.getImpliedClassRefs()});
    }

    @Override
    public int getClassRefsSize() {
        return this.getSpecifiedClassRefsSize() + this.getImpliedClassRefsSize();
    }

    @Override
    public ListIterable<ClassRef> getSpecifiedClassRefs() {
        return this.specifiedClassRefContainer;
    }

    @Override
    public int getSpecifiedClassRefsSize() {
        return this.specifiedClassRefContainer.size();
    }

    @Override
    public ClassRef addSpecifiedClassRef(String className) {
        return this.addSpecifiedClassRef(this.getSpecifiedClassRefsSize(), className);
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index, String className) {
        XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef(className);
        ClassRef classRef = (ClassRef)this.specifiedClassRefContainer.addContextElement(index, xmlClassRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        return classRef;
    }

    protected Iterable<ClassRef> addSpecifiedClassRefs(Iterable<JavaResourceAbstractType> classNames) {
        return this.addSpecifiedClassRefs(this.getSpecifiedClassRefsSize(), classNames);
    }

    protected Iterable<ClassRef> addSpecifiedClassRefs(int index, Iterable<JavaResourceAbstractType> jrats) {
        ArrayList<XmlJavaClassRef> xmlClassRefs = new ArrayList<XmlJavaClassRef>();
        for (JavaResourceAbstractType jrat : jrats) {
            xmlClassRefs.add(this.buildXmlJavaClassRef(jrat.getTypeBinding().getQualifiedName()));
        }
        Iterable<ClassRef> classRefs = this.specifiedClassRefContainer.addContextElements(index, xmlClassRefs);
        this.xmlPersistenceUnit.getClasses().addAll(index, xmlClassRefs);
        return classRefs;
    }

    protected XmlJavaClassRef buildXmlJavaClassRef(String className) {
        XmlJavaClassRef ref = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        ref.setJavaClass(className);
        return ref;
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getContextModelFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefContainer.indexOf(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        this.removeSpecifiedClassRef_(index);
        this.xmlPersistenceUnit.getClasses().remove(index);
    }

    protected void removeSpecifiedClassRef_(int index) {
        this.specifiedClassRefContainer.remove(index);
    }

    @Override
    public void removeSpecifiedClassRefs(Iterable<ClassRef> classRefs) {
        ArrayList<XmlJavaClassRef> xmlClassRefs = new ArrayList<XmlJavaClassRef>();
        for (ClassRef classRef : classRefs) {
            xmlClassRefs.add(classRef.getXmlClassRef());
        }
        this.specifiedClassRefContainer.removeAll(classRefs);
        this.xmlPersistenceUnit.getClasses().removeAll(xmlClassRefs);
    }

    protected void syncSpecifiedClassRefs() {
        this.specifiedClassRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJavaClassRef> getXmlClassRefs() {
        return IterableTools.cloneLive(this.xmlPersistenceUnit.getClasses());
    }

    protected AbstractJpaContextModel.ContextListContainer<ClassRef, XmlJavaClassRef> buildSpecifiedClassRefContainer() {
        return this.buildSpecifiedContextListContainer("specifiedClassRefs", new SpecifiedClassRefContainerAdapter());
    }

    @Override
    public Iterable<ClassRef> getImpliedClassRefs() {
        return this.impliedClassRefContainer;
    }

    @Override
    public int getImpliedClassRefsSize() {
        return this.impliedClassRefContainer.size();
    }

    protected ClassRef buildClassRef(JavaResourceAbstractType jrat) {
        return this.getContextModelFactory().buildClassRef((PersistenceUnit)this, jrat);
    }

    protected void updateImpliedClassRefs() {
        this.impliedClassRefContainer.update();
    }

    protected Iterable<JavaResourceAbstractType> getImpliedClassResourceTypes() {
        return this.excludesUnlistedClasses() ? EmptyIterable.instance() : this.getImpliedClassResourceTypes_();
    }

    protected Iterable<JavaResourceAbstractType> getImpliedClassResourceTypes_() {
        return IterableTools.filter(this.getJpaProject().getPotentialJavaSourceTypes(), (Predicate)new DoesNotSpecifyManagedType());
    }

    protected AbstractJpaContextModel.ContextCollectionContainer<ClassRef, JavaResourceAbstractType> buildImpliedClassRefContainer() {
        return this.buildVirtualContextCollectionContainer("impliedClassRefs", new ImpliedClassRefContainerAdapter());
    }

    @Override
    public boolean excludesUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses != null ? this.specifiedExcludeUnlistedClasses.booleanValue() : this.getDefaultExcludeUnlistedClasses();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean specifiedExcludeUnlistedClasses) {
        this.setSpecifiedExcludeUnlistedClasses_(specifiedExcludeUnlistedClasses);
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
    }

    protected void setSpecifiedExcludeUnlistedClasses_(Boolean excludeUnlistedClasses) {
        Boolean old = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = excludeUnlistedClasses;
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", old, excludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return false;
    }

    @Override
    public ListIterable<PersistenceUnit.Property> getProperties() {
        return this.propertyContainer;
    }

    @Override
    public int getPropertiesSize() {
        return this.propertyContainer.size();
    }

    @Override
    public PersistenceUnit.Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterable<PersistenceUnit.Property> getPropertiesNamed(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        return IterableTools.filter(this.getProperties(), (Predicate)new PersistenceUnit.Property.NameEquals(propertyName));
    }

    @Override
    public Iterable<PersistenceUnit.Property> getPropertiesWithNamePrefix(String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            throw new NullPointerException();
        }
        return IterableTools.filter(this.getProperties(), (Predicate)new PersistenceUnit.Property.NameStartsWith(propertyNamePrefix));
    }

    @Override
    public PersistenceUnit.Property addProperty() {
        return this.addProperty(this.getPropertiesSize());
    }

    @Override
    public PersistenceUnit.Property addProperty(int index) {
        XmlProperty xmlProperty = this.buildXmlProperty();
        PersistenceUnit.Property property = this.addProperty_(index, xmlProperty);
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            xmlProperties = this.buildXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        xmlProperties.getProperties().add(index, (Object)xmlProperty);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected XmlProperty buildXmlProperty() {
        return PersistenceFactory.eINSTANCE.createXmlProperty();
    }

    protected PersistenceUnit.Property buildProperty(XmlProperty xmlProperty) {
        return this.getContextModelFactory().buildProperty(this, xmlProperty);
    }

    protected XmlProperties buildXmlProperties() {
        return PersistenceFactory.eINSTANCE.createXmlProperties();
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.setProperty(propertyName, value, false);
    }

    @Override
    public void setProperty(String propertyName, String value, boolean duplicatePropertyNamesAllowed) {
        PersistenceUnit.Property prev = this.getProperty(propertyName);
        if (prev == null) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (duplicatePropertyNamesAllowed) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (value == null) {
            this.removeProperty(prev);
        } else {
            prev.setValue(value);
        }
    }

    protected void addProperty(String propertyName, String value) {
        PersistenceUnit.Property property = this.addProperty();
        property.setName(propertyName);
        property.setValue(value);
    }

    @Override
    public void removeProperty(PersistenceUnit.Property property) {
        this.removeProperty(this.propertyContainer.indexOf(property));
    }

    @Override
    public void removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            this.removeProperty(property);
            return;
        }
        throw new IllegalArgumentException("invalid property name: " + propertyName);
    }

    @Override
    public void removeProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName()) || !value.equals(property.getValue())) continue;
            this.removeProperty(property);
            return;
        }
        throw new IllegalArgumentException("invalid property name/value pair: " + propertyName + " = " + value);
    }

    protected void removeProperty(int index) {
        PersistenceUnit.Property removedProperty = this.propertyContainer.remove(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        if (removedProperty.getName() != null) {
            this.propertyRemoved(removedProperty.getName());
        }
    }

    @Override
    public void propertyNameChanged(String oldPropertyName, String newPropertyName, String value) {
        if (oldPropertyName == null && value == null) {
            return;
        }
        if (oldPropertyName != null) {
            this.propertyRemoved(oldPropertyName);
        }
        if (newPropertyName != null) {
            this.propertyAdded(newPropertyName, value);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        this.connection.propertyValueChanged(propertyName, newValue);
        this.options.propertyValueChanged(propertyName, newValue);
        this.schemaGeneration.propertyValueChanged(propertyName, newValue);
    }

    protected void propertyAdded(String propertyName, String value) {
        this.propertyValueChanged(propertyName, value);
    }

    protected void propertyRemoved(String propertyName) {
        this.connection.propertyRemoved(propertyName);
        this.options.propertyRemoved(propertyName);
        this.schemaGeneration.propertyRemoved(propertyName);
    }

    protected void initializeProperties() {
        this.connection = this.buildConnection();
        this.options = this.buildOptions();
        this.schemaGeneration = this.buildSchemaGeneration();
    }

    protected Connection2_0 buildConnection() {
        return this.isPersistenceXml2_0Compatible() ? this.getContextModelFactory2_0().buildConnection(this) : new NullConnection2_0(this);
    }

    protected Options2_0 buildOptions() {
        return this.isPersistenceXml2_0Compatible() ? this.getContextModelFactory2_0().buildOptions(this) : new NullOptions2_0(this);
    }

    protected SchemaGeneration2_1 buildSchemaGeneration() {
        return this.isPersistenceXml2_1Compatible() ? this.getContextModelFactory2_1().buildSchemaGeneration(this) : new NullGenericSchemaGeneration2_1(this);
    }

    protected void syncProperties() {
        this.propertyContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlProperty> getXmlProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties == null ? EmptyListIterable.instance() : IterableTools.cloneLive(xmlProperties.getProperties());
    }

    protected PersistenceUnit.Property addProperty_(int index, XmlProperty xmlProperty) {
        PersistenceUnit.Property property = (PersistenceUnit.Property)this.propertyContainer.addContextElement(index, xmlProperty);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected void removeProperty_(PersistenceUnit.Property property) {
        this.propertyContainer.remove(property);
        if (property.getName() != null) {
            this.propertyRemoved(property.getName());
        }
    }

    protected AbstractJpaContextModel.ContextListContainer<PersistenceUnit.Property, XmlProperty> buildPropertyContainer() {
        return new PropertyContainer("properties", new PropertyContainerAdapter());
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }

    protected void setXmlMappingMetadataComplete(boolean xmlMappingMetadataComplete) {
        boolean old = this.xmlMappingMetadataComplete;
        this.xmlMappingMetadataComplete = xmlMappingMetadataComplete;
        this.firePropertyChanged("xmlMappingMetadataComplete", old, xmlMappingMetadataComplete);
    }

    protected boolean buildXmlMappingMetadataComplete(MappingFilePersistenceUnitMetadata metadata) {
        return metadata == null ? false : metadata.isXmlMappingMetadataComplete();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog(MappingFilePersistenceUnitDefaults defaults) {
        String catalog = defaults == null ? null : defaults.getCatalog();
        return catalog != null ? catalog : this.getJpaProject().getDefaultCatalog();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema(MappingFilePersistenceUnitDefaults defaults) {
        String schema = defaults == null ? null : defaults.getSchema();
        return schema != null ? schema : this.getJpaProject().getDefaultSchema();
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean cascadePersist) {
        boolean old = this.defaultCascadePersist;
        this.defaultCascadePersist = cascadePersist;
        this.firePropertyChanged("defaultCascadePersist", old, cascadePersist);
    }

    protected boolean buildDefaultCascadePersist(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? false : defaults.isCascadePersist();
    }

    @Override
    public boolean getDefaultDelimitedIdentifiers() {
        return this.defaultDelimitedIdentifiers;
    }

    protected void setDefaultDelimitedIdentifiers(boolean delimitedIdentifiers) {
        boolean old = this.defaultDelimitedIdentifiers;
        this.defaultDelimitedIdentifiers = delimitedIdentifiers;
        this.firePropertyChanged("defaultDelimitedIdentifiers", old, delimitedIdentifiers);
    }

    protected boolean buildDefaultDelimitedIdentifiers(MappingFilePersistenceUnitDefaults defaults) {
        return !this.isJpa2_0Compatible() ? false : (defaults == null ? false : ((MappingFilePersistenceUnitDefaults2_0)defaults).isDelimitedIdentifiers());
    }

    protected void updatePersistenceUnitMetadata() {
        MappingFilePersistenceUnitMetadata metadata = this.getMetadata();
        this.setXmlMappingMetadataComplete(this.buildXmlMappingMetadataComplete(metadata));
        MappingFilePersistenceUnitDefaults defaults = metadata == null ? null : metadata.getPersistenceUnitDefaults();
        this.setDefaultAccess(defaults == null ? null : defaults.getAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog(defaults));
        this.setDefaultSchema(this.buildDefaultSchema(defaults));
        this.setDefaultDelimitedIdentifiers(this.buildDefaultDelimitedIdentifiers(defaults));
    }

    protected MappingFilePersistenceUnitMetadata getMetadata() {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitMetadataExists()) continue;
            return mappingFileRef.getPersistenceUnitMetadata();
        }
        return null;
    }

    @Override
    public Connection2_0 getConnection() {
        return this.connection;
    }

    @Override
    public Options2_0 getOptions() {
        return this.options;
    }

    @Override
    public SchemaGeneration2_1 getSchemaGeneration() {
        return this.schemaGeneration;
    }

    @Override
    public SharedCacheMode2_0 getSharedCacheMode() {
        return this.specifiedSharedCacheMode != null ? this.specifiedSharedCacheMode : this.defaultSharedCacheMode;
    }

    @Override
    public SharedCacheMode2_0 getSpecifiedSharedCacheMode() {
        return this.specifiedSharedCacheMode;
    }

    @Override
    public void setSpecifiedSharedCacheMode(SharedCacheMode2_0 specifiedSharedCacheMode) {
        this.setSpecifiedSharedCacheMode_(specifiedSharedCacheMode);
        this.xmlPersistenceUnit.setSharedCacheMode(SharedCacheMode2_0.toXmlResourceModel(specifiedSharedCacheMode));
    }

    protected void setSpecifiedSharedCacheMode_(SharedCacheMode2_0 sharedCacheMode) {
        SharedCacheMode2_0 old = this.specifiedSharedCacheMode;
        this.specifiedSharedCacheMode = sharedCacheMode;
        this.firePropertyChanged("specifiedSharedCacheMode", (Object)old, (Object)sharedCacheMode);
    }

    @Override
    public SharedCacheMode2_0 getDefaultSharedCacheMode() {
        return this.defaultSharedCacheMode;
    }

    protected void setDefaultSharedCacheMode(SharedCacheMode2_0 defaultSharedCacheMode) {
        SharedCacheMode2_0 old = this.defaultSharedCacheMode;
        this.defaultSharedCacheMode = defaultSharedCacheMode;
        this.firePropertyChanged("defaultSharedCacheMode", (Object)old, (Object)defaultSharedCacheMode);
    }

    @Override
    public boolean calculateDefaultCacheable() {
        SharedCacheMode2_0 sharedCacheMode = this.getSharedCacheMode();
        if (sharedCacheMode == null) {
            return false;
        }
        switch (sharedCacheMode) {
            case NONE: 
            case ENABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: {
                return true;
            }
        }
        throw new IllegalStateException("unknown mode: " + (Object)((Object)sharedCacheMode));
    }

    protected SharedCacheMode2_0 buildSpecifiedSharedCacheMode() {
        return SharedCacheMode2_0.fromXmlResourceModel(this.xmlPersistenceUnit.getSharedCacheMode());
    }

    protected SharedCacheMode2_0 buildDefaultSharedCacheMode() {
        return SharedCacheMode2_0.UNSPECIFIED;
    }

    @Override
    public ValidationMode2_0 getValidationMode() {
        return this.specifiedValidationMode != null ? this.specifiedValidationMode : this.defaultValidationMode;
    }

    @Override
    public ValidationMode2_0 getSpecifiedValidationMode() {
        return this.specifiedValidationMode;
    }

    @Override
    public void setSpecifiedValidationMode(ValidationMode2_0 specifiedValidationMode) {
        this.setSpecifiedValidationMode_(specifiedValidationMode);
        this.xmlPersistenceUnit.setValidationMode(ValidationMode2_0.toXmlResourceModel(specifiedValidationMode));
    }

    protected void setSpecifiedValidationMode_(ValidationMode2_0 validationMode) {
        ValidationMode2_0 old = this.specifiedValidationMode;
        this.specifiedValidationMode = validationMode;
        this.firePropertyChanged("specifiedValidationMode", (Object)old, (Object)validationMode);
    }

    @Override
    public ValidationMode2_0 getDefaultValidationMode() {
        return this.defaultValidationMode;
    }

    protected void setDefaultValidationMode(ValidationMode2_0 defaultValidationMode) {
        ValidationMode2_0 old = this.defaultValidationMode;
        this.defaultValidationMode = defaultValidationMode;
        this.firePropertyChanged("defaultValidationMode", (Object)old, (Object)defaultValidationMode);
    }

    protected ValidationMode2_0 buildSpecifiedValidationMode() {
        return ValidationMode2_0.fromXmlResourceModel(this.xmlPersistenceUnit.getValidationMode());
    }

    protected ValidationMode2_0 buildDefaultValidationMode() {
        return DEFAULT_VALIDATION_MODE;
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.cloneLive(this.generators);
    }

    @Override
    public int getGeneratorsSize() {
        return this.generators.size();
    }

    @Override
    public Iterable<String> getUniqueGeneratorNames() {
        return CollectionTools.set(this.getNonEmptyGeneratorNames(), (int)this.getGeneratorsSize());
    }

    protected Iterable<String> getNonEmptyGeneratorNames() {
        return IterableTools.filter(this.getGeneratorNames(), (Predicate)StringTools.IS_NOT_BLANK);
    }

    protected Iterable<String> getGeneratorNames() {
        return new TransformationIterable(this.getGenerators(), JpaNamedContextModel.NAME_TRANSFORMER);
    }

    protected void setGenerators(Iterable<Generator> generators) {
        this.synchronizeCollection(generators, this.generators, "generators");
    }

    protected Iterable<Generator> buildGenerators() {
        ArrayList result = ListTools.list(this.getMappingFileGenerators());
        HashSet<String> mappingFileGeneratorNames = this.convertToNames(result);
        HashMap<String, ArrayList<JavaGenerator>> allJavaGenerators = this.mapByName(this.getAllJavaGenerators());
        for (Map.Entry<String, ArrayList<JavaGenerator>> entry : allJavaGenerators.entrySet()) {
            if (mappingFileGeneratorNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<Generator> getMappingFileGenerators() {
        return IterableTools.children(this.getMappingFileRefs(), MappingFileRef.MAPPING_FILE_GENERATORS_TRANSFORMER);
    }

    protected Iterable<JavaGenerator> getAllJavaGenerators() {
        return IterableTools.children(this.getAllJavaTypeMappingsUnique(), TYPE_MAPPING_JAVA_GENERATORS_TRANSFORMER);
    }

    @Override
    public boolean hasConvertibleJavaGenerators() {
        return !this.getConvertibleJavaGenerators().isEmpty();
    }

    @Override
    public void convertJavaGenerators(EntityMappings entityMappings, IProgressMonitor monitor) {
        ArrayList<JavaGenerator> convertibleJavaGenerators = this.getConvertibleJavaGenerators();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJpaCoreMessages.JAVA_METADATA_CONVERSION_IN_PROGRESS, (int)convertibleJavaGenerators.size());
        for (JavaGenerator generator : convertibleJavaGenerators) {
            this.convertJavaGenerator(entityMappings, generator, subMonitor.newChild(1));
        }
        subMonitor.setTaskName(JptJpaCoreMessages.JAVA_METADATA_CONVERSION_COMPLETE);
    }

    protected void convertJavaGenerator(EntityMappings entityMappings, JavaGenerator generator, SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(JptJpaCoreMessages.JAVA_METADATA_CONVERSION_CANCELED);
        }
        monitor.setTaskName(NLS.bind((String)JptJpaCoreMessages.JAVA_METADATA_CONVERSION_CONVERT_GENERATOR, (Object)generator.getName()));
        generator.convertTo(entityMappings);
        generator.delete();
    }

    protected ArrayList<JavaGenerator> getConvertibleJavaGenerators() {
        return this.extractConvertibleJavaModels(this.getAllJavaGenerators(), this.getMappingFileGenerators());
    }

    @Override
    public Iterable<Query> getQueries() {
        return IterableTools.cloneLive(this.queries);
    }

    @Override
    public int getQueriesSize() {
        return this.queries.size();
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    protected void setQueries(Iterable<Query> queries) {
        this.synchronizeCollection(queries, this.queries, "queries");
    }

    protected Iterable<Query> buildQueries() {
        ArrayList result = ListTools.list(this.getMappingFileQueries());
        HashSet<String> mappingFileQueryNames = this.convertToNames(result);
        HashMap<String, ArrayList<JavaQuery>> allJavaQueries = this.mapByName(this.getAllJavaQueries());
        for (Map.Entry<String, ArrayList<JavaQuery>> entry : allJavaQueries.entrySet()) {
            if (mappingFileQueryNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<Query> getMappingFileQueries() {
        return IterableTools.children(this.getMappingFileRefs(), MappingFileRef.MAPPING_FILE_QUERIES_TRANSFORMER);
    }

    protected Iterable<JavaQuery> getAllJavaQueries() {
        return IterableTools.children(this.getAllJavaTypeMappingsUnique(), TYPE_MAPPING_JAVA_QUERIES_TRANSFORMER);
    }

    protected Iterable<TypeMapping> getAllJavaTypeMappingsUnique() {
        return IterableTools.transform(this.getAllJavaPersistentTypesUnique(), PersistentType.MAPPING_TRANSFORMER);
    }

    @Override
    public boolean hasConvertibleJavaQueries() {
        return !this.getConvertibleJavaQueries().isEmpty();
    }

    @Override
    public void convertJavaQueries(EntityMappings entityMappings, IProgressMonitor monitor) {
        OrmQueryContainer queryContainer = entityMappings.getQueryContainer();
        ArrayList<JavaQuery> convertibleJavaQueries = this.getConvertibleJavaQueries();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJpaCoreMessages.JAVA_METADATA_CONVERSION_IN_PROGRESS, (int)convertibleJavaQueries.size());
        for (JavaQuery query : convertibleJavaQueries) {
            this.convertJavaQuery(queryContainer, query, subMonitor.newChild(1));
        }
        subMonitor.setTaskName(JptJpaCoreMessages.JAVA_METADATA_CONVERSION_COMPLETE);
    }

    protected void convertJavaQuery(OrmQueryContainer queryContainer, JavaQuery query, SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(JptJpaCoreMessages.JAVA_METADATA_CONVERSION_CANCELED);
        }
        monitor.setTaskName(NLS.bind((String)JptJpaCoreMessages.JAVA_METADATA_CONVERSION_CONVERT_QUERY, (Object)query.getName()));
        query.convertTo(queryContainer);
        query.delete();
    }

    protected ArrayList<JavaQuery> getConvertibleJavaQueries() {
        return this.extractConvertibleJavaModels(this.getAllJavaQueries(), this.getMappingFileQueries());
    }

    public Iterable<ManagedType> getManagedTypes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getMappingFileManagedTypes(), this.getClassRefManagedTypes(), this.getJarFileManagedTypes()});
    }

    protected Iterable<ManagedType> getMappingFileManagedTypes() {
        return IterableTools.children(this.getMappingFileRefs(), ManagedTypeContainer.TRANSFORMER);
    }

    public Iterable<ManagedType> getJavaManagedTypes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getClassRefManagedTypes(), this.getJarFileManagedTypes()});
    }

    protected Iterable<ManagedType> getClassRefManagedTypes() {
        return IterableTools.removeNulls(this.getClassRefManagedTypes_());
    }

    protected Iterable<ManagedType> getClassRefManagedTypes_() {
        return IterableTools.transform(this.getClassRefs(), CLASS_REF_MANAGED_TYPE_TRANSFORMER);
    }

    protected Iterable<ManagedType> getJarFileManagedTypes() {
        return IterableTools.children(this.getJarFileRefs(), ManagedTypeContainer.TRANSFORMER);
    }

    @Override
    public ManagedType getManagedType(String typeName) {
        return typeName == null ? null : this.managedTypeMap.get(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildManagedTypeMap() {
        Hashtable<String, ManagedType> hashtable = this.managedTypeMap;
        synchronized (hashtable) {
            this.managedTypeMap.clear();
            for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
                for (ManagedType mt : mappingFileRef.getManagedTypes()) {
                    if (mt.getName() == null || this.managedTypeMap.containsKey(mt.getName())) continue;
                    this.managedTypeMap.put(mt.getName(), mt);
                }
            }
            for (ClassRef classRef : this.getClassRefs()) {
                ManagedType mt;
                mt = classRef.getJavaManagedType();
                if (mt == null || mt.getName() == null || this.managedTypeMap.containsKey(mt.getName())) continue;
                this.managedTypeMap.put(mt.getName(), mt);
            }
            for (JarFileRef jarFileRef : this.getJarFileRefs()) {
                for (ManagedType mt : jarFileRef.getManagedTypes()) {
                    if (mt.getName() == null || this.managedTypeMap.containsKey(mt.getName())) continue;
                    this.managedTypeMap.put(mt.getName(), mt);
                }
            }
        }
    }

    @Override
    public boolean specifiesManagedType(String typeName) {
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return true;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (mappingFileRef.getManagedType(typeName) == null) continue;
            return true;
        }
        return false;
    }

    protected Iterable<PersistentType> getAllJavaPersistentTypesUnique() {
        HashMap<String, PersistentType> map = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getJarFilePersistentTypes(), map);
        this.addPersistentTypesTo(this.getClassRefPersistentTypes(), map);
        this.addPersistentTypesTo(this.getMappingFileJavaPersistentTypes(), map);
        return map.values();
    }

    protected void addPersistentTypesTo(Iterable<? extends PersistentType> persistentTypes, HashMap<String, PersistentType> map) {
        for (PersistentType persistentType : persistentTypes) {
            String ptName = persistentType.getName();
            if (ptName == null) continue;
            map.put(ptName, persistentType);
        }
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes() {
        return IterableTools.removeNulls(this.getMappingFileJavaPersistentTypes_());
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes_() {
        return IterableTools.transform(this.getMappingFilePersistentTypes(), PersistentType.OVERRIDDEN_PERSISTENT_TYPE_TRANSFORMER);
    }

    public Iterable<PersistentType> getPersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        ManagedType mt = this.getManagedType(typeName);
        if (mt != null && (mt.getType() == JavaPersistentType.class || mt.getType() == OrmPersistentType.class)) {
            return (PersistentType)mt;
        }
        return null;
    }

    protected Iterable<PersistentType> getMappingFilePersistentTypes() {
        return IterableTools.children(this.getMappingFileRefs(), PersistentTypeContainer.TRANSFORMER);
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getClassRefManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    protected Iterable<PersistentType> getJarFilePersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJarFileManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    @Override
    public Iterable<PersistentType> getJavaPersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    @Override
    public Entity getEntity(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Embeddable getEmbeddable(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected TypeMapping getTypeMapping(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        return persistentType == null ? null : persistentType.getMapping();
    }

    @Override
    public Iterable<Entity> getEntities() {
        return this.filterToEntities(this.getTypeMappings());
    }

    protected Iterable<Entity> filterToEntities(Iterable<TypeMapping> typeMappings) {
        return new SubIterableWrapper(this.filterToEntities_(typeMappings));
    }

    protected Iterable<TypeMapping> filterToEntities_(Iterable<TypeMapping> typeMappings) {
        return IterableTools.filter(typeMappings, (Predicate)PredicateTools.instanceOf(Entity.class));
    }

    protected Iterable<TypeMapping> getTypeMappings() {
        return IterableTools.transform(this.getPersistentTypes(), PersistentType.MAPPING_TRANSFORMER);
    }

    protected Iterable<Entity> getActiveEntities() {
        return this.filterToEntities(this.getActiveTypeMappings());
    }

    protected Iterable<TypeMapping> getActiveTypeMappings() {
        ArrayList result = ListTools.list(this.getMappingFileTypeMappings());
        HashSet<String> mappingFileClassNames = this.convertToClassNames(result);
        HashMap<String, ArrayList<TypeMapping>> javaTypeMappings = this.mapTypeMappingsByClassName(this.getJavaTypeMappings());
        for (Map.Entry<String, ArrayList<TypeMapping>> entry : javaTypeMappings.entrySet()) {
            if (mappingFileClassNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<TypeMapping> getMappingFileTypeMappings() {
        return IterableTools.transform(this.getMappingFilePersistentTypes(), PersistentType.MAPPING_TRANSFORMER);
    }

    protected HashSet<String> convertToClassNames(Collection<? extends TypeMapping> typeMappings) {
        HashSet<String> classNames = new HashSet<String>(typeMappings.size());
        for (TypeMapping typeMapping : typeMappings) {
            classNames.add(typeMapping.getPersistentType().getName());
        }
        return classNames;
    }

    protected <M extends TypeMapping> HashMap<String, ArrayList<M>> mapTypeMappingsByClassName(Iterable<M> typeMappings) {
        HashMap<String, ArrayList<M>> map = new HashMap<String, ArrayList<M>>();
        for (TypeMapping typeMapping : typeMappings) {
            String typeMappingName = typeMapping.getPersistentType().getName();
            ArrayList<Object> list = map.get(typeMappingName);
            if (list == null) {
                list = new ArrayList();
                map.put(typeMappingName, list);
            }
            list.add(typeMapping);
        }
        return map;
    }

    protected Iterable<TypeMapping> getJavaTypeMappings() {
        return IterableTools.transform(this.getJavaPersistentTypes(), PersistentType.MAPPING_TRANSFORMER);
    }

    @Override
    public void synchronizeClasses(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        HashSet newTypes = CollectionTools.set(this.getJpaProject().getPotentialJavaSourceTypes());
        ArrayList<ClassRef> deadClassRefs = new ArrayList<ClassRef>();
        HashSet<String> mappingFileTypeNames = this.getMappingFileTypeNames();
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            JavaManagedType specifiedJMT = classRef.getJavaManagedType();
            if (specifiedJMT == null) {
                deadClassRefs.add(classRef);
                continue;
            }
            JavaResourceType specifiedType = specifiedJMT.getJavaResourceType();
            if (!newTypes.remove(specifiedType)) {
                deadClassRefs.add(classRef);
                continue;
            }
            if (!mappingFileTypeNames.contains(specifiedType.getTypeBinding().getQualifiedName())) continue;
            deadClassRefs.add(classRef);
        }
        Iterator iterator = newTypes.iterator();
        while (iterator.hasNext()) {
            JavaResourceAbstractType type = (JavaResourceAbstractType)iterator.next();
            if (!mappingFileTypeNames.contains(type.getTypeBinding().getQualifiedName())) continue;
            iterator.remove();
        }
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        this.removeSpecifiedClassRefs(deadClassRefs);
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        this.addSpecifiedClassRefs(newTypes);
        sm.worked(1);
        ECollections.sort(this.getXmlPersistenceUnit().getClasses(), (Comparator)new XmlJavaClassRefNameComp());
        sm.worked(1);
    }

    protected HashSet<String> getMappingFileTypeNames() {
        HashSet<String> result = new HashSet<String>();
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            for (ManagedType managedType : mappingFileRef.getManagedTypes()) {
                result.add(managedType.getName());
            }
        }
        return result;
    }

    @Override
    public void addPersistentTypes(PersistentType.Config[] typeConfigs, boolean listInPersistenceXml, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        this.annotateClasses(typeConfigs, (IProgressMonitor)sm.newChild(6));
        if (listInPersistenceXml) {
            this.listInPersistenceXml(typeConfigs, (IProgressMonitor)sm.newChild(4));
        } else {
            sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
            this.getJpaProject().synchronizeContextModel();
            sm.worked(4);
        }
    }

    protected void annotateClasses(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)typeConfigs.length);
        sm.setTaskName(JptJpaCoreMessages.MAKE_PERSISTENT_PROCESSING_JAVA_CLASSES);
        PersistentType.Config[] configArray = typeConfigs;
        int n = typeConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            PersistentType.Config typeConfig = configArray[n2];
            if (sm.isCanceled()) {
                return;
            }
            String typeName = typeConfig.getName();
            sm.subTask(NLS.bind((String)JptJpaCoreMessages.MAKE_PERSISTENT_ANNOTATING_CLASS, (Object)typeName));
            JavaResourceAbstractType type = this.getJpaProject().getJavaResourceType(typeName);
            type.addAnnotation(this.getJavaTypeMappingDefinition(typeConfig.getMappingKey()).getAnnotationName());
            sm.worked(1);
            ++n2;
        }
    }

    protected void listInPersistenceXml(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)11);
        sm.setTaskName(JptJpaCoreMessages.MAKE_PERSISTENT_LISTING_IN_PERSISTENCE_XML);
        ArrayList<XmlJavaClassRef> addedXmlClassRefs = new ArrayList<XmlJavaClassRef>();
        ArrayList<ClassRef> addedClassRefs = new ArrayList<ClassRef>();
        PersistentType.Config[] configArray = typeConfigs;
        int n = typeConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            PersistentType.Config typeConfig = configArray[n2];
            String typeName = typeConfig.getName();
            XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef(typeName);
            addedXmlClassRefs.add(xmlClassRef);
            addedClassRefs.add(this.buildClassRef(xmlClassRef));
            ++n2;
        }
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
        this.specifiedClassRefContainer.addAll(this.getSpecifiedClassRefsSize(), addedClassRefs);
        sm.worked(5);
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_ADD_TO_PERSISTENCE_XML_RESOURCE_MODEL);
        this.xmlPersistenceUnit.getClasses().addAll(addedXmlClassRefs);
        sm.worked(5);
    }

    protected JavaTypeMappingDefinition getJavaTypeMappingDefinition(String key) {
        for (JavaTypeMappingDefinition definition : this.getJpaPlatform().getJavaTypeMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + key);
    }

    @Override
    public XmlPersistenceUnit getXmlPersistenceUnit() {
        return this.xmlPersistenceUnit;
    }

    protected HashSet<String> convertToNames(Collection<? extends JpaNamedContextModel> nodes) {
        HashSet<String> names = new HashSet<String>(nodes.size());
        for (JpaNamedContextModel jpaNamedContextModel : nodes) {
            names.add(jpaNamedContextModel.getName());
        }
        return names;
    }

    protected <N extends JpaNamedContextModel> HashMap<String, ArrayList<N>> mapByName(Iterable<N> nodes) {
        HashMap<String, ArrayList<N>> map = new HashMap<String, ArrayList<N>>();
        for (JpaNamedContextModel node : nodes) {
            String nodeName = node.getName();
            ArrayList<Object> list = map.get(nodeName);
            if (list == null) {
                list = new ArrayList();
                map.put(nodeName, list);
            }
            list.add(node);
        }
        return map;
    }

    protected <N extends JpaNamedContextModel> ArrayList<N> extractConvertibleJavaModels(Iterable<N> allJavaModels, Iterable<? extends JpaNamedContextModel> mappingFileModels) {
        ArrayList<JpaNamedContextModel> convertibleModels = new ArrayList<JpaNamedContextModel>();
        HashSet<String> mappingFileModelNames = this.convertToNames(ListTools.list(mappingFileModels));
        HashMap<String, ArrayList<N>> allJavaModelsByName = this.mapByName(allJavaModels);
        for (Map.Entry<String, ArrayList<N>> entry : allJavaModelsByName.entrySet()) {
            ArrayList<N> javaModelsWithSameName;
            String javaModelName = entry.getKey();
            if (StringTools.isBlank((String)javaModelName) || (javaModelsWithSameName = entry.getValue()).size() != 1 || mappingFileModelNames.contains(javaModelName)) continue;
            convertibleModels.add((JpaNamedContextModel)javaModelsWithSameName.get(0));
        }
        return convertibleModels;
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public Iterable<String> getPackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        for (ManagedType mType : this.getJavaManagedTypes()) {
            JavaResourceType jrt = mType.getJavaResourceType();
            packageNames.add(jrt.getTypeBinding().getPackageName());
        }
        return packageNames;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingFiles(messages, reporter);
        this.validateClassRefs(messages, reporter);
        this.validateJarFileRefs(messages, reporter);
        this.validateProperties(messages, reporter);
        this.validateGenerators(messages, reporter);
        this.validateQueries(messages, reporter);
        this.validateEntityNames(messages);
    }

    protected void validateMappingFiles(List<IMessage> messages, IReporter reporter) {
        this.checkForMultiplePersistenceUnitMetadata(messages);
        this.checkForDuplicateMappingFileRefs(messages);
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.validate(messages, reporter);
        }
        this.checkForDuplicateMappingFileClasses(messages);
    }

    protected void checkForMultiplePersistenceUnitMetadata(List<IMessage> messages) {
        ArrayList pumdMappingFileRefs = ListTools.list(this.getPersistenceUnitMetadataMappingFileRefs());
        if (pumdMappingFileRefs.size() > 1) {
            for (MappingFileRef mappingFileRef : pumdMappingFileRefs) {
                messages.add(this.buildValidationMessage((JpaModel)mappingFileRef.getMappingFile(), mappingFileRef.getPersistenceUnitMetadata().getValidationTextRange(), JptJpaCoreValidationMessages.MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA, mappingFileRef.getFileName()));
            }
        }
    }

    protected Iterable<MappingFileRef> getPersistenceUnitMetadataMappingFileRefs() {
        return IterableTools.filter(this.getMappingFileRefs(), MappingFileRef.PERSISTENCE_UNIT_METADATA_EXISTS);
    }

    protected void checkForDuplicateMappingFileRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<MappingFileRef>> entry : this.mapMappingFileRefsByFileName().entrySet()) {
            ArrayList<MappingFileRef> dups;
            String fileName = entry.getKey();
            if (!StringTools.isNotBlank((String)fileName) || (dups = entry.getValue()).size() <= 1) continue;
            for (MappingFileRef dup : dups) {
                messages.add(this.buildValidationMessage((JpaModel)dup, dup.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE, fileName));
            }
        }
    }

    protected HashMap<String, ArrayList<MappingFileRef>> mapMappingFileRefsByFileName() {
        HashMap<String, ArrayList<MappingFileRef>> map = new HashMap<String, ArrayList<MappingFileRef>>(this.getMappingFileRefsSize());
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            String fileName = mappingFileRef.getFileName();
            ArrayList<MappingFileRef> list = map.get(fileName);
            if (list == null) {
                list = new ArrayList();
                map.put(fileName, list);
            }
            list.add(mappingFileRef);
        }
        return map;
    }

    protected void checkForDuplicateMappingFileClasses(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<ManagedType>> entry : this.mapMappingFileManagedTypesByName().entrySet()) {
            ArrayList<ManagedType> dups;
            String mtName = entry.getKey();
            if (!StringTools.isNotBlank((String)mtName) || (dups = entry.getValue()).size() <= 1) continue;
            for (ManagedType dup : dups) {
                messages.add(this.buildValidationMessage((JpaModel)dup, dup.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENT_TYPE_DUPLICATE_CLASS, mtName));
            }
        }
    }

    protected HashMap<String, ArrayList<ManagedType>> mapMappingFileManagedTypesByName() {
        HashMap<String, ArrayList<ManagedType>> map = new HashMap<String, ArrayList<ManagedType>>();
        for (ManagedType managedType : this.getMappingFileManagedTypes()) {
            String mtName = managedType.getName();
            ArrayList<ManagedType> list = map.get(mtName);
            if (list == null) {
                list = new ArrayList();
                map.put(mtName, list);
            }
            list.add(managedType);
        }
        return map;
    }

    protected void validateClassRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateClassRefs(messages);
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateClassRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<ClassRef>> entry : this.mapClassRefsByName().entrySet()) {
            ArrayList<ClassRef> dups;
            String className = entry.getKey();
            if (!StringTools.isNotBlank((String)className) || (dups = entry.getValue()).size() <= 1) continue;
            for (ClassRef dup : dups) {
                messages.add(this.buildValidationMessage((JpaModel)dup, dup.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_DUPLICATE_CLASS, className));
            }
        }
    }

    protected HashMap<String, ArrayList<ClassRef>> mapClassRefsByName() {
        HashMap<String, ArrayList<ClassRef>> map = new HashMap<String, ArrayList<ClassRef>>(this.getClassRefsSize());
        for (ClassRef classRef : this.getClassRefs()) {
            String refName = classRef.getClassName();
            ArrayList<ClassRef> list = map.get(refName);
            if (list == null) {
                list = new ArrayList();
                map.put(refName, list);
            }
            list.add(classRef);
        }
        return map;
    }

    protected void validateJarFileRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateJarFileRefs(messages);
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            jarFileRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateJarFileRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<JarFileRef>> entry : this.mapJarFileRefsByName().entrySet()) {
            ArrayList<JarFileRef> dups;
            String fileName = entry.getKey();
            if (!StringTools.isNotBlank((String)fileName) || (dups = entry.getValue()).size() <= 1) continue;
            for (JarFileRef dup : dups) {
                messages.add(this.buildValidationMessage((JpaModel)dup, dup.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_DUPLICATE_JAR_FILE, fileName));
            }
        }
    }

    protected HashMap<String, ArrayList<JarFileRef>> mapJarFileRefsByName() {
        HashMap<String, ArrayList<JarFileRef>> map = new HashMap<String, ArrayList<JarFileRef>>(this.getJarFileRefsSize());
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            String refName = jarFileRef.getFileName();
            ArrayList<JarFileRef> list = map.get(refName);
            if (list == null) {
                list = new ArrayList();
                map.put(refName, list);
            }
            list.add(jarFileRef);
        }
        return map;
    }

    protected abstract void validateProperties(List<IMessage> var1, IReporter var2);

    protected void validateGenerators(List<IMessage> messages, IReporter reporter) {
        this.checkForGeneratorsWithSameName(messages);
        for (Generator generator : this.getGenerators()) {
            this.validate(generator, messages, reporter);
        }
    }

    protected void checkForGeneratorsWithSameName(List<IMessage> messages) {
        HashMap<String, ArrayList<Generator>> generatorsByName = this.mapByName(this.getGenerators());
        for (Map.Entry<String, ArrayList<Generator>> entry : generatorsByName.entrySet()) {
            ArrayList<Generator> dups;
            String generatorName = entry.getKey();
            if (!StringTools.isNotBlank((String)generatorName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateGeneratorsWithSameName(generatorName, dups, messages);
        }
    }

    protected void validateGeneratorsWithSameName(String generatorName, ArrayList<Generator> dups, List<IMessage> messages) {
        for (Generator dup : dups) {
            if (!dup.supportsValidationMessages()) continue;
            messages.add(this.buildValidationMessage((JpaModel)dup, dup.getNameTextRange(), JptJpaCoreValidationMessages.GENERATOR_DUPLICATE_NAME, generatorName));
        }
    }

    protected void validate(Generator generator, List<IMessage> messages, IReporter reporter) {
        if (generator.supportsValidationMessages()) {
            generator.validate(messages, reporter);
        }
    }

    protected void validateQueries(List<IMessage> messages, IReporter reporter) {
        this.checkForQueriesWithSameName(messages);
        JpaJpqlQueryHelper queryHelper = this.createJpqlQueryHelper();
        for (Query query : this.getQueries()) {
            this.validate(query, queryHelper, messages, reporter);
        }
    }

    protected void checkForQueriesWithSameName(List<IMessage> messages) {
        HashMap<String, ArrayList<Query>> queriesByName = this.mapByName(this.getQueries());
        for (Map.Entry<String, ArrayList<Query>> entry : queriesByName.entrySet()) {
            ArrayList<Query> dups;
            String queryName = entry.getKey();
            if (!StringTools.isNotBlank((String)queryName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateQueriesWithSameName(queryName, dups, messages);
        }
    }

    protected void validateQueriesWithSameName(String queryName, ArrayList<Query> dups, List<IMessage> messages) {
        for (Query dup : dups) {
            if (!dup.supportsValidationMessages()) continue;
            messages.add(this.buildValidationMessage((JpaModel)dup, dup.getNameTextRange(), JptJpaCoreValidationMessages.QUERY_DUPLICATE_NAME, queryName));
        }
    }

    protected void validate(Query query, JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        if (query.supportsValidationMessages()) {
            query.validate(queryHelper, messages, reporter);
        }
    }

    protected void validateEntityNames(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<Entity>> entry : this.mapTypeMappingsByName(this.getActiveEntities()).entrySet()) {
            ArrayList<Entity> dups;
            String entityName = entry.getKey();
            if (!StringTools.isNotBlank((String)entityName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateEntitiesWithSameName(entityName, dups, messages);
        }
    }

    protected <M extends TypeMapping> HashMap<String, ArrayList<M>> mapTypeMappingsByName(Iterable<M> typeMappings) {
        HashMap<String, ArrayList<M>> map = new HashMap<String, ArrayList<M>>();
        for (TypeMapping typeMapping : typeMappings) {
            String typeMappingName = typeMapping.getName();
            ArrayList<Object> list = map.get(typeMappingName);
            if (list == null) {
                list = new ArrayList();
                map.put(typeMappingName, list);
            }
            list.add(typeMapping);
        }
        return map;
    }

    protected void validateEntitiesWithSameName(String entityName, ArrayList<Entity> dups, List<IMessage> messages) {
        for (Entity dup : dups) {
            if (!dup.supportsValidationMessages()) continue;
            messages.add(this.buildValidationMessage((JpaModel)dup, dup.getNameTextRange(), JptJpaCoreValidationMessages.ENTITY_NAME_DUPLICATED, entityName));
        }
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlPersistenceUnit.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistence().getValidationTextRange();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return IterableTools.children(this.getSpecifiedClassRefs(), (Transformer)new DeleteTypeRefactoringParticipant.DeleteTypeEditsTransformer(type));
    }

    @Override
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(IFile file) {
        return IterableTools.children(this.getSpecifiedMappingFileRefs(), (Transformer)new MappingFileRefactoringParticipant.DeleteMappingFileEditsTransformer(file));
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createSpecifiedClassRefRenameTypeEdits(originalType, newName), this.createPersistenceUnitPropertiesRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.children(this.getSpecifiedClassRefs(), (Transformer)new TypeRefactoringParticipant.RenameTypeEditsTransformer(originalType, newName));
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenameTypeEdits(IType originalType, String newName) {
        return this.options.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createSpecifiedClassRefMoveTypeEdits(originalType, newPackage), this.createPersistenceUnitPropertiesMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.children(this.getSpecifiedClassRefs(), (Transformer)new TypeRefactoringParticipant.MoveTypeEditsTransformer(originalType, newPackage));
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.options.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createSpecifiedClassRefRenamePackageEdits(originalPackage, newName), this.createPersistenceUnitPropertiesRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.children(this.getSpecifiedClassRefs(), (Transformer)new TypeRefactoringParticipant.RenamePackageEditsTransformer(originalPackage, newName));
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.options.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder originalFolder, String newName) {
        return this.createMappingFileRefRenameFolderEdits(originalFolder, newName);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefRenameFolderEdits(IFolder originalFolder, String newName) {
        return IterableTools.children(this.getSpecifiedMappingFileRefs(), (Transformer)new MappingFileRefactoringParticipant.RenameFolderEditsTransformer(originalFolder, newName));
    }

    @Override
    public Iterable<ReplaceEdit> createRenameMappingFileEdits(IFile originalFile, String newName) {
        return IterableTools.children(this.getSpecifiedMappingFileRefs(), (Transformer)new MappingFileRefactoringParticipant.RenameMappingFileEditsTransformer(originalFile, newName));
    }

    @Override
    public int findInsertLocationForMappingFileRef() {
        return this.xmlPersistenceUnit.getLocationToInsertMappingFileRef();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveMappingFileEdits(IFile originalFile, IPath destination) {
        return IterableTools.children(this.getMappingFileRefs(), (Transformer)new MappingFileRefactoringParticipant.MoveMappingFileEditsTransformer(originalFile, destination));
    }

    @Override
    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder originalFolder, IPath runtimeDestination) {
        return this.createMappingFileRefMoveFolderReplaceEdits(originalFolder, runtimeDestination);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefMoveFolderReplaceEdits(IFolder originalFolder, IPath destination) {
        return IterableTools.children(this.getMappingFileRefs(), (Transformer)new MappingFileRefactoringParticipant.MoveFolderEditsTransformer(originalFolder, destination));
    }

    @Override
    public void initializeMetamodel() {
        this.initializeMetamodelFiles_();
    }

    protected void initializeMetamodelFiles() {
        if (this.isJpa2_0Compatible()) {
            this.initializeMetamodelFiles_();
        }
    }

    protected void initializeMetamodelFiles_() {
        CollectionTools.addAll(this.metamodelFiles, this.getGeneratedMetamodelFiles());
    }

    protected Iterable<IFile> getGeneratedMetamodelFiles() {
        return IterableTools.transform(this.getGeneratedMetamodelTopLevelTypes(), (Transformer)JavaResourceModel.FILE_TRANSFORMER);
    }

    protected Iterable<JavaResourceAbstractType> getGeneratedMetamodelTopLevelTypes() {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelTypes();
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        HashMap<String, PersistentType> allPersistentTypes = this.getMetamodelPersistentTypes();
        ArrayList<MetamodelSourceType2_0> topLevelTypes = new ArrayList<MetamodelSourceType2_0>(allPersistentTypes.size());
        HashMap<String, Collection<MetamodelSourceType2_0>> memberTypeTree = new HashMap<String, Collection<MetamodelSourceType2_0>>();
        block0: for (PersistentType type1_0 : allPersistentTypes.values()) {
            PersistentType2_0 type = (PersistentType2_0)type1_0;
            String declaringTypeName = type.getDeclaringTypeName();
            MetamodelSourceType2_0 memberType = type;
            while (true) {
                IType jdtDeclaringType;
                IType jdtType;
                JavaResourceAbstractType jrat;
                if (declaringTypeName == null) {
                    topLevelTypes.add(memberType);
                    continue block0;
                }
                ArrayList<PersistentType2_0> memberTypes = (ArrayList<PersistentType2_0>)memberTypeTree.get(declaringTypeName);
                if (memberTypes == null) {
                    memberTypes = new ArrayList<PersistentType2_0>();
                    memberTypeTree.put(declaringTypeName, memberTypes);
                }
                memberTypes.add((PersistentType2_0)memberType);
                String memberTypeName = declaringTypeName;
                memberType = (PersistentType2_0)allPersistentTypes.get(memberTypeName);
                if (memberType != null || (memberType = (declaringTypeName = (jrat = this.getJpaProject().getJavaResourceType(memberTypeName)) != null ? jrat.getDeclaringTypeName() : ((jdtType = this.findJdtType(memberTypeName)) != null ? ((jdtDeclaringType = jdtType.getDeclaringType()) == null ? null : jdtDeclaringType.getFullyQualifiedName('.')) : null)) == null ? this.selectSourceType(topLevelTypes, memberTypeName) : this.selectSourceType((Iterable)memberTypeTree.get(declaringTypeName), memberTypeName)) != null) continue block0;
                memberType = this.buildNonPersistentMetamodelSourceType(memberTypeName);
            }
        }
        Collections.sort(topLevelTypes, MetamodelSourceType2_0.COMPARATOR);
        HashSet<String> names = new HashSet<String>(topLevelTypes.size());
        Iterator stream = topLevelTypes.iterator();
        while (stream.hasNext()) {
            MetamodelSourceType2_0 topLevelType = (MetamodelSourceType2_0)stream.next();
            if (names.add(topLevelType.getName().toLowerCase())) continue;
            stream.remove();
        }
        HashSet<IFile> deadMetamodelFiles = new HashSet<IFile>(this.metamodelFiles);
        this.metamodelFiles.clear();
        for (MetamodelSourceType2_0 topLevelType : topLevelTypes) {
            IFile metamodelFile = topLevelType.getMetamodelFile();
            deadMetamodelFiles.remove(metamodelFile);
            if (!this.fileIsGeneratedMetamodel(metamodelFile)) continue;
            this.metamodelFiles.add(metamodelFile);
        }
        for (IFile deadMetamodelFile : deadMetamodelFiles) {
            this.deleteMetamodelFile(deadMetamodelFile);
        }
        for (MetamodelSourceType2_0 topLevelType : topLevelTypes) {
            topLevelType.synchronizeMetamodel(memberTypeTree);
        }
        return Status.OK_STATUS;
    }

    protected HashMap<String, PersistentType> getMetamodelPersistentTypes() {
        HashMap<String, PersistentType> allPersistentTypes = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getMetamodelJarFilePersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getMetamodelClassRefPersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getMetamodelMappingFilePersistentTypes(), allPersistentTypes);
        return allPersistentTypes;
    }

    protected Iterable<PersistentType2_0> getMetamodelJarFilePersistentTypes() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getJarFilePersistentTypes2_0(), PersistentType2_0.METAMODEL_TYPE_TRANSFORMER));
    }

    protected Iterable<PersistentType2_0> getJarFilePersistentTypes2_0() {
        return IterableTools.downCast(this.getJarFilePersistentTypes());
    }

    protected Iterable<PersistentType2_0> getMetamodelClassRefPersistentTypes() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getClassRefPersistentTypes2_0(), PersistentType2_0.METAMODEL_TYPE_TRANSFORMER));
    }

    protected Iterable<PersistentType2_0> getClassRefPersistentTypes2_0() {
        return IterableTools.downCast(this.getClassRefPersistentTypes());
    }

    protected Iterable<PersistentType2_0> getMetamodelMappingFilePersistentTypes() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getMappingFilePersistentTypes2_0(), PersistentType2_0.METAMODEL_TYPE_TRANSFORMER));
    }

    protected Iterable<PersistentType2_0> getMappingFilePersistentTypes2_0() {
        return IterableTools.downCast(this.getMappingFilePersistentTypes());
    }

    protected MetamodelSourceType2_0 selectSourceType(Iterable<MetamodelSourceType2_0> types, String typeName) {
        if (types != null) {
            for (MetamodelSourceType2_0 type : types) {
                if (!type.getName().equals(typeName)) continue;
                return type;
            }
        }
        return null;
    }

    protected MetamodelSourceType2_0 buildNonPersistentMetamodelSourceType(String nonPersistentTypeName) {
        return new NonPersistentMetamodelSourceType(nonPersistentTypeName, this.getJpaProject());
    }

    protected IType findJdtType(String typeName) {
        try {
            return this.getJpaProject().getJavaProject().findType(typeName);
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return null;
        }
    }

    protected void deleteMetamodelFile(IFile file) {
        try {
            this.deleteMetamodelFile_(file);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    protected void deleteMetamodelFile_(IFile file) throws CoreException {
        if (this.fileIsGeneratedMetamodel(file)) {
            file.delete(true, null);
        }
    }

    protected boolean fileIsGeneratedMetamodel(IFile file) {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelType(file) != null;
    }

    @Override
    public void disposeMetamodel() {
        this.metamodelFiles.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DoesNotSpecifyManagedType
    extends PredicateAdapter<JavaResourceAbstractType> {
        public boolean evaluate(JavaResourceAbstractType jrat) {
            return !AbstractPersistenceUnit.this.specifiesManagedType(jrat.getTypeBinding().getQualifiedName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImpliedClassRefContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<ClassRef, JavaResourceAbstractType> {
        @Override
        public ClassRef buildContextElement(JavaResourceAbstractType resourceElement) {
            return AbstractPersistenceUnit.this.buildClassRef(resourceElement);
        }

        @Override
        public Iterable<JavaResourceAbstractType> getResourceElements() {
            return AbstractPersistenceUnit.this.getImpliedClassResourceTypes();
        }

        @Override
        public JavaResourceAbstractType extractResourceElement(ClassRef contextElement) {
            return contextElement.getJavaResourceType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JarFileRefContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JarFileRef, XmlJarFileRef> {
        @Override
        public JarFileRef buildContextElement(XmlJarFileRef resourceElement) {
            return AbstractPersistenceUnit.this.buildJarFileRef(resourceElement);
        }

        @Override
        public ListIterable<XmlJarFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlJarFileRefs();
        }

        @Override
        public XmlJarFileRef extractResourceElement(JarFileRef contextElement) {
            return contextElement.getXmlJarFileRef();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonPersistentMetamodelSourceType
    implements MetamodelSourceType2_0 {
        protected final String name;
        protected final JpaProject jpaProject;
        protected final MetamodelSourceType2_0.Synchronizer metamodelSynchronizer;

        protected NonPersistentMetamodelSourceType(String name, JpaProject jpaProject) {
            this.name = name;
            this.jpaProject = jpaProject;
            this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
        }

        protected MetamodelSourceType2_0.Synchronizer buildMetamodelSynchronizer() {
            return this.getJpaFactory().buildMetamodelSynchronizer(this);
        }

        protected JpaFactory2_0 getJpaFactory() {
            return (JpaFactory2_0)this.getJpaProject().getJpaPlatform().getJpaFactory();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public PersistentType getSuperPersistentType() {
            return null;
        }

        @Override
        public ListIterable<? extends PersistentAttribute> getAttributes() {
            return EmptyListIterable.instance();
        }

        @Override
        public IFile getMetamodelFile() {
            return this.metamodelSynchronizer.getFile();
        }

        @Override
        public JpaProject getJpaProject() {
            return this.jpaProject;
        }

        @Override
        public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }

        @Override
        public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyContainer
    extends AbstractJpaContextModel.SpecifiedContextListContainer<PersistenceUnit.Property, XmlProperty> {
        public PropertyContainer(String aspectName, AbstractJpaContextModel.Container.Adapter<PersistenceUnit.Property, XmlProperty> adapter) {
            super(aspectName, adapter);
        }

        @Override
        protected PersistenceUnit.Property add(int index, PersistenceUnit.Property element) {
            super.add(index, element);
            if (element.getName() != null) {
                AbstractPersistenceUnit.this.propertyAdded(element.getName(), element.getValue());
            }
            return element;
        }

        @Override
        public void clear() {
            Object[] temp = this.elements.toArray();
            super.clear();
            Object[] objectArray = temp;
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.dispose((PersistenceUnit.Property)element);
                ++n2;
            }
        }

        @Override
        public PersistenceUnit.Property remove(int index) {
            PersistenceUnit.Property element = (PersistenceUnit.Property)super.remove(index);
            this.dispose(element);
            return element;
        }

        @Override
        public void remove(PersistenceUnit.Property element) {
            super.remove(element);
            this.dispose(element);
        }

        @Override
        public void removeAll(Iterable<PersistenceUnit.Property> contextElements) {
            super.removeAll(contextElements);
            for (PersistenceUnit.Property element : contextElements) {
                this.dispose(element);
            }
        }

        protected void dispose(PersistenceUnit.Property element) {
            if (element.getName() != null) {
                AbstractPersistenceUnit.this.propertyRemoved(element.getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<PersistenceUnit.Property, XmlProperty> {
        @Override
        public PersistenceUnit.Property buildContextElement(XmlProperty resourceElement) {
            return AbstractPersistenceUnit.this.buildProperty(resourceElement);
        }

        @Override
        public ListIterable<XmlProperty> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlProperties();
        }

        @Override
        public XmlProperty extractResourceElement(PersistenceUnit.Property contextElement) {
            return contextElement.getXmlProperty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedClassRefContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<ClassRef, XmlJavaClassRef> {
        @Override
        public ClassRef buildContextElement(XmlJavaClassRef resourceElement) {
            return AbstractPersistenceUnit.this.buildClassRef(resourceElement);
        }

        @Override
        public ListIterable<XmlJavaClassRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlClassRefs();
        }

        @Override
        public XmlJavaClassRef extractResourceElement(ClassRef contextElement) {
            return contextElement.getXmlClassRef();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedMappingFileRefContainer
    extends AbstractJpaContextModel.SpecifiedContextListContainer<MappingFileRef, XmlMappingFileRef> {
        public SpecifiedMappingFileRefContainer(String aspectName, AbstractJpaContextModel.Container.Adapter<MappingFileRef, XmlMappingFileRef> adapter) {
            super(aspectName, adapter);
        }

        @Override
        public void clear() {
            Object[] temp = this.elements.toArray();
            super.clear();
            Object[] objectArray = temp;
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ((MappingFileRef)element).dispose();
                ++n2;
            }
        }

        @Override
        public MappingFileRef remove(int index) {
            MappingFileRef element = (MappingFileRef)super.remove(index);
            element.dispose();
            return element;
        }

        @Override
        public void remove(MappingFileRef element) {
            super.remove(element);
            element.dispose();
        }

        @Override
        public void removeAll(Iterable<MappingFileRef> contextElements) {
            super.removeAll(contextElements);
            for (MappingFileRef element : contextElements) {
                element.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedMappingFileRefContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<MappingFileRef, XmlMappingFileRef> {
        @Override
        public MappingFileRef buildContextElement(XmlMappingFileRef resourceElement) {
            return AbstractPersistenceUnit.this.buildSpecifiedMappingFileRef(resourceElement);
        }

        @Override
        public ListIterable<XmlMappingFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlMappingFileRefs();
        }

        @Override
        public XmlMappingFileRef extractResourceElement(MappingFileRef contextElement) {
            return contextElement.getXmlMappingFileRef();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeIsPersistentType
    extends PredicateAdapter<ManagedType> {
        public boolean evaluate(ManagedType mt) {
            return PersistentType.class.isAssignableFrom(mt.getType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XmlJavaClassRefNameComp
    implements Comparator<XmlJavaClassRef> {
        @Override
        public int compare(XmlJavaClassRef xjcr1, XmlJavaClassRef xjcr2) {
            return xjcr1.getJavaClass().compareTo(xjcr2.getJavaClass());
        }
    }
}

