/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextModel;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryHint;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<X extends XmlQuery>
extends AbstractOrmXmlContextModel<JpaContextModel>
implements OrmQuery {
    protected final X xmlQuery;
    protected String name;
    protected final AbstractJpaContextModel.ContextListContainer<OrmQueryHint, XmlQueryHint> hintContainer;

    protected AbstractOrmQuery(JpaContextModel parent, X xmlQuery) {
        super(parent);
        this.xmlQuery = xmlQuery;
        this.name = xmlQuery.getName();
        this.hintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlQuery.getName());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlQuery.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public ListIterable<OrmQueryHint> getHints() {
        return this.hintContainer;
    }

    @Override
    public int getHintsSize() {
        return this.hintContainer.size();
    }

    @Override
    public OrmQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint xmlHint = this.buildXmlQueryHint();
        OrmQueryHint hint = (OrmQueryHint)this.hintContainer.addContextElement(index, xmlHint);
        this.xmlQuery.getHints().add(index, (Object)xmlHint);
        return hint;
    }

    protected XmlQueryHint buildXmlQueryHint() {
        return OrmFactory.eINSTANCE.createXmlQueryHint();
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.hintContainer.indexOf((OrmQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.hintContainer.remove(index);
        this.xmlQuery.getHints().remove(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.hintContainer.move(targetIndex, sourceIndex);
        this.xmlQuery.getHints().move(targetIndex, sourceIndex);
    }

    @Override
    public OrmQueryHint getHint(int index) {
        return (OrmQueryHint)this.hintContainer.get(index);
    }

    protected OrmQueryHint buildHint(XmlQueryHint xmlHint) {
        return this.getContextModelFactory().buildOrmQueryHint(this, xmlHint);
    }

    protected void syncHints() {
        this.hintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlQueryHint> getXmlHints() {
        return IterableTools.cloneLive(this.xmlQuery.getHints());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmQueryHint, XmlQueryHint> buildHintContainer() {
        return this.buildSpecifiedContextListContainer("hints", new HintContainerAdapter());
    }

    public void convertFrom(JavaQuery javaQuery) {
        this.setName(javaQuery.getName());
        for (JavaQueryHint javaQueryHint : javaQuery.getHints()) {
            this.addHint().convertFrom(javaQueryHint);
        }
    }

    @Override
    public boolean supportsValidationMessages() {
        return true;
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.name)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.QUERY_NAME_UNDEFINED));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlQuery.getValidationTextRange();
        return textRange != null ? textRange : ((JpaContextModel)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getNameTextRange());
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextModel node) {
        return this != node && this.getType() == node.getType() && this.isEquivalentTo((Query)node);
    }

    protected boolean isEquivalentTo(Query other) {
        return ObjectTools.equals((Object)this.name, (Object)other.getName()) && this.hintsAreEquivalentTo(other);
    }

    protected boolean hintsAreEquivalentTo(Query other) {
        ArrayList hints1 = ListTools.list(this.getHints());
        ArrayList hints2 = ListTools.list(other.getHints());
        if (hints1.size() != hints2.size()) {
            return false;
        }
        int i = 0;
        while (i < hints1.size()) {
            if (!((OrmQueryHint)hints1.get(i)).isEquivalentTo((QueryHint)hints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public X getXmlQuery() {
        return this.xmlQuery;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmQueryHint, XmlQueryHint> {
        @Override
        public OrmQueryHint buildContextElement(XmlQueryHint resourceElement) {
            return AbstractOrmQuery.this.buildHint(resourceElement);
        }

        @Override
        public ListIterable<XmlQueryHint> getResourceElements() {
            return AbstractOrmQuery.this.getXmlHints();
        }

        @Override
        public XmlQueryHint extractResourceElement(OrmQueryHint contextElement) {
            return contextElement.getXmlQueryHint();
        }
    }
}

