/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingTools {
    public static final Transformer<TypeMapping, Iterable<AttributeMapping>> ATTRIBUTE_MAPPINGS_TRANSFORMER = new AttributeMappingsTransformer();
    public static final Transformer<TypeMapping, Iterable<Table>> ASSOCIATED_TABLES_TRANSFORMER = new AssociatedTablesTransformer();
    public static final Transformer<TypeMapping, Iterable<String>> OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER = new OverridableAttributeNamesTransformer();
    public static final Transformer<TypeMapping, Iterable<String>> OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER = new OverridableAssociationNamesTransformer();

    public static boolean attributeIsDerivedId(TypeMapping typeMapping, String attributeName) {
        if (attributeName == null) {
            return false;
        }
        int dotIndex = attributeName.indexOf(46);
        attributeName = dotIndex == -1 ? attributeName : attributeName.substring(0, dotIndex);
        return IterableTools.contains(TypeMappingTools.getMapsIdDerivedIdAttributeNames(typeMapping), (Object)attributeName);
    }

    protected static Iterable<String> getMapsIdDerivedIdAttributeNames(TypeMapping typeMapping) {
        return IterableTools.transform(TypeMappingTools.getMapsIdDerivedIdentityStrategies(typeMapping), MapsIdDerivedIdentityStrategy2_0.ID_ATTRIBUTE_NAME_TRANSFORMER);
    }

    protected static Iterable<MapsIdDerivedIdentityStrategy2_0> getMapsIdDerivedIdentityStrategies(TypeMapping typeMapping) {
        return IterableTools.transform(TypeMappingTools.getMapsIdDerivedIdentities(typeMapping), DerivedIdentity2_0.MAPS_ID_DERIVED_IDENTITY_STRATEGY_TRANSFORMER);
    }

    protected static Iterable<DerivedIdentity2_0> getMapsIdDerivedIdentities(TypeMapping typeMapping) {
        return IterableTools.filter(TypeMappingTools.getDerivedIdentities(typeMapping), DerivedIdentity2_0.USES_MAPS_ID_DERIVED_IDENTITY_STRATEGY);
    }

    protected static Iterable<DerivedIdentity2_0> getDerivedIdentities(TypeMapping typeMapping) {
        return IterableTools.transform(TypeMappingTools.getSingleRelationshipMappings(typeMapping), SingleRelationshipMapping2_0.DERIVED_IDENTITY_TRANSFORMER);
    }

    protected static Iterable<SingleRelationshipMapping2_0> getSingleRelationshipMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(TypeMappingTools.getSingleRelationshipMappings_(typeMapping));
    }

    protected static Iterable<AttributeMapping> getSingleRelationshipMappings_(TypeMapping typeMapping) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")});
    }

    private TypeMappingTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AssociatedTablesTransformer
    extends TransformerAdapter<TypeMapping, Iterable<Table>> {
        AssociatedTablesTransformer() {
        }

        public Iterable<Table> transform(TypeMapping mapping) {
            return mapping.getAssociatedTables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeMappingsTransformer
    extends TransformerAdapter<TypeMapping, Iterable<AttributeMapping>> {
        AttributeMappingsTransformer() {
        }

        public Iterable<AttributeMapping> transform(TypeMapping mapping) {
            return mapping.getAttributeMappings();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAssociationNamesTransformer
    extends TransformerAdapter<TypeMapping, Iterable<String>> {
        OverridableAssociationNamesTransformer() {
        }

        public Iterable<String> transform(TypeMapping mapping) {
            return mapping.getOverridableAssociationNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAttributeNamesTransformer
    extends TransformerAdapter<TypeMapping, Iterable<String>> {
        OverridableAttributeNamesTransformer() {
        }

        public Iterable<String> transform(TypeMapping mapping) {
            return mapping.getOverridableAttributeNames();
        }
    }
}

