/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.vbundle.wadl;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.JaxrsException;
import oracle.eclipse.tools.jaxrs.wadl.IWadl2Java;
import org.jvnet.ws.wadl2java.Wadl2Java;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;

public class Wadl2JavaImpl
implements IWadl2Java {
    private String generationStyle = "jersey1x";
    private String pkg;
    private boolean autoPackage;
    private File target;
    private URI desc;
    private List<File> producedFileSets;
    private List<File> consumedFileSets;
    private List<File> customizationFileSets;
    private List<IWadl2Java.ClassNameMapper> customClassNames = new ArrayList<IWadl2Java.ClassNameMapper>();

    public IWadl2Java.ClassNameMapper createCustomClassName() {
        IWadl2Java.ClassNameMapper mapper = new IWadl2Java.ClassNameMapper();
        this.customClassNames.add(mapper);
        return mapper;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public void setGenerationStyle(String generationStyle) {
        this.generationStyle = generationStyle;
    }

    public void setAutoSchemaPackage(boolean auto) {
        this.autoPackage = auto;
    }

    public void setDescription(URI desc) {
        this.desc = desc;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void addConfiguredProduces(File fileset) {
        this.producedFileSets.add(fileset);
    }

    public void addConfiguredCustomizations(File fileset) {
        this.customizationFileSets.add(fileset);
    }

    public void addConfiguredDepends(File fileset) {
        this.consumedFileSets.add(fileset);
    }

    public void init() throws JaxrsException {
        this.pkg = null;
        this.autoPackage = false;
        this.target = null;
        this.desc = null;
        this.producedFileSets = new ArrayList<File>();
        this.consumedFileSets = new ArrayList<File>();
        this.customizationFileSets = new ArrayList<File>();
    }

    public void execute() throws JaxrsException {
        if (this.pkg == null) {
            throw new JaxrsException(Wadl2JavaMessages.PACKAGE_ATTRIBUTE_REQUIRED());
        }
        if (this.target == null) {
            throw new JaxrsException(Wadl2JavaMessages.TARGET_ATTRIBUTE_REQUIRED());
        }
        if (!this.target.exists()) {
            throw new JaxrsException(Wadl2JavaMessages.TARGET_DIRECTORY_MUST_EXIST((Object)this.target.toString()));
        }
        if (!this.target.isDirectory()) {
            throw new JaxrsException(Wadl2JavaMessages.TARGET_ATTRIBUTE_DIRECTORY((Object)this.target.toString()));
        }
        if (this.desc == null) {
            throw new JaxrsException(Wadl2JavaMessages.DESCRIPTION_REQUIRED());
        }
        ArrayList<File> customizations = new ArrayList<File>();
        for (File fs : this.customizationFileSets) {
            customizations.add(fs);
        }
        if (this.desc.getScheme() == null || this.desc.getScheme().equals("file")) {
            File fileDesc = new File(this.desc.getPath());
            if (!fileDesc.exists()) {
                throw new JaxrsException(Wadl2JavaMessages.WADL_DESCRIPTION_MUST_EXIST((Object)this.desc.toString()));
            }
            if (!fileDesc.isFile()) {
                throw new JaxrsException(Wadl2JavaMessages.WADL_DESCRIPTION_FILE((Object)this.desc.toString()));
            }
            this.desc = fileDesc.toURI();
            long earliestProducedFileStamp = Long.MAX_VALUE;
            for (File f : this.producedFileSets) {
                if (f.lastModified() >= earliestProducedFileStamp) continue;
                earliestProducedFileStamp = f.lastModified();
            }
            long latestConsumedFileStamp = fileDesc.lastModified();
            for (File f : this.consumedFileSets) {
                if (f.lastModified() <= latestConsumedFileStamp) continue;
                latestConsumedFileStamp = f.lastModified();
            }
            for (File f : customizations) {
                if (f.lastModified() <= latestConsumedFileStamp) continue;
                latestConsumedFileStamp = f.lastModified();
            }
            if (earliestProducedFileStamp < Long.MAX_VALUE && latestConsumedFileStamp < earliestProducedFileStamp) {
                LoggingService.logInfo((String)"oracle.eclipse.tools.jaxrs.v11", (String)Wadl2JavaMessages.SKIPPING_COMPILATION());
                return;
            }
        }
        HashMap<String, String> classCustomization = new HashMap<String, String>();
        for (IWadl2Java.ClassNameMapper mapper : this.customClassNames) {
            classCustomization.put(mapper.getUri(), mapper.getClassname());
        }
        try {
            Wadl2Java wadlProcessor = new Wadl2Java(new Wadl2Java.Parameters().setRootDir(this.target.toURI()).setCodeWriter((CodeWriter)new FileCodeWriter(this.target)).setPkg(this.pkg).setAutoPackage(this.autoPackage).setGenerationStyle(this.generationStyle).setCustomizationsAsFiles(customizations).setCustomClassNames(classCustomization));
            wadlProcessor.process(this.desc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JaxrsException(Wadl2JavaMessages.PROCESSING_FAILED(), (Throwable)ex);
        }
    }
}

