/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.vbundle.server;

import java.io.File;
import java.util.ArrayList;
import oracle.eclipse.tools.jaxrs.vbundle.server.IMementoReader;
import oracle.eclipse.tools.jaxrs.vbundle.server.Resource;
import oracle.eclipse.tools.jaxrs.vbundle.server.XMLMementoReader;

public class ServerConfig {
    private String configPath;
    private Resource[] resources;
    private int port = 8080;

    public ServerConfig(String configPath) {
        this.configPath = configPath;
        this.init();
    }

    private void init() {
        File f = new File(this.configPath);
        if (!f.exists()) {
            System.err.println("Config doesn't exist at " + this.configPath);
        } else {
            try {
                IMementoReader memento = XMLMementoReader.loadMemento(f);
                Integer prt = memento.getInteger("port");
                if (prt != null) {
                    this.port = prt;
                }
                IMementoReader[] resources2 = memento.getChildren("resource");
                int size = resources2.length;
                ArrayList<Resource> list = new ArrayList<Resource>(size);
                IMementoReader[] iMementoReaderArray = resources2;
                int n = resources2.length;
                int n2 = 0;
                while (n2 < n) {
                    IMementoReader res = iMementoReaderArray[n2];
                    String name = res.getString("name");
                    String path = res.getString("path");
                    String context = res.getString("context");
                    if (context != null && !context.startsWith("/")) {
                        context = "/" + context;
                    }
                    Resource resource = new Resource(name, context, path, this.port);
                    list.add(resource);
                    ++n2;
                }
                this.resources = new Resource[list.size()];
                list.toArray(this.resources);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Resource[] getResources() {
        return this.resources;
    }
}

