/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.UIExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableAction;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableResource;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIDataControlProviderAdapter;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DataControlProviderAdapter;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.internal.Messages;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.WebPageContextManager;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectDropCustomizer;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectInsertionCustomizer;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectModelAdapter;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectPaletteEditPartFactory;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.MaximizableDrawerEditPart;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategory;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategoryGroup;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteItem;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import oracle.eclipse.tools.webtier.ui.palette.model.TreeModelAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public final class DataControlObjectPaletteContributor
extends PaletteContributor {
    public static final String ID = "DataControlObjectPalette";
    private PaletteTree paletteTree;
    private DataControlObjectPaletteEditPartFactory editPartFactory = new DataControlObjectPaletteEditPartFactory();
    private PaletteItem nullPaletteItem;

    public DataControlObjectPaletteContributor(String id, Bundle contributingBundle, Integer priority, IFile file) {
        super(id, contributingBundle, priority, file);
    }

    public void dispose() {
        this.editPartFactory = null;
        if (this.paletteTree != null) {
            DataControlObjectModelAdapter modelAdapter = (DataControlObjectModelAdapter)this.paletteTree.getModelAdapter();
            if (modelAdapter != null) {
                modelAdapter.dispose();
            }
            this.paletteTree = null;
        }
        if (this.nullPaletteItem != null) {
            this.nullPaletteItem.setPaletteContributor(null);
            this.nullPaletteItem = null;
        }
        super.dispose();
    }

    private boolean isDisposed() {
        return this.editPartFactory == null;
    }

    public void doUpdateFile(IFile newFile) {
    }

    public void performInsertTag(TagToolPaletteEntry tool) {
        HTMLEditor editor = DTRTViewUIUtil.getActiveEditor();
        if (editor != null && tool instanceof DataControlObjectPaletteEntry) {
            DataControlObjectDropCustomizer customizer = new DataControlObjectDropCustomizer((DataControlObjectPaletteEntry)tool);
            customizer.runCustomizer(this.getFile(), this.getBindPosition(editor));
        }
    }

    public List<PaletteCategory> getContributions() {
        PaletteCategory category = this.createPaletteCategory();
        return this.createDataControlsTreeRoot(category) ? Collections.singletonList(category) : Collections.emptyList();
    }

    private PaletteCategory createPaletteCategory() {
        PaletteCategory category = new PaletteCategory(ID, this.getID(), "", Messages.DataControlsPaletteContributor_Category, Activator.Images.DATA_CONTROLS.getImageDescriptor(), Activator.Images.DATA_CONTROLS.getImageDescriptor());
        category.setToolTip(Messages.DataControlsPaletteContributor_Tooltip);
        category.setInitiallyOpen(false);
        category.setGroup(new PaletteCategoryGroup(Messages.DataControlsPaletteContributor_Group, 0, null));
        return category;
    }

    private boolean createDataControlsTreeRoot(PaletteCategory category) {
        IDataControlProvider provider = this.getDataControlProvider();
        if (provider == null) {
            provider = WebPageContextManager.getInstance().createContext(this.getFile());
        }
        if (provider != null) {
            if (provider instanceof IOEPEContext) {
                ExecutableContextAdapter contextAdapter = new ExecutableContextAdapter(){

                    public void handleReset(IOEPEContext context) {
                        DataControlObjectPaletteContributor.this.refreshPaletteTree((IDataControlProvider)context);
                    }
                };
                ((IOEPEContext)provider).addListener((IOEPEContext.IContextListener)new UIExecutableContextAdapter((IOEPEExecutableContext.IExecutableContextListener)contextAdapter));
            }
            DataControlObjectModelAdapter modelAdapter = new DataControlObjectModelAdapter(provider);
            this.paletteTree = new PaletteTree("", (TreeModelAdapter)modelAdapter);
            this.paletteTree.setInitialExpanded(true);
            this.paletteTree.setHideRootNode(true);
            this.paletteTree.setPaletteContributor((PaletteContributor)this);
            category.getPaletteItems().clear();
            category.addPaletteItem((PaletteItem)this.paletteTree);
            DataControlProviderAdapter providerAdapter = new DataControlProviderAdapter(){

                public void handleStructureReset(IDataControlProvider provider) {
                    DataControlObjectPaletteContributor.this.refreshPaletteTree(provider);
                }
            };
            provider.addListener((IDataControlProvider.IDataControlProviderListener)new UIDataControlProviderAdapter((IDataControlProvider.IDataControlProviderListener)providerAdapter));
            return true;
        }
        return false;
    }

    public EditPartFactory getEditPartFactory() {
        return this.editPartFactory;
    }

    private IDataControlProvider getDataControlProvider() {
        if (!this.isDisposed()) {
            if (this.paletteTree != null) {
                return (IDataControlProvider)this.paletteTree.getModelAdapter().getRoot();
            }
            HTMLEditor editor = DTRTViewUIUtil.findOpenEditor(this.getFile());
            if (editor != null) {
                return (IDataControlProvider)WebPageContextManager.getInstance().getContext((IWorkbenchPart)editor);
            }
        }
        return null;
    }

    public void fillContextMenu(IMenuManager menuManager, Object selectedModel) {
        super.fillContextMenu(menuManager, selectedModel);
        if (selectedModel instanceof MaximizableDrawerEditPart) {
            menuManager.add((IContributionItem)new Separator());
        } else if (selectedModel instanceof DataControlObjectPaletteEntry) {
            IDataControlObject dataControlObject;
            DataControlObjectPaletteEntry entry = (DataControlObjectPaletteEntry)((Object)selectedModel);
            boolean addSeparator = false;
            HTMLEditor editor = DTRTViewUIUtil.getActiveEditor();
            DataControlObjectInsertionCustomizer insertWidgetContributionItem = null;
            if (editor != null && (insertWidgetContributionItem = new DataControlObjectInsertionCustomizer(editor, DTRTViewUIUtil.createBindPosition(this.getBindPosition(editor)), entry)).isEnabled()) {
                addSeparator = true;
                menuManager.add((IContributionItem)insertWidgetContributionItem);
            }
            if ((dataControlObject = entry.getDataControlObject()) != null) {
                IOpenable[] openableArray;
                IStructureObject structureObject;
                IFile file;
                LinkedHashSet<Object> openables = new LinkedHashSet<Object>();
                IWebPageContext context = (IWebPageContext)WebPageContextManager.getInstance().getContext((IWorkbenchPart)editor.getEditorPart());
                if (context != null && (file = context.getAccessibleFile((IObject)DTRTObjectUtil.getDataControl((IDataControlObject)dataControlObject))) != null) {
                    OpenableResource openable = new OpenableResource(file, (ISelection)new StructuredSelection((Object)dataControlObject));
                    openable.setEditorId("oracle.eclipse.tools.adf.view.ui.datacontrols.manager.DataControlManager");
                    openables.add(openable);
                }
                if ((structureObject = dataControlObject.getStructureObject()) != null && (openableArray = (IOpenable[])DTRTUtil.getAdapter((IAdaptable)structureObject, IOpenable[].class)) != null) {
                    IOpenable[] iOpenableArray = openableArray;
                    int n = openableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOpenable openable = iOpenableArray[n2];
                        if (!structureObject.isCustomizationFile((IFile)DTRTUtil.getAdapter((IAdaptable)openable, IFile.class))) {
                            openables.add(openable);
                        }
                        ++n2;
                    }
                }
                if (!openables.isEmpty()) {
                    if (addSeparator) {
                        menuManager.add((IContributionItem)new Separator());
                    }
                    OpenableAction[] openableActions = OpenableAction.createOpenableActions((IOpenable[])openables.toArray(new IOpenable[openables.size()]), (boolean)true);
                    int i = 0;
                    while (i < openableActions.length) {
                        menuManager.add((IAction)openableActions[i]);
                        ++i;
                    }
                }
            }
        }
    }

    public PaletteItem getNullPaletteItem() {
        if (this.nullPaletteItem == null) {
            this.nullPaletteItem = new PaletteItem(null, null, null, null, null);
            this.nullPaletteItem.setPaletteContributor((PaletteContributor)this);
        }
        return this.nullPaletteItem;
    }

    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataControlObjectPaletteContributor.this.refreshPaletteTree(DataControlObjectPaletteContributor.this.getDataControlProvider());
            }
        });
    }

    private void refreshPaletteTree(IDataControlProvider provider) {
        if (provider != null && this.paletteTree != null && this.paletteTree.getModelAdapter() != null) {
            this.paletteTree.getModelAdapter().firePropertyChanged((Object)provider, "CHILDREN_PROPERTY");
            this.paletteTree.getModelAdapter().firePropertyChanged((Object)provider, "DETAIL_PROPERTY");
        }
    }

    private IDOMPosition getBindPosition(HTMLEditor editor) {
        if (editor != null) {
            int offset = editor.getTextEditor().getTextViewer().getTextWidget().getCaretOffset();
            IDOMSourceEditingTextTools tools = (IDOMSourceEditingTextTools)editor.getTextEditor().getAdapter(ISourceEditingTextTools.class);
            try {
                Node node = tools.getNode(offset);
                Object position = null;
                position = node != null ? SourceViewerDragDropHelper.getInstance().findPosition(offset, node) : (DataControlObjectPaletteContributor.getModel(tools).getDocument().getFirstChild() != null ? SourceViewerDragDropHelper.getInstance().findPosition(DataControlObjectPaletteContributor.getModel(tools).getDocument().getEndOffset(), DataControlObjectPaletteContributor.getModel(tools).getDocument().getFirstChild()) : new DOMPosition((Node)DataControlObjectPaletteContributor.getModel(tools).getDocument(), 0));
                return position;
            }
            catch (BadLocationException e) {
                DTRTViewUIUtil.log(e);
                return null;
            }
        }
        return null;
    }

    private static IDOMModel getModel(IDOMSourceEditingTextTools tools) {
        return ((IDOMNode)tools.getDOMDocument()).getModel();
    }
}

