/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe.dtrt;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.ui.context.manager.ContextManager;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.ContextCache;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.ManagedBeanManager;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.IWPEEvent;
import oracle.eclipse.tools.webtier.ui.internal.IWPEOpenCloseListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.IWPEPersistenceListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class WebPageContextManager
extends ContextManager<IWebPageContext> {
    private static WebPageContextManager instance;
    private WPEOpenCloseListener wpeOpenCloseListener = new WPEOpenCloseListener();
    private WPEPersistenceListener persistenceListener;

    public static synchronized WebPageContextManager getInstance() {
        if (instance == null) {
            instance = new WebPageContextManager();
        }
        return instance;
    }

    private WebPageContextManager() {
        this.wpeOpenCloseListener.register();
    }

    public synchronized void dispose() {
        if (this.wpeOpenCloseListener != null) {
            this.wpeOpenCloseListener.deregister();
            this.wpeOpenCloseListener = null;
        }
        this.persistenceListener = null;
        instance = null;
        super.dispose();
    }

    public void partOpened(IWorkbenchPart part) {
        IFile file;
        IStructuredModel model;
        assert (this.getContext(part) == null);
        if (part instanceof HTMLEditor && (model = ((HTMLEditor)part).getModel()) != null && (file = DTRTUIUtil.getFile((IWorkbenchPart)part)) != null) {
            IWebPageContext context = (IWebPageContext)ContextCache.getInstance().get(IWebPageContext.class, (Object)file);
            if (context == null) {
                context = this.createContext(file);
            }
            if (context != null) {
                this.setContext(part, (IOEPEContext)context);
                if (this.persistenceListener == null) {
                    this.persistenceListener = new WPEPersistenceListener();
                }
                ((HTMLEditor)part).addPersistenceListener((IWPEPersistenceListener)this.persistenceListener);
            }
        }
    }

    public IWebPageContext createContext(IFile file) {
        IWebPageContext context;
        if (file != null && (context = (IWebPageContext)DTRTUtil.createContext((IResource)file, IWebPageContext.class)) != null) {
            try {
                IProject earProject = DTRTUtil.getEARProject((IResource)file);
                if (earProject != null) {
                    context.initialize(earProject, file, (IWebPageContext.IManagedBeanManager)new ManagedBeanManager(), null);
                    context.addListener((IOEPEContext.IContextListener)this.getExternalChangeHandler());
                    context.addListener((IDataControlProvider.IDataControlProviderListener)this.getStructureChangeHandler());
                    IOEPEContext cachedContext = ContextCache.getInstance().put((Object)file, (IOEPEContext)context);
                    assert (cachedContext == null) : file;
                    return context;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                DTRTViewUIUtil.log(e);
            }
        }
        return null;
    }

    protected void contextUnset(IWorkbenchPart part, IWebPageContext context) {
        IFile file = DTRTUIUtil.getFile((IWorkbenchPart)part);
        assert (file != null);
        IOEPEContext cachedContext = ContextCache.getInstance().remove(IWebPageContext.class, (Object)file);
        assert (context == cachedContext) : file;
    }

    private class WPEOpenCloseListener
    implements IWPEOpenCloseListener {
        private WPEOpenCloseListener() {
        }

        public void notify(IWPEEvent event) {
            HTMLEditor wpeEditor = event.getWPEInstance();
            if (wpeEditor != null) {
                switch (event.getEventType()) {
                    case OPENED: {
                        WebPageContextManager.this.partOpened((IWorkbenchPart)wpeEditor);
                        break;
                    }
                    case CLOSED: {
                        WebPageContextManager.this.partClosed((IWorkbenchPart)wpeEditor);
                        break;
                    }
                    case ACTIVATED: {
                        WebPageContextManager.this.partActivated((IWorkbenchPart)wpeEditor);
                    }
                }
            }
        }

        public void register() {
            Activator.getDefault().addWPEOpenCloseListener((IWPEOpenCloseListener)this, null);
        }

        public void deregister() {
            Activator.getDefault().removeWPEOpenCloseListener((IWPEOpenCloseListener)this, null);
        }
    }

    private class WPEPersistenceListener
    implements IWPEPersistenceListener {
        private WPEPersistenceListener() {
        }

        public void notify(IWPEPersistenceListener.IPersistenceEvent event) {
            switch (event.getEventType()) {
                case SAVED: 
                case SAVED_AS: {
                    WebPageContextManager.this.editorSaved((IWorkbenchPart)event.getWPEInstance());
                    break;
                }
                case REVERTED: {
                    WebPageContextManager.this.editorReverted((IWorkbenchPart)event.getWPEInstance());
                }
            }
        }
    }
}

