/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe.dtrt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IManagedBean;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ManagedBeanScopeEnum;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.JavaCodeManipulationHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ManagedBeanImpl;
import oracle.eclipse.tools.adf.dtrt.util.ManagedBeanManagerImpl;
import oracle.eclipse.tools.adf.dtrt.util.ManagedBeanObjectImpl;
import oracle.eclipse.tools.adf.view.ui.util.CollectedArtifactUtils;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeLabelProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesViewFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideNoneScopedBeansFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.NoEmptyFieldsFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.ResourceStoreException;

public final class ManagedBeanManager
extends ManagedBeanManagerImpl {
    private static final String TASK_FLOW_ID_CLASS_SIMPLE_NAME = "TaskFlowId";
    private static final String TASK_FLOW_ID_CLASS_NAME = "oracle.adf.controller.TaskFlowId";
    private static final String TASK_FLOW_BIND_FIELD_NAME = "taskFlowId";
    private static final String TASK_FLOW_FIELD_FORMAT = "private String taskFlowId = \"%s\";";
    private static final String TASK_FLOW_BIND_METHOD_FORMAT = "public TaskFlowId %s() {return TaskFlowId.parse(taskFlowId);}";
    private static final String TASK_FLOW_LINK_METHOD_FORMAT = "public String %s() {taskFlowId = \"%s\"; return null;}";
    private static final IMemberFilter[] GETTER_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder().findMethodByPrefix("get", new String[0])};
    private ITypeHelper typeHelper = JDTUtil.createTypeHelper();

    protected void dispose() {
        if (this.typeHelper != null) {
            this.typeHelper.reset();
            this.typeHelper = null;
        }
        super.dispose();
    }

    private IFile getJavaFile(ManagedBeanImpl managedBean) {
        IPath path = managedBean.getJavaFilePath();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        assert (file.isAccessible()) : file;
        return file;
    }

    protected Collection<? extends ManagedBeanImpl> getInitialManagedBeans(Map<String, String> taskFlowBindNameByManagedBeanName, IProgressMonitor monitor) throws Exception {
        IType taskFlowIdType;
        IProject project = this.getContext().getWebPageFile().getProject();
        Set<IArtifact> artifacts = CollectedArtifactUtils.getManagedBeanArtifacts(project);
        HashSet<ManagedBeanImpl> managedBeans = new HashSet<ManagedBeanImpl>();
        IFile webPageFile = this.getContext().getWebPageFile();
        try {
            taskFlowIdType = this.typeHelper.findType(JavaCore.create((IProject)webPageFile.getProject()), TASK_FLOW_ID_CLASS_NAME);
        }
        catch (Exception exception) {
            taskFlowIdType = null;
        }
        FilePositionContext modelContext = new FilePositionContext(webPageFile);
        VariablesTreeLabelProvider labelProvider = new VariablesTreeLabelProvider((IModelContext)modelContext);
        for (IArtifact artifact : artifacts) {
            boolean boundToTaskFlow;
            IType javaType;
            Variable variable = CollectedArtifactUtils.getVariable(webPageFile, artifact.getName());
            String className = CollectedArtifactUtils.getTypeName(variable);
            if (className == null || (javaType = ClassUtil.safeGetType((String)className, (IProject)project)) == null) continue;
            ValueReference valueReference = new ValueReference(variable);
            Object[] decoratedObject = new Object[]{valueReference, modelContext};
            ManagedBeanImpl managedBean = new ManagedBeanImpl((Object)decoratedObject, labelProvider.getText((Object)valueReference));
            managedBean.setImage((Object)labelProvider.getImage((Object)valueReference));
            managedBean.setToolTipText(labelProvider.getToolTipText((Object)valueReference));
            managedBean.setClassName(className);
            managedBean.setJavaFilePath(javaType.getPath());
            managedBean.setScope(CollectedArtifactUtils.getScope(variable));
            managedBean.setComputeChildrenDelegator((ManagedBeanObjectImpl.IComputeChildrenDelegator)ComputeChildrenDelegator.getInstance());
            managedBeans.add(managedBean);
            String taskFlowBindName = taskFlowBindNameByManagedBeanName.get(DTRTUtil.getLabel((IDescribable)managedBean));
            boolean bl = boundToTaskFlow = taskFlowBindName != null && this.hasMethod(javaType, this.toGetMethodName(taskFlowBindName));
            if (!boundToTaskFlow) {
                if (taskFlowIdType != null) {
                    try {
                        boundToTaskFlow = this.hasTaskFlowBindGetter(taskFlowIdType, className);
                    }
                    catch (Throwable throwable) {
                        boundToTaskFlow = this.hasTaskFlowBindGetter(javaType);
                    }
                } else {
                    boundToTaskFlow = this.hasTaskFlowBindGetter(javaType);
                }
            }
            this.setInitiallyBoundToTaskFlow((IWebPageContext.IManagedBean)managedBean, boundToTaskFlow);
        }
        return managedBeans;
    }

    public ManagedBeanImpl addTaskFlowManagedBean(Variable.SCOPE scope, String name, String className, IPath javaFilePath, IProgressMonitor monitor) throws Exception {
        ManagedBeanImpl managedBean = super.addTaskFlowManagedBean(scope, name, className, javaFilePath, monitor);
        if (managedBean != null) {
            managedBean.setToolTipText(this.createToolTipText(managedBean));
        }
        return managedBean;
    }

    private String createToolTipText(ManagedBeanImpl managedBean) {
        StringBuffer buf = new StringBuffer();
        buf.append(oracle.eclipse.tools.application.common.services.Messages.ValueReference_Name).append(DTRTUtil.getLabel((IDescribable)managedBean)).append("\n");
        buf.append(oracle.eclipse.tools.application.common.services.Messages.ValueReference_Scope).append(managedBean.getScope().getScopeStr()).append("\n");
        buf.append(oracle.eclipse.tools.application.common.services.Messages.ValueReference_Type).append(managedBean.getClassName()).append("\n");
        buf.append(oracle.eclipse.tools.application.common.services.Messages.ValueReference_Source).append(" - ");
        return buf.toString();
    }

    private boolean hasTaskFlowBindGetter(IType taskFlowIdType, String className) throws Exception {
        IType type;
        if (taskFlowIdType != null && (type = this.typeHelper.findType(taskFlowIdType.getJavaProject(), className)) != null) {
            List getters = this.typeHelper.getMethods(type, true, GETTER_FILTER);
            for (IMethod getter : getters) {
                TypeInfo typeInfo = this.typeHelper.getTypeInfo(getter);
                IType returnType = this.typeHelper.findType(type.getJavaProject(), typeInfo.getClassName());
                if (!this.typeHelper.isAssignableFrom(taskFlowIdType, returnType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTaskFlowBindGetter(IType javaType) throws Exception {
        if (javaType != null) {
            IMethod[] iMethodArray = javaType.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                String returnSignature;
                IMethod method = iMethodArray[n2];
                if (method.getElementName().startsWith("get") && method.getParameterNames().length == 0 && Flags.isPublic((int)method.getFlags()) && (returnSignature = method.getReturnType()) != null) {
                    if (TASK_FLOW_ID_CLASS_SIMPLE_NAME.equals(returnSignature = Signature.getSignatureSimpleName((String)returnSignature))) {
                        return true;
                    }
                    if (TASK_FLOW_ID_CLASS_NAME.equals(returnSignature)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private String toGetMethodName(String name) {
        return "get" + DTRTUtil.upperCaseFirstLetter((String)name);
    }

    protected IOEPEExecutableContext.IContextSaveParticipant getSaveParticipant(Map<ManagedBeanImpl, ManagedBeanManagerImpl.ManagedBeanState> snapshot) {
        return new SaveParticipant(snapshot);
    }

    private IFile getUnboundedTaskFlowFile() {
        IProject project = this.getContext().getWebPageFile().getProject();
        return TaskFlowFactory.getDefaultUnboundedTaskFlowFile((IProject)project);
    }

    private ITaskFlow getUnboundedTaskFlow(IFile file) {
        return TaskFlowFactory.createTaskFlow((IFile)file);
    }

    private IManagedBean findRegisteredManagedBean(ITaskFlow unboundedTaskFlow, ManagedBeanImpl managedBean) {
        for (IManagedBean registeredManagedBean : unboundedTaskFlow.getManagedBeans()) {
            if (!DTRTUtil.equals((Object)this.getStringValue(registeredManagedBean.getManagedBeanName()), (Object)DTRTUtil.getLabel((IDescribable)managedBean)) || !DTRTUtil.equals((Object)this.getStringValue((Value<?>)registeredManagedBean.getManagedBeanClass()), (Object)managedBean.getClassName()) || !DTRTUtil.equals((Object)this.getStringValue(registeredManagedBean.getManagedBeanScope()), (Object)managedBean.getScope().getScopeStr())) continue;
            return registeredManagedBean;
        }
        return null;
    }

    private String getStringValue(Value<?> value) {
        Object content;
        if (value != null && (content = value.content()) != null) {
            if (content instanceof String) {
                return (String)content;
            }
            if (content instanceof JavaTypeName) {
                return ((JavaTypeName)content).qualified();
            }
            if (content instanceof ManagedBeanScopeEnum) {
                return content.toString();
            }
            throw new IllegalArgumentException("Unknown content: " + content);
        }
        return null;
    }

    private void registerManagedBean(ITaskFlow unboundedTaskFlow, ManagedBeanImpl managedBean) {
        IManagedBean registeredManagedBean = (IManagedBean)unboundedTaskFlow.getManagedBeans().insert();
        registeredManagedBean.setManagedBeanName(DTRTUtil.getLabel((IDescribable)managedBean));
        registeredManagedBean.setManagedBeanClass(managedBean.getClassName());
        registeredManagedBean.setManagedBeanScope(managedBean.getScope().getScopeStr());
    }

    private boolean addTaskFlowBind(JavaCodeManipulationHelper helper, IFile javaFile, ManagedBeanImpl managedBean, Pair<String, String> taskFlowBind) throws CoreException {
        boolean modified = false;
        String fieldCode = String.format(TASK_FLOW_FIELD_FORMAT, taskFlowBind.getSecond());
        modified |= helper.createField(javaFile, managedBean.getClassName(), fieldCode, null);
        String methodCode = String.format(TASK_FLOW_BIND_METHOD_FORMAT, this.toGetMethodName((String)taskFlowBind.getFirst()));
        modified |= helper.createMethod(javaFile, managedBean.getClassName(), methodCode, null);
        return modified |= helper.createImport(javaFile, managedBean.getClassName(), TASK_FLOW_ID_CLASS_NAME, null);
    }

    private boolean removeTaskFlowBind(JavaCodeManipulationHelper helper, IFile javaFile, ManagedBeanImpl managedBean, Pair<String, String> taskFlowBind) throws CoreException {
        boolean modified = false;
        modified |= helper.deleteField(javaFile, managedBean.getClassName(), TASK_FLOW_BIND_FIELD_NAME, null);
        modified |= helper.deleteMethod(javaFile, managedBean.getClassName(), this.toGetMethodName((String)taskFlowBind.getFirst()), null);
        return modified |= helper.deleteImport(javaFile, managedBean.getClassName(), TASK_FLOW_ID_CLASS_NAME, null);
    }

    private boolean handleLinks(JavaCodeManipulationHelper helper, IFile javaFile, ManagedBeanImpl managedBean, List<? extends Pair<String, String>> addedLinks, List<? extends Pair<String, String>> removedLinks) throws CoreException {
        boolean modified = false;
        for (Pair<String, String> pair : addedLinks) {
            String methodCode = String.format(TASK_FLOW_LINK_METHOD_FORMAT, pair.getFirst(), pair.getSecond());
            modified |= helper.createMethod(javaFile, managedBean.getClassName(), methodCode, null);
        }
        for (Pair<String, String> pair : removedLinks) {
            modified |= helper.deleteMethod(javaFile, managedBean.getClassName(), (String)pair.getFirst(), null);
        }
        return modified;
    }

    public boolean isValidTaskFlowBindName(IWebPageContext.IManagedBean managedBean, String name) throws Exception {
        return super.isValidTaskFlowBindName(managedBean, name) && !this.hasMethod(this.getJavaType((ManagedBeanImpl)managedBean), this.toGetMethodName(name));
    }

    public boolean isValidLinkName(IWebPageContext.IManagedBean managedBean, String linkName, String taskFlowName) throws Exception {
        return super.isValidLinkName(managedBean, linkName, taskFlowName) && !this.hasMethod(this.getJavaType((ManagedBeanImpl)managedBean), linkName);
    }

    private IType getJavaType(ManagedBeanImpl managedBean) throws CoreException {
        IFile javaFile = this.getJavaFile(managedBean);
        ICompilationUnit compilationUnit = this.typeHelper.getCompilationUnit(javaFile, false);
        return this.typeHelper.findType(compilationUnit, managedBean.getClassName());
    }

    private boolean hasMethod(IType javaType, String methodName) {
        if (javaType != null) {
            IMethod method = javaType.getMethod(methodName, new String[0]);
            return method.exists();
        }
        return false;
    }

    private static class ComputeChildrenDelegator
    implements ManagedBeanObjectImpl.IComputeChildrenDelegator {
        private static ComputeChildrenDelegator instance;

        public static ComputeChildrenDelegator getInstance() {
            return instance == null ? (instance = new ComputeChildrenDelegator()) : instance;
        }

        private ComputeChildrenDelegator() {
        }

        public List<? extends IWebPageContext.IManagedBeanObject> getChildren(ManagedBeanObjectImpl managedBeanObject) {
            Object[] decoratedObject = (Object[])managedBeanObject.getDecoratedObject();
            ValueReference valueReference = (ValueReference)decoratedObject[0];
            FilePositionContext modelContext = (FilePositionContext)decoratedObject[1];
            VariablesTreeLabelProvider labelProvider = new VariablesTreeLabelProvider((IModelContext)modelContext);
            List<? extends ViewerFilter> filters = this.getFilters(modelContext.getFile());
            List childFields = valueReference.getChildFields((IModelContext)modelContext);
            ArrayList<ManagedBeanObjectImpl> children = new ArrayList<ManagedBeanObjectImpl>(childFields.size());
            for (ValueReference childField : childFields) {
                if (!this.shouldAddAsChild(filters, valueReference, childField)) continue;
                Object[] array = new Object[]{childField, modelContext};
                ManagedBeanObjectImpl child = new ManagedBeanObjectImpl(managedBeanObject, (Object)array, labelProvider.getText((Object)childField));
                child.setImage((Object)labelProvider.getImage((Object)childField));
                child.setComputeChildrenDelegator((ManagedBeanObjectImpl.IComputeChildrenDelegator)this);
                child.setToolTipText(labelProvider.getToolTipText((Object)childField));
                children.add(child);
            }
            if (!children.isEmpty()) {
                Collections.sort(children, DTRTUtil.COMPARATOR);
                return Collections.unmodifiableList(children);
            }
            return Collections.emptyList();
        }

        private List<? extends ViewerFilter> getFilters(IFile file) {
            ArrayList<Object> filters = new ArrayList<Object>();
            FilePositionContext context = new FilePositionContext(file);
            filters.add(new VariablesViewFilter(VariablesViewFilter.ValueReferenceFilterType.ALL, (IFilePositionContext)context));
            filters.add(new NoEmptyFieldsFilter());
            filters.add(new HideNoneScopedBeansFilter());
            filters.add(new HideStringFieldsFilter((IModelContext)context));
            return filters;
        }

        private boolean shouldAddAsChild(List<? extends ViewerFilter> filters, Object parent, Object element) {
            for (ViewerFilter viewerFilter : filters) {
                if (viewerFilter.select(null, parent, element)) continue;
                return false;
            }
            return true;
        }
    }

    private static class Messages
    extends NLS {
        public static String errorSavingUnboundedTaskFlow;
        public static String errorUpdatingJava;

        static {
            NLS.initializeMessages((String)ManagedBeanManager.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private class SaveParticipant
    implements IOEPEExecutableContext.IContextSaveParticipant,
    IWorkspaceRunnable {
        private Map<ManagedBeanImpl, ManagedBeanManagerImpl.ManagedBeanState> snapshot;
        private Map<ManagedBeanImpl, IFile> managedBeanToJavaFileMap;
        private IFile unboundedTaskFlowFile;
        private Set<ManagedBeanImpl> taskFlowBindChanged;
        private Set<ManagedBeanImpl> linkChanged;
        private Set<ManagedBeanImpl> registerChanged;

        public SaveParticipant(Map<ManagedBeanImpl, ManagedBeanManagerImpl.ManagedBeanState> snapshot) {
            this.snapshot = snapshot;
            HashMap<ManagedBeanImpl, IFile> map = new HashMap<ManagedBeanImpl, IFile>();
            for (Map.Entry<ManagedBeanImpl, ManagedBeanManagerImpl.ManagedBeanState> entry : snapshot.entrySet()) {
                ManagedBeanImpl managedBean = entry.getKey();
                ManagedBeanManagerImpl.ManagedBeanState state = entry.getValue();
                if (!(state.getBoundToTaskFlow() == null || state.getBoundToTaskFlow() != Boolean.FALSE && ManagedBeanManager.this.isInitiallyBoundToTaskFlow((IWebPageContext.IManagedBean)managedBean))) {
                    assert (state.getTaskFlowBind() != null);
                    if (this.taskFlowBindChanged == null) {
                        this.taskFlowBindChanged = new HashSet<ManagedBeanImpl>();
                    }
                    this.taskFlowBindChanged.add(managedBean);
                }
                if (!state.getAddedLinks().isEmpty() || !state.getRemovedLinks().isEmpty()) {
                    if (this.linkChanged == null) {
                        this.linkChanged = new HashSet<ManagedBeanImpl>();
                    }
                    this.linkChanged.add(managedBean);
                }
                if (this.taskFlowBindChanged != null || this.linkChanged != null) {
                    map.put(managedBean, ManagedBeanManager.this.getJavaFile(managedBean));
                }
                if (!state.isAdded() && !state.isRemoved()) continue;
                if (this.unboundedTaskFlowFile == null) {
                    this.unboundedTaskFlowFile = ManagedBeanManager.this.getUnboundedTaskFlowFile();
                }
                if (this.registerChanged == null) {
                    this.registerChanged = new HashSet<ManagedBeanImpl>();
                }
                this.registerChanged.add(managedBean);
            }
            this.managedBeanToJavaFileMap = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        }

        public Collection<? extends IResource> getResources(IOEPEExecutableContext context) {
            HashSet<Object> resources = new HashSet<Object>(this.managedBeanToJavaFileMap.size() + 1);
            if (this.unboundedTaskFlowFile != null) {
                resources.add(this.unboundedTaskFlowFile);
                if (!this.unboundedTaskFlowFile.isAccessible()) {
                    resources.add(DTRTUtil.getAccessibleResource((IResource)this.unboundedTaskFlowFile));
                }
            }
            resources.addAll(this.managedBeanToJavaFileMap.values());
            return resources;
        }

        public IWorkspaceRunnable getWorkspaceRunnable(IOEPEExecutableContext context) {
            return this;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            ITaskFlow unboundedTaskFlow = null;
            if (this.unboundedTaskFlowFile != null) {
                assert (this.registerChanged != null);
                ITaskFlow taskFlow = ManagedBeanManager.this.getUnboundedTaskFlow(this.unboundedTaskFlowFile);
                assert (taskFlow != null) : this.unboundedTaskFlowFile;
                boolean changed = false;
                for (ManagedBeanImpl managedBean : this.registerChanged) {
                    IManagedBean registeredManagedBean = ManagedBeanManager.this.findRegisteredManagedBean(taskFlow, managedBean);
                    if (registeredManagedBean == null) {
                        if (!this.snapshot.get(managedBean).isAdded()) continue;
                        ManagedBeanManager.this.registerManagedBean(taskFlow, managedBean);
                        changed = true;
                        continue;
                    }
                    if (!this.snapshot.get(managedBean).isRemoved()) continue;
                    taskFlow.getManagedBeans().remove((Object)registeredManagedBean);
                    changed = true;
                }
                if (changed) {
                    unboundedTaskFlow = taskFlow;
                }
            }
            if (!this.managedBeanToJavaFileMap.isEmpty()) {
                ManagedBeanManagerImpl.ManagedBeanState state;
                IFile javaFile;
                assert (this.taskFlowBindChanged != null || this.linkChanged != null);
                JavaCodeManipulationHelper helper = new JavaCodeManipulationHelper();
                if (this.taskFlowBindChanged != null) {
                    for (ManagedBeanImpl managedBean : this.taskFlowBindChanged) {
                        javaFile = this.managedBeanToJavaFileMap.get(managedBean);
                        try {
                            state = this.snapshot.get(managedBean);
                            if (state.getBoundToTaskFlow() == Boolean.TRUE) {
                                ManagedBeanManager.this.addTaskFlowBind(helper, javaFile, managedBean, (Pair<String, String>)state.getTaskFlowBind());
                                continue;
                            }
                            ManagedBeanManager.this.removeTaskFlowBind(helper, javaFile, managedBean, (Pair<String, String>)state.getTaskFlowBind());
                        }
                        catch (Exception e) {
                            helper.dispose();
                            throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)Messages.errorUpdatingJava, (Object)managedBean.getClassName()), (Throwable)e));
                        }
                    }
                }
                if (this.linkChanged != null) {
                    for (ManagedBeanImpl managedBean : this.linkChanged) {
                        javaFile = this.managedBeanToJavaFileMap.get(managedBean);
                        try {
                            state = this.snapshot.get(managedBean);
                            if (this.linkChanged == null || !this.linkChanged.contains(managedBean)) continue;
                            ManagedBeanManager.this.handleLinks(helper, javaFile, managedBean, state.getAddedLinks(), state.getRemovedLinks());
                        }
                        catch (Exception e) {
                            helper.dispose();
                            throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)Messages.errorUpdatingJava, (Object)managedBean.getClassName()), (Throwable)e));
                        }
                    }
                }
                helper.save(null);
                helper.dispose();
            }
            if (unboundedTaskFlow != null) {
                assert (this.unboundedTaskFlowFile != null);
                try {
                    unboundedTaskFlow.resource().save();
                }
                catch (ResourceStoreException e) {
                    throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)Messages.errorSavingUnboundedTaskFlow, (Object)this.unboundedTaskFlowFile.getFullPath()), (Throwable)e));
                }
            }
            ManagedBeanManager.this.cleanAfterSave(this.snapshot);
        }
    }
}

