/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe;

import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TextDialogCellEditor
extends CellEditor {
    private final DialogCreationStrategy _strategy;
    private final IObservableValue _modelObservable;
    private Composite _editor;
    private Text _text;
    private ToolBar _toolBar;
    private boolean _inBindDialog = false;

    public TextDialogCellEditor(Composite parent, DialogCreationStrategy strategy, IObservableValue modelObservable) {
        this(parent, 0, strategy, modelObservable);
    }

    public TextDialogCellEditor(Composite parent, int style, DialogCreationStrategy strategy, IObservableValue modelObservable) {
        super(parent, style);
        this._strategy = strategy;
        this._modelObservable = modelObservable;
        this.createToolItem();
    }

    protected Control createControl(Composite parent) {
        this._editor = DialogWidgetAdapter.INSTANCE.createComposite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this._editor.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        this._editor.setLayoutData((Object)data);
        this._text = DialogWidgetAdapter.INSTANCE.createText(this._editor, null, 4);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 100;
        this._text.setLayoutData((Object)gridData);
        this._text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextDialogCellEditor.this.focusLost();
            }
        });
        this._toolBar = DialogWidgetAdapter.INSTANCE.createToolBar(this._editor, 0x800000);
        layout = new GridLayout(1, true);
        layout.marginHeight = 1;
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        this._toolBar.setLayout((Layout)layout);
        this._toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this._toolBar.setBackground(parent.getBackground());
        return this._editor;
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected void focusLost() {
        if (!this._inBindDialog && this.isActivated()) {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    private void createToolItem() {
        ToolItem toolItem = this._strategy.createToolItem(this._toolBar, (WidgetAdapter)FormsWidgetAdapter.INSTANCE);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TextDialogCellEditor.this._inBindDialog = true;
                TextDialogCellEditor.this._strategy.openDialog((Control)TextDialogCellEditor.this._editor, TextDialogCellEditor.this._modelObservable);
                TextDialogCellEditor.this._inBindDialog = false;
            }
        });
        DataBindingContext dataBindingContext = new DataBindingContext();
        ISWTObservableValue target = SWTObservables.observeText((Control)this._text, (int)24);
        dataBindingContext.bindValue((IObservableValue)target, this._modelObservable, (UpdateValueStrategy)new EMFUpdateValueStrategy(), null);
    }

    protected Object doGetValue() {
        return this._text.getText();
    }

    protected void doSetFocus() {
        if (this._text != null) {
            this._text.selectAll();
            this._text.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        this._text.setText((String)value);
    }
}

