/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import oracle.eclipse.tools.adf.view.ui.TraceOptions;
import oracle.eclipse.tools.adf.view.ui.internal.ADFWebFacetInstallWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.DataModelHelper;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.INewADFApplicationWizardPage;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.NewADFApplicationDataModelProvider;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.NewADFApplicationFirstPage;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.NewProjectDataModelFacetWizard;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.RegistryReader;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetInstallConfig;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.DefaultJ2EEComponentCreationDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.project.facet.ProductManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class NewADFApplicationWizard
extends NewProjectDataModelFacetWizard {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.view.ui.NewADFApplicationWizard";
    private static final String IMAGE_PATH_WIZ_BAN = "icons/wizards/application-banner.png";
    private NewADFApplicationFirstPage firstPage;
    private ADFWebFacetInstallWizardPage adfWebFacetPage;
    private INewADFApplicationWizardPage[] newADFAppWizPages;
    private DataModelHelper dmHelper = new DataModelHelper((IDataModelProvider)new DefaultJ2EEComponentCreationDataModelProvider());
    private IFacetedProjectWorkingCopy webFPWC = null;
    private IFacetedProjectListener runtimeChangeListener = null;

    public NewADFApplicationWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(Resources.WIZ_TITLE);
    }

    public NewADFApplicationWizard() {
        this.setWindowTitle(Resources.WIZ_TITLE);
    }

    @Override
    protected IDataModel createDataModel() {
        long start_time = System.nanoTime();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new NewADFApplicationDataModelProvider());
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] create data model"));
        }
        return dataModel;
    }

    public void setRuntimeInDataModel(IRuntime runtime) {
        this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
    }

    @Override
    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)IMAGE_PATH_WIZ_BAN);
    }

    @Override
    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.jst.ear");
    }

    @Override
    protected IWizardPage createFirstPage() {
        this.firstPage = new NewADFApplicationFirstPage(this.model, "first.page", HELP_CONTEXT_ID);
        return this.firstPage;
    }

    protected void updateADFWebFacetInstallWizardPage(IProgressMonitor monitor) {
        IRuntime runtime = this.getFacetedProjectWorkingCopy().getPrimaryRuntime();
        if (runtime == null) {
            return;
        }
        IProjectFacet adfWebFacet = ProjectFacetsManager.getProjectFacet((String)"oracle.adf.web");
        if (this.adfWebFacetPage == null) {
            this.adfWebFacetPage = new ADFWebFacetInstallWizardPage();
            this.createWebProjectWorkingCopy(monitor);
            this.setADFWebProjectRuntimeAndDefaultFacets(this.webFPWC, runtime, monitor);
            LibraryFacetInstallConfig cfg = (LibraryFacetInstallConfig)this.webFPWC.getProjectFacetAction(adfWebFacet).getConfig();
            this.adfWebFacetPage.setConfig(cfg);
            this.adfWebFacetPage.setWizard((IWizard)this);
            if (this.adfWebFacetPage.getControl() == null && Display.getCurrent() != null) {
                this.adfWebFacetPage.createControl(this.firstPage.getControl().getParent());
            }
        } else {
            this.dmHelper.setProperty("DefaultJ2EEComponentCreationDataModel.FACET_RUNTIME", runtime);
            this.setADFWebProjectRuntimeAndDefaultFacets(this.webFPWC, runtime, monitor);
            LibraryFacetInstallConfig cfg = (LibraryFacetInstallConfig)this.webFPWC.getProjectFacetAction(adfWebFacet).getConfig();
            this.adfWebFacetPage.setConfig(cfg);
        }
    }

    @Override
    protected IWizardPage[] createBeginingPages() {
        this.newADFAppWizPages = RegistryReader.getNewADFApplicationWizardPages();
        IWizardPage[] wizardPages = new IWizardPage[this.newADFAppWizPages.length + 1];
        wizardPages[0] = this.createFirstPage();
        int i = 0;
        int l = this.newADFAppWizPages.length;
        while (i < l) {
            INewADFApplicationWizardPage newADFWizPage = this.newADFAppWizPages[i];
            newADFWizPage.setWizardDataModel(this.model);
            wizardPages[i + 1] = newADFWizPage;
            ++i;
        }
        this.runtimeChangeListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                NewADFApplicationWizard.this.updateADFWebFacetInstallWizardPage((IProgressMonitor)new NullProgressMonitor());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IWizardContainer wizardContainer = NewADFApplicationWizard.this.getContainer();
                        if (wizardContainer != null && wizardContainer.getCurrentPage() != null) {
                            wizardContainer.updateButtons();
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    Display.getCurrent().asyncExec(runnable);
                } else {
                    Display.getDefault().asyncExec(runnable);
                }
            }
        };
        this.getFacetedProjectWorkingCopy().addListener(this.runtimeChangeListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
        return wizardPages;
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] pages = super.getPages();
        if (this.adfWebFacetPage != null) {
            IWizardPage[] newPages = new IWizardPage[pages.length + 1];
            int i = 0;
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage p;
                newPages[i] = p = iWizardPageArray[n2];
                ++i;
                ++n2;
            }
            newPages[i] = this.adfWebFacetPage;
            return newPages;
        }
        return pages;
    }

    @Override
    protected String getFinalPerspectiveID() {
        return ProductManager.getProperty((String)"finalPerspectiveEar");
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        INewADFApplicationWizardPage nextPage = null;
        if (page == this.firstPage) {
            if (this.adfWebFacetPage != null) {
                return this.adfWebFacetPage;
            }
            if (this.newADFAppWizPages.length > 0) {
                nextPage = this.newADFAppWizPages[0];
            }
        } else if (page == this.adfWebFacetPage) {
            if (this.newADFAppWizPages.length > 0) {
                nextPage = this.newADFAppWizPages[0];
            }
        } else {
            int i = 0;
            int l = this.newADFAppWizPages.length;
            while (i < l) {
                INewADFApplicationWizardPage newADFAppWizPage = this.newADFAppWizPages[i];
                if (page == newADFAppWizPage && i < l - 1) {
                    nextPage = this.newADFAppWizPages[i + 1];
                    break;
                }
                ++i;
            }
        }
        return nextPage;
    }

    public void setEARName(String earName) {
        this.model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)earName);
    }

    @Override
    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        this.getFacetedProjectWorkingCopy().removeListener(this.runtimeChangeListener);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel earFacetInstallModel = facetDMMap.getFacetDataModel("jst.ear");
        earFacetInstallModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        monitor.beginTask("", 20 + this.newADFAppWizPages.length);
        try {
            try {
                long start_time = System.nanoTime();
                IProject webProject = this.createWebProject(earFacetInstallModel, monitor);
                if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                    System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] create web project"));
                }
                start_time = System.nanoTime();
                monitor.subTask(Resources.SUBTASK_DEPLOYMENT_DEPENDENCIES);
                ArrayList<IProject> projectsList = new ArrayList<IProject>();
                projectsList.add(webProject);
                IProject jpaProject = (IProject)this.model.getProperty("NewADFApplicationDataModelProvider.JPA_PROJECT");
                if (jpaProject != null) {
                    projectsList.add(jpaProject);
                }
                earFacetInstallModel.setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", projectsList);
                monitor.worked(1);
                if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                    System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] configure deployment dependencies"));
                }
                start_time = System.nanoTime();
                super.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                    System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] call super.performFinish"));
                }
                start_time = System.nanoTime();
                if (webProject != null && jpaProject != null) {
                    try {
                        ComponentUtilities.removeWLPReferenceComponentOperation((IVirtualComponent)ComponentCore.createComponent((IProject)webProject), Collections.singletonList(ComponentCore.createComponent((IProject)jpaProject))).execute(null, null);
                        this.setWebProjectBuildPath(webProject, jpaProject);
                    }
                    catch (ExecutionException eEx) {
                        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view.ui", Resources.ERROR_REMOVING_MODEL_REFERENCE, (Throwable)eEx));
                    }
                }
                if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                    System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] remove model project reference from web project"));
                }
                start_time = System.nanoTime();
                INewADFApplicationWizardPage[] iNewADFApplicationWizardPageArray = this.newADFAppWizPages;
                int n = this.newADFAppWizPages.length;
                int n2 = 0;
                while (n2 < n) {
                    INewADFApplicationWizardPage newADFAppWizPage = iNewADFApplicationWizardPageArray[n2];
                    newADFAppWizPage.performFinish(webProject, jpaProject, monitor);
                    monitor.worked(1);
                    ++n2;
                }
                if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                    System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz] call performFinish on all contributed pages"));
                }
            }
            catch (CoreException cEx) {
                Activator.log(cEx);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createWebProjectWorkingCopy(IProgressMonitor monitor) {
        long start_time = System.nanoTime();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel earFacetInstallModel = facetDMMap.getFacetDataModel("jst.ear");
        FacetedProjectWorkingCopy fpwc = (FacetedProjectWorkingCopy)earFacetInstallModel.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IRuntime runtime = fpwc.getPrimaryRuntime();
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] calculate ADF version"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_1);
        start_time = System.nanoTime();
        this.dmHelper.setProperty("DefaultJ2EEComponentCreationDataModel.PROJECT_NAME", earFacetInstallModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
        this.dmHelper.setProperty("DefaultJ2EEComponentCreationDataModel.EAR_NAME", earFacetInstallModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
        IProjectFacetVersion version = (IProjectFacetVersion)earFacetInstallModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        this.dmHelper.setIntegerProperty("DefaultJ2EEComponentCreationDataModel.J2EE_VERSION", J2EEVersionUtil.convertVersionStringToInt((String)version.getVersionString()));
        this.dmHelper.setProperty("DefaultJ2EEComponentCreationDataModel.FACET_RUNTIME", runtime);
        this.dmHelper.setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB", true);
        this.dmHelper.setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB", false);
        this.dmHelper.setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR", false);
        this.dmHelper.setBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT", false);
        monitor.worked(1);
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] set initial model properties"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_2);
        start_time = System.nanoTime();
        IDataModel webModel = this.dmHelper.getModel().getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB");
        this.webFPWC = (IFacetedProjectWorkingCopy)webModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        monitor.worked(1);
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] configure runtime"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_3);
        start_time = System.nanoTime();
        monitor.worked(1);
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] install JSF and JSTL facets"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_4);
        start_time = System.nanoTime();
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] install WLS web facet"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_5);
        start_time = System.nanoTime();
        monitor.worked(1);
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] install ADF web facet"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_6);
    }

    private IProject createWebProject(IDataModel earFacetInstallModel, IProgressMonitor monitor) {
        long start_time = System.nanoTime();
        IProject project = null;
        String projectName = this.firstPage.getWebProjectName();
        this.webFPWC.setProjectName(projectName);
        try {
            this.webFPWC.commitChanges((IProgressMonitor)new SubProgressMonitor(monitor, 3, 2));
        }
        catch (CoreException cex) {
            Activator.log(cex);
        }
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] commit model changes"));
        }
        monitor.subTask(Resources.CREATE_WEB_PROJECT_SUBTASK_7);
        start_time = System.nanoTime();
        IStatus status = this.dmHelper.runOperations();
        if (status == null || !status.isOK()) {
            Activator.log(status);
        }
        monitor.worked(1);
        if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
            System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project] finalize project creation"));
        }
        if (projectName != null) {
            project = ProjectUtilities.getProject((String)projectName);
        }
        return project;
    }

    private String getLastUsedJSF12ProviderId() {
        String providerId = null;
        Preferences prefs = this.getLastUsedJSFLibProviderPreferences();
        if (prefs != null) {
            providerId = prefs.get("1.2", null);
        }
        return providerId;
    }

    private void setLastUsedJSF12Provider(String providerId) {
        Preferences prefs;
        if (providerId != null && (prefs = this.getLastUsedJSFLibProviderPreferences()) != null) {
            prefs.put("1.2", providerId);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private String getLastUsedJSF21ProviderId() {
        String providerId = null;
        Preferences prefs = this.getLastUsedJSFLibProviderPreferences();
        if (prefs != null) {
            providerId = prefs.get("2.1", null);
        }
        return providerId;
    }

    private void setLastUsedJSF21Provider(String providerId) {
        Preferences prefs;
        if (providerId != null && (prefs = this.getLastUsedJSFLibProviderPreferences()) != null) {
            prefs.put("2.1", providerId);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private Preferences getLastUsedJSFLibProviderPreferences() {
        Preferences prefs = null;
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        if (facet != null) {
            try {
                prefs = FacetedProjectFramework.getPreferences((IProjectFacet)facet).node("libprov/last-provider-used");
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return prefs;
    }

    protected void setADFWebProjectRuntimeAndDefaultFacets(IFacetedProjectWorkingCopy dm, IRuntime runtime, IProgressMonitor monitor) {
        dm.setTargetedRuntimes(Collections.emptySet());
        if (runtime != null) {
            IProjectFacet adfWebFacet;
            IProjectFacet jstlFacet;
            HashSet<IProjectFacetVersion> minFacets = new HashSet<IProjectFacetVersion>();
            try {
                for (IProjectFacet f : dm.getFixedProjectFacets()) {
                    minFacets.add(f.getLatestSupportedVersion(runtime));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            long start_time = System.nanoTime();
            dm.setProjectFacets(minFacets);
            if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project: configure runtime] set project facets"));
            }
            start_time = System.nanoTime();
            dm.setTargetedRuntimes(Collections.singleton(runtime));
            if (TraceOptions.NEW_ADF_APP_WIZ_TIMING) {
                System.out.println(TraceOptions.getTimingString(System.nanoTime() - start_time, "[NewADFAppWiz: create web project: configure runtime] set targeted runtimes"));
            }
            String currentJSFProviderId = null;
            String adfVersion = null;
            String wlsWebFacetVersionString = ADFGlassfishUtil.getRuntimeComponentVersion((IRuntime)runtime, (String)"com.bea.weblogic");
            IProjectFacet wlsWebFacet = ProjectFacetsManager.getProjectFacet((String)"wls.web");
            IProjectFacet glassfishWebFacet = null;
            try {
                glassfishWebFacet = ProjectFacetsManager.getProjectFacet((String)"glassfish.web");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (wlsWebFacetVersionString != null) {
                boolean is12cRuntime = "12.1.2".equals(wlsWebFacetVersionString);
                if (is12cRuntime) {
                    currentJSFProviderId = this.getLastUsedJSF21ProviderId();
                    if (currentJSFProviderId != null) {
                        this.setLastUsedJSF21Provider("wls-system-library-provider-jsf-2.1");
                    }
                } else {
                    currentJSFProviderId = this.getLastUsedJSF12ProviderId();
                    if (currentJSFProviderId != null) {
                        this.setLastUsedJSF12Provider("wls-shared-library-provider-jsf-1.2");
                    }
                }
                adfVersion = JRFRuntimeUtil.getAdfVersionForWls((String)wlsWebFacetVersionString);
                if (glassfishWebFacet != null && this.webFPWC.hasProjectFacet(glassfishWebFacet)) {
                    this.webFPWC.removeProjectFacet(glassfishWebFacet);
                }
                IProjectFacetVersion wlsWebFacetVersion = wlsWebFacet.getVersion(wlsWebFacetVersionString);
                this.webFPWC.addProjectFacet(wlsWebFacetVersion);
            } else if (glassfishWebFacet != null) {
                if (this.webFPWC.hasProjectFacet(wlsWebFacet)) {
                    this.webFPWC.removeProjectFacet(wlsWebFacet);
                }
                adfVersion = ADFGlassfishUtil.getRuntimeComponentVersion((IRuntime)runtime, (String)"oracle.glassfish.adf");
                String glassfishWebFacetVerStr = ADFGlassfishUtil.getGlassfishWebFacetVersion((IRuntime)runtime);
                IProjectFacetVersion glassfishWebFacetVersion = glassfishWebFacet.getVersion(glassfishWebFacetVerStr);
                this.webFPWC.addProjectFacet(glassfishWebFacetVersion);
            }
            IProjectFacet jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
            if (this.webFPWC.hasProjectFacet(jsfFacet)) {
                this.webFPWC.removeProjectFacet(jsfFacet);
            }
            IProjectFacetVersion jsfFacetVersion = jsfFacet.getVersion("1.2");
            if (wlsWebFacetVersionString != null) {
                boolean is12cRuntime = "12.1.2".equals(wlsWebFacetVersionString);
                if (is12cRuntime) {
                    jsfFacetVersion = jsfFacet.getVersion("2.1");
                }
                this.webFPWC.addProjectFacet(jsfFacetVersion);
                if (currentJSFProviderId != null) {
                    if (jsfFacetVersion.getVersionString().equals("2.1")) {
                        this.setLastUsedJSF21Provider(currentJSFProviderId);
                    } else {
                        this.setLastUsedJSF12Provider(currentJSFProviderId);
                    }
                }
            } else {
                jsfFacetVersion = jsfFacet.getVersion("2.1");
                this.webFPWC.addProjectFacet(jsfFacetVersion);
                this.setLastUsedJSF21Provider("glassfish-system-library-provider-jsf");
            }
            if (!this.webFPWC.hasProjectFacet(jstlFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jstl"))) {
                IProjectFacetVersion jstlFacetVersion = jstlFacet.getVersion("1.2");
                this.webFPWC.addProjectFacet(jstlFacetVersion);
            }
            if (this.webFPWC.hasProjectFacet(adfWebFacet = ProjectFacetsManager.getProjectFacet((String)"oracle.adf.web"))) {
                this.webFPWC.removeProjectFacet(adfWebFacet);
            }
            IProjectFacetVersion adfWebFacetVersion = adfWebFacet.getVersion(adfVersion != null ? adfVersion : "11.1.1");
            this.webFPWC.addProjectFacet(adfWebFacetVersion);
            monitor.worked(1);
        }
    }

    protected void setWebProjectBuildPath(IProject webProject, IProject jpaProject) throws JavaModelException {
        if (webProject != null) {
            IClasspathEntry[] currentClasspathEntries;
            IJavaProject javaProject = JavaCore.create((IProject)webProject);
            Path ipath = new Path("/" + jpaProject.getName());
            IClasspathEntry[] iClasspathEntryArray = currentClasspathEntries = javaProject.getRawClasspath();
            int n = currentClasspathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)ipath)) {
                    return;
                }
                ++n2;
            }
            IClasspathEntry[] updatedClasspathEntries = new IClasspathEntry[currentClasspathEntries.length + 1];
            System.arraycopy(currentClasspathEntries, 0, updatedClasspathEntries, 0, currentClasspathEntries.length);
            updatedClasspathEntries[currentClasspathEntries.length] = JavaCore.newProjectEntry((IPath)ipath);
            javaProject.setRawClasspath(updatedClasspathEntries, null);
            return;
        }
    }

    private static final class Resources
    extends NLS {
        public static String WIZ_TITLE;
        public static String CREATE_WEB_PROJECT_SUBTASK_1;
        public static String CREATE_WEB_PROJECT_SUBTASK_2;
        public static String CREATE_WEB_PROJECT_SUBTASK_3;
        public static String CREATE_WEB_PROJECT_SUBTASK_4;
        public static String CREATE_WEB_PROJECT_SUBTASK_5;
        public static String CREATE_WEB_PROJECT_SUBTASK_6;
        public static String CREATE_WEB_PROJECT_SUBTASK_7;
        public static String SUBTASK_DEPLOYMENT_DEPENDENCIES;
        public static String ERROR_REMOVING_MODEL_REFERENCE;

        static {
            Resources.initializeMessages((String)NewADFApplicationWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

