/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class NewADFApplicationJPAProjectPresetFactory
implements IPresetFactory {
    private static final String PRESET_ID = "preset.oracle.adf.jpa";
    private static final String RUNTIME_NAME_PREFIX = "Oracle WebLogic Server";
    private static final String[] LATEST_FACET_IDS = new String[]{"java", "jst.ejb", "wls.ejb"};
    private static final Map<String, String> FIXED_FACETS = new HashMap<String, String>();

    static {
        FIXED_FACETS.put("jpt.jpa", "2.0");
    }

    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        IRuntime runtime;
        PresetDefinition definition = null;
        if (PRESET_ID.equals(presetId) && (runtime = (IRuntime)context.get("CONTEXT_KEY_PRIMARY_RUNTIME")) != null && runtime.getName().startsWith(RUNTIME_NAME_PREFIX)) {
            HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
            String[] stringArray = LATEST_FACET_IDS;
            int n = LATEST_FACET_IDS.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IProjectFacetVersion projectFacetVersion = this.getLatestProjectFacetVersion(id, runtime);
                if (projectFacetVersion != null) {
                    facets.add(projectFacetVersion);
                }
                ++n2;
            }
            for (String id : FIXED_FACETS.keySet()) {
                IProjectFacetVersion projectFacetVersion;
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)id);
                if (projectFacet == null || (projectFacetVersion = projectFacet.getVersion(FIXED_FACETS.get(id))) == null) continue;
                facets.add(projectFacetVersion);
            }
            if (facets.size() == LATEST_FACET_IDS.length + FIXED_FACETS.size()) {
                definition = new PresetDefinition(Resources.PRESET_LABEL, Resources.PRESET_DESCRIPTION, facets);
            }
        }
        return definition;
    }

    private IProjectFacetVersion getLatestProjectFacetVersion(String id, IRuntime runtime) throws CoreException {
        IProjectFacet projectFacet;
        IProjectFacetVersion projectFacetVersion = null;
        if (runtime != null && id != null && id.length() > 0 && (projectFacet = ProjectFacetsManager.getProjectFacet((String)id)) != null) {
            projectFacetVersion = projectFacet.getLatestSupportedVersion(runtime);
        }
        return projectFacetVersion;
    }

    private static final class Resources
    extends NLS {
        public static String PRESET_LABEL;
        public static String PRESET_DESCRIPTION;

        static {
            Resources.initializeMessages((String)NewADFApplicationJPAProjectPresetFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

