/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class NewADFApplicationDataModelProvider
extends EARFacetProjectCreationDataModelProvider {
    private Map<IProject, Boolean> validFlagByProjectMap;
    public static final String JPA_PROJECT = "NewADFApplicationDataModelProvider.JPA_PROJECT";

    public void dispose() {
        if (this.validFlagByProjectMap != null) {
            this.validFlagByProjectMap.clear();
        }
        this.validFlagByProjectMap = null;
        super.dispose();
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add(JPA_PROJECT);
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (JPA_PROJECT.equals(propertyName)) {
            return null;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (JPA_PROJECT.equals(propertyName)) {
            IProject project = (IProject)this.getProperty(JPA_PROJECT);
            if (project != null) {
                return new DataModelPropertyDescriptor((Object)project, project.getName());
            }
            return new DataModelPropertyDescriptor(null, "<None>");
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            Set fixedFacets = fpjwc.getFixedProjectFacets();
            ArrayList<IRuntime> list = new ArrayList<IRuntime>();
            block2: for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                List components;
                boolean supportsFacets = true;
                for (IProjectFacet facet : fixedFacets) {
                    if (runtime.supports(facet)) continue;
                    supportsFacets = false;
                    break;
                }
                if (!supportsFacets || (components = runtime.getRuntimeComponents()) == null) continue;
                for (IRuntimeComponent component : components) {
                    IRuntimeComponentVersion rcv = component.getRuntimeComponentVersion();
                    String id = rcv.getRuntimeComponentType().getId();
                    if (!"oracle.weblogic.adf".equals(id) && !"oracle.glassfish.adf".equals(id)) continue;
                    list.add(runtime);
                    continue block2;
                }
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size()];
            Iterator iterator = list.iterator();
            int i = 0;
            while (i < descriptors.length) {
                IRuntime runtime = (IRuntime)iterator.next();
                descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
                ++i;
            }
            if (descriptors.length > 1) {
                Arrays.sort(descriptors, 0, descriptors.length, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            return descriptors;
        }
        if (JPA_PROJECT.equals(propertyName)) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IProject> list = new ArrayList<IProject>();
            if (projects != null) {
                IProject[] i = projects;
                int iterator = projects.length;
                int descriptors = 0;
                while (descriptors < iterator) {
                    IProject project = i[descriptors];
                    try {
                        if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jpt.jpa")) {
                            list.add(project);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++descriptors;
                }
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
            descriptors[0] = new DataModelPropertyDescriptor(null, Resources.NO_JPA_PROJECT_LABEL);
            Iterator iterator = list.iterator();
            int i = 0;
            int size = list.size();
            while (i < size) {
                IProject project = (IProject)iterator.next();
                descriptors[i + 1] = new DataModelPropertyDescriptor((Object)project, project.getName());
                ++i;
            }
            if (descriptors.length > 2) {
                Arrays.sort(descriptors, 1, descriptors.length, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty(propertyName);
            if (runtime == null) {
                return new Status(4, "oracle.eclipse.tools.adf.view.ui", Resources.INVALID_RUNTIME_MESSAGE);
            }
            return Status.OK_STATUS;
        }
        if (JPA_PROJECT.equals(propertyName)) {
            IProject project = (IProject)this.getProperty(propertyName);
            if (project != null) {
                Boolean isValid;
                Boolean bl = isValid = this.validFlagByProjectMap != null ? this.validFlagByProjectMap.get(project) : null;
                if (isValid == null) {
                    IProjectFacetVersion ejbFacetVersion = null;
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                        ejbFacetVersion = facetedProject.getInstalledVersion(IJ2EEFacetConstants.EJB_FACET);
                    }
                    catch (Exception exception) {}
                    if (ejbFacetVersion != null) {
                        isValid = IJ2EEFacetConstants.EJB_30.compareTo((Object)ejbFacetVersion) <= 0;
                        if (this.validFlagByProjectMap == null) {
                            this.validFlagByProjectMap = new HashMap<IProject, Boolean>();
                        }
                        this.validFlagByProjectMap.put(project, isValid);
                    }
                }
                if (isValid == Boolean.FALSE) {
                    return new Status(4, "oracle.eclipse.tools.adf.view.ui", Resources.INVALID_EJB_VERSION);
                }
            }
            return Status.OK_STATUS;
        }
        return super.validate(propertyName);
    }

    private static final class Resources
    extends NLS {
        public static String INVALID_RUNTIME_MESSAGE;
        public static String NO_JPA_PROJECT_LABEL;
        public static String INVALID_EJB_VERSION;

        static {
            Resources.initializeMessages((String)NewADFApplicationDataModelProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

