/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.common.util.ADFCommonUtils;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.NewProjectGroup;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.proj.JpaProjectWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.proj.model.JpaProjectCreationDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class DataModelFacetCreationWizardPage
extends DataModelWizardPage
implements IFacetProjectCreationDataModelProperties {
    private static final String NULL_RUNTIME = "NULL_RUNTIME";
    private static final String MRU_RUNTIME_STORE = "MRU_RUNTIME_STORE";
    private static final Integer WEB_PROJECT_NAME_STATUS_KEY = new Integer(999);
    private static final Integer PROJECT_NAME_CONFLICT_STATUS_KEY = new Integer(1000);
    protected static final String RESOURCE_WORKING_SET = "org.eclipse.ui.resourceWorkingSetPage";
    protected static final String JAVA_WORKING_SET = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    protected IProjectFacet primaryProjectFacet = null;
    protected WorkingSetGroup workingSetGroup;
    private Button useDefaultDynamicWebProjectNameButton;
    private Label dynamicWebProjectNameLabel;
    private Text dynamicWebProjectNameText;
    private String helpContextID;
    private static final String[] VALIDATION_PROPERTIES = new String[]{"IProjectCreationPropertiesNew.PROJECT_NAME", "IProjectCreationPropertiesNew.PROJECT_LOCATION", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", "IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY", "NewADFApplicationDataModelProvider.JPA_PROJECT"};
    protected Combo serverTargetCombo;
    protected NewProjectGroup projectNameGroup;
    private final IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    private final IFacetedProjectListener fpjwcListener = new IFacetedProjectListener(){

        public void handleEvent(IFacetedProjectEvent event) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DataModelFacetCreationWizardPage.this.validatePage();
                }
            };
            DataModelFacetCreationWizardPage.this.getContainer().getShell().getDisplay().asyncExec(runnable);
        }
    };

    protected Set<IProjectFacetVersion> getFacetConfiguration(IProjectFacetVersion primaryFacetVersion) {
        HashSet<IProjectFacetVersion> config = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet fixedFacet : this.fpjwc.getFixedProjectFacets()) {
            if (fixedFacet == primaryFacetVersion.getProjectFacet()) {
                config.add(primaryFacetVersion);
                continue;
            }
            config.add(this.fpjwc.getHighestAvailableVersion(fixedFacet));
        }
        return config;
    }

    protected static GridData gdhfill() {
        return new GridData(768);
    }

    protected static GridData hspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)top, this.helpContextID);
        }
        this.createProjectGroup(top);
        this.createServerTargetComposite(top);
        this.createWebProjectNameGroup(top);
        this.createJPAProjectComposite(top);
        return top;
    }

    public static boolean launchNewRuntimeWizard(Shell shell, IDataModel model) {
        return DataModelFacetCreationWizardPage.launchNewRuntimeWizard(shell, model, null);
    }

    public static boolean launchNewRuntimeWizard(Shell shell, final IDataModel model, String serverTypeID) {
        if (model == null) {
            return false;
        }
        final DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        final boolean[] keepWaiting = new boolean[]{true};
        IDataModelListener listener = new IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChanged(DataModelEvent event) {
                if (!event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") || event.getFlag() != 4) return;
                boolean[] blArray = keepWaiting;
                synchronized (keepWaiting) {
                    keepWaiting[0] = false;
                    keepWaiting.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    model.removeListener((IDataModelListener)this);
                    return;
                }
            }
        };
        model.addListener(listener);
        assert (!ADFCommonUtils.SUPPORTED_RUNTIME_TYPES.isEmpty()) : "Must have at least one supported runtime type";
        StringBuilder runtimeTypeIds = new StringBuilder();
        for (IRuntimeType runtimeType : ADFCommonUtils.SUPPORTED_RUNTIME_TYPES) {
            runtimeTypeIds.append(',').append(runtimeType.getId());
        }
        for (IRuntimeType gfRuntimeType : ADFGlassfishUtil.getGlassfishRuntimeTypes()) {
            runtimeTypeIds.append(',').append(gfRuntimeType.getId());
        }
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)serverTypeID, null, (String)runtimeTypeIds.substring(1));
        if (isOK) {
            Thread newRuntimeSelectionThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    RuntimeManager.getRuntimes();
                    boolean[] blArray = keepWaiting;
                    synchronized (keepWaiting) {
                        while (true) {
                            if (!keepWaiting[0]) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                break;
                            }
                            try {
                                keepWaiting.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                        Object[] preAddition = new Object[preAdditionDescriptors.length];
                        int i = 0;
                        while (i < preAddition.length) {
                            preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                            ++i;
                        }
                        Object[] postAddition = new Object[postAdditionDescriptors.length];
                        int i2 = 0;
                        while (i2 < postAddition.length) {
                            postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                            ++i2;
                        }
                        Object newAddition = DataModelFacetCreationWizardPage.getNewObject(preAddition, postAddition);
                        if (newAddition != null) {
                            model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
                        }
                        return;
                    }
                }
            };
            newRuntimeSelectionThread.start();
            return true;
        }
        model.removeListener(listener);
        return false;
    }

    public boolean internalLaunchNewRuntimeWizard(Shell shell, IDataModel theModel) {
        return DataModelFacetCreationWizardPage.launchNewRuntimeWizard(shell, theModel, this.getModuleTypeID());
    }

    public static boolean launchNewJPAProjectWizard(Shell shell, final IDataModel model) {
        boolean isOK;
        JpaProjectWizard jpaProjectWizard;
        if (model == null) {
            return false;
        }
        final DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("NewADFApplicationDataModelProvider.JPA_PROJECT");
        final boolean[] keepWaiting = new boolean[]{true};
        IDataModelListener listener = new IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChanged(DataModelEvent event) {
                if (!event.getPropertyName().equals("NewADFApplicationDataModelProvider.JPA_PROJECT") || event.getFlag() != 4) return;
                boolean[] blArray = keepWaiting;
                synchronized (keepWaiting) {
                    keepWaiting[0] = false;
                    keepWaiting.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    model.removeListener((IDataModelListener)this);
                    return;
                }
            }
        };
        model.addListener(listener);
        IDataModel jpaDataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaProjectCreationDataModelProvider());
        if (jpaDataModel != null) {
            String projectName = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            jpaDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)(String.valueOf(projectName) + "Model"));
            IRuntime runtime = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (runtime != null) {
                jpaDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            }
            jpaProjectWizard = new JpaProjectWizard(jpaDataModel);
        } else {
            jpaProjectWizard = new JpaProjectWizard();
        }
        boolean bl = isOK = new WizardDialog(shell, (IWizard)jpaProjectWizard).open() == 0;
        if (isOK) {
            Thread newJPAProjectSelectionThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    model.notifyPropertyChange("NewADFApplicationDataModelProvider.JPA_PROJECT", 4);
                    boolean[] blArray = keepWaiting;
                    synchronized (keepWaiting) {
                        while (true) {
                            if (!keepWaiting[0]) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                break;
                            }
                            try {
                                keepWaiting.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("NewADFApplicationDataModelProvider.JPA_PROJECT");
                        Object[] preAddition = new Object[preAdditionDescriptors.length];
                        int i = 0;
                        while (i < preAddition.length) {
                            preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                            ++i;
                        }
                        Object[] postAddition = new Object[postAdditionDescriptors.length];
                        int i2 = 0;
                        while (i2 < postAddition.length) {
                            postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                            ++i2;
                        }
                        Object newAddition = DataModelFacetCreationWizardPage.getNewObject(preAddition, postAddition);
                        if (newAddition != null) {
                            model.setProperty("NewADFApplicationDataModelProvider.JPA_PROJECT", newAddition);
                        }
                        return;
                    }
                }
            };
            newJPAProjectSelectionThread.start();
            return true;
        }
        model.removeListener(listener);
        return false;
    }

    public boolean internalLaunchNewJPAProjectWizard(Shell shell, IDataModel theModel) {
        return DataModelFacetCreationWizardPage.launchNewJPAProjectWizard(shell, theModel);
    }

    protected String getModuleTypeID() {
        return null;
    }

    public DataModelFacetCreationWizardPage(IDataModel dataModel, String pageName, String helpContextID) {
        super(dataModel, pageName);
        this.fpjwc.addListener(this.fpjwcListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED});
        this.helpContextID = helpContextID;
    }

    protected void createWebProjectNameGroup(Composite parent) {
        Group dynamicWebProjectNameGroup = new Group(parent, 0);
        dynamicWebProjectNameGroup.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        dynamicWebProjectNameGroup.setLayout((Layout)new GridLayout(2, false));
        dynamicWebProjectNameGroup.setText(Resources.WEB_PROJECT_NAME_GROUP_LABEL);
        this.useDefaultDynamicWebProjectNameButton = new Button((Composite)dynamicWebProjectNameGroup, 32);
        this.useDefaultDynamicWebProjectNameButton.setText(Resources.WEB_PROJECT_NAME_USE_DEFAULT_LABEL);
        this.useDefaultDynamicWebProjectNameButton.setSelection(true);
        this.useDefaultDynamicWebProjectNameButton.setLayoutData((Object)this.getSpanningGridData(2));
        this.useDefaultDynamicWebProjectNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFacetCreationWizardPage.this.handleUseDefaultDynamicWebProjectNameChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.dynamicWebProjectNameLabel = new Label((Composite)dynamicWebProjectNameGroup, 0);
        this.dynamicWebProjectNameLabel.setText(Resources.WEB_PROJECT_NAME_LABEL);
        this.dynamicWebProjectNameText = new Text((Composite)dynamicWebProjectNameGroup, 2048);
        this.dynamicWebProjectNameText.setLayoutData((Object)new GridData(768));
        this.dynamicWebProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataModelFacetCreationWizardPage.this.handleWebProjectNameChanged();
            }
        });
        this.projectNameGroup.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataModelFacetCreationWizardPage.this.handleUseDefaultDynamicWebProjectNameChanged();
            }
        });
        this.handleUseDefaultDynamicWebProjectNameChanged();
    }

    private GridData getSpanningGridData(int spanColumns) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = spanColumns;
        return gd;
    }

    private void handleUseDefaultDynamicWebProjectNameChanged() {
        boolean useDefault = this.useDefaultDynamicWebProjectNameButton.getSelection();
        this.dynamicWebProjectNameLabel.setEnabled(!useDefault);
        this.dynamicWebProjectNameText.setEnabled(!useDefault);
        this.handleProjectNameFieldTextChanged();
    }

    private void handleProjectNameFieldTextChanged() {
        if (this.useDefaultDynamicWebProjectNameButton.getSelection()) {
            this.dynamicWebProjectNameText.setText(String.valueOf(this.projectNameGroup.projectNameField.getText()) + "Web");
        } else {
            boolean statusChanged = false;
            if (this.projectNameGroup.projectNameField.getText().equals(this.dynamicWebProjectNameText.getText())) {
                this.setErrorStatus(PROJECT_NAME_CONFLICT_STATUS_KEY, Resources.EXISTING_WEB_PROJECT_NAME);
                statusChanged = true;
            } else if (!this.getStatus(PROJECT_NAME_CONFLICT_STATUS_KEY)) {
                this.setOKStatus(PROJECT_NAME_CONFLICT_STATUS_KEY);
                statusChanged = true;
            }
            if (statusChanged) {
                this.validatePage();
            }
        }
    }

    private void handleWebProjectNameChanged() {
        String webProjectName = this.getWebProjectName();
        if (webProjectName.length() < 1) {
            this.setErrorStatus(WEB_PROJECT_NAME_STATUS_KEY, Resources.EMPTY_WEB_PROJECT_NAME);
        } else {
            if (this.projectNameGroup.projectNameField.getText().equals(webProjectName)) {
                this.setErrorStatus(PROJECT_NAME_CONFLICT_STATUS_KEY, Resources.EXISTING_WEB_PROJECT_NAME);
            } else {
                this.setOKStatus(PROJECT_NAME_CONFLICT_STATUS_KEY);
            }
            IProject webProject = null;
            try {
                webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(webProjectName);
                if (webProject != null && webProject.exists()) {
                    this.setErrorStatus(WEB_PROJECT_NAME_STATUS_KEY, Resources.EXISTING_WEB_PROJECT_NAME);
                } else if (this.isValidProjectName(webProjectName)) {
                    this.setOKStatus(WEB_PROJECT_NAME_STATUS_KEY);
                } else {
                    this.setErrorStatus(WEB_PROJECT_NAME_STATUS_KEY, Resources.INVALID_WEB_PROJECT_NAME);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setErrorStatus(WEB_PROJECT_NAME_STATUS_KEY, Resources.INVALID_WEB_PROJECT_NAME);
            }
        }
        if (!this.isFirstTimeToPage()) {
            this.validatePage();
        }
    }

    private boolean isValidProjectName(String projectName) {
        boolean isValid = false;
        if (projectName != null) {
            isValid = ResourcesPlugin.getWorkspace().validateName(projectName, 4).isOK();
            isValid &= !projectName.endsWith(" ");
            isValid &= projectName.indexOf(35) == -1;
        }
        return isValid;
    }

    public String getWebProjectName() {
        final String[] webProjectName = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                webProjectName[0] = DataModelFacetCreationWizardPage.this.dynamicWebProjectNameText.getText();
            }
        });
        return webProjectName[0];
    }

    protected void createServerTargetComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Resources.TARGET_RUNTIME_GROUP_LABEL);
        group.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        group.setLayout((Layout)new GridLayout(2, false));
        this.serverTargetCombo = new Combo((Composite)group, 2056);
        this.serverTargetCombo.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setText(Resources.NEW_RUNTIME_BUTTON);
        GridDataFactory.defaultsFor((Control)newServerTargetButton).applyTo((Control)newServerTargetButton);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFacetCreationWizardPage.this.internalLaunchNewRuntimeWizard(DataModelFacetCreationWizardPage.this.getShell(), DataModelFacetCreationWizardPage.this.model);
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected void createJPAProjectComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Resources.JPA_PROJECT_GROUP_LABEL);
        group.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        group.setLayout((Layout)new GridLayout(2, false));
        Combo jpaProjectCombo = new Combo((Composite)group, 2056);
        jpaProjectCombo.setLayoutData((Object)DataModelFacetCreationWizardPage.gdhfill());
        Button newJPAProjectButton = new Button((Composite)group, 0);
        newJPAProjectButton.setText(Resources.NEW_JPA_PROJECT_BUTTON);
        GridDataFactory.defaultsFor((Control)newJPAProjectButton).applyTo((Control)newJPAProjectButton);
        newJPAProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataModelFacetCreationWizardPage.this.internalLaunchNewJPAProjectWizard(DataModelFacetCreationWizardPage.this.getShell(), DataModelFacetCreationWizardPage.this.model);
            }
        });
        Control[] deps = new Control[]{newJPAProjectButton};
        this.synchHelper.synchCombo(jpaProjectCombo, "NewADFApplicationDataModelProvider.JPA_PROJECT", deps);
        if (jpaProjectCombo.getSelectionIndex() == -1 && jpaProjectCombo.getVisibleItemCount() != 0) {
            jpaProjectCombo.select(0);
        }
    }

    protected void createProjectGroup(Composite parent) {
        IDataModel nestedProjectDM = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
        nestedProjectDM.addListener((IDataModelListener)this);
        this.projectNameGroup = new NewProjectGroup(parent, nestedProjectDM);
    }

    protected String[] getValidationPropertyNames() {
        return VALIDATION_PROPERTIES;
    }

    public final void performHelp() {
        if (this.helpContextID != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextID);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.projectNameGroup != null) {
            this.projectNameGroup.dispose();
        }
        this.fpjwc.removeListener(this.fpjwcListener);
    }

    public void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.saveRuntimeSettings(settings, this.model);
    }

    public void restoreDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.restoreRuntimeSettings(settings, this.model);
    }

    public static void saveRuntimeSettings(IDialogSettings settings, IDataModel model) {
        if (settings != null) {
            IRuntime runtime;
            String runtimeName;
            String[] mruRuntimeArray = settings.getArray(MRU_RUNTIME_STORE);
            ArrayList<String> mruRuntimes = new ArrayList<String>();
            if (mruRuntimeArray != null) {
                mruRuntimes.addAll(Arrays.asList(mruRuntimeArray));
            }
            String string = runtimeName = (runtime = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) == null ? NULL_RUNTIME : runtime.getName();
            if (mruRuntimes.contains(runtimeName)) {
                mruRuntimes.remove(runtimeName);
            }
            mruRuntimes.add(0, runtimeName);
            while (mruRuntimes.size() > 5) {
                mruRuntimes.remove(5);
            }
            mruRuntimeArray = new String[mruRuntimes.size()];
            int i = 0;
            while (i < mruRuntimeArray.length) {
                mruRuntimeArray[i] = (String)mruRuntimes.get(i);
                ++i;
            }
            settings.put(MRU_RUNTIME_STORE, mruRuntimeArray);
        }
    }

    public static void restoreRuntimeSettings(IDialogSettings settings, IDataModel model) {
        if (settings != null && !model.isPropertySet("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            boolean runtimeSet = false;
            String[] mruRuntimeArray = settings.getArray(MRU_RUNTIME_STORE);
            DataModelPropertyDescriptor[] descriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            ArrayList<String> mruRuntimes = new ArrayList<String>();
            if (mruRuntimeArray == null) {
                List defRuntimes = ProductManager.getDefaultRuntimes();
                Iterator iter = defRuntimes.iterator();
                while (iter.hasNext()) {
                    mruRuntimes.add(((IRuntime)iter.next()).getName());
                }
            } else {
                mruRuntimes.addAll(Arrays.asList(mruRuntimeArray));
            }
            if (!mruRuntimes.isEmpty()) {
                int i = 0;
                while (i < mruRuntimes.size() && !runtimeSet) {
                    int j = 0;
                    while (j < descriptors.length - 1 && !runtimeSet) {
                        if (mruRuntimes.get(i).equals(((IRuntime)descriptors[j].getPropertyValue()).getName())) {
                            model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[j].getPropertyValue());
                            runtimeSet = true;
                        }
                        ++j;
                    }
                    if (!runtimeSet && mruRuntimes.get(i).equals(NULL_RUNTIME)) {
                        model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[descriptors.length - 1].getPropertyValue());
                        runtimeSet = true;
                    }
                    ++i;
                }
            }
            if (!runtimeSet && descriptors.length > 0) {
                model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[0].getPropertyValue());
            }
        }
    }

    private static Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        if (oldObjects == null && newObjects != null && newObjects.length == 1) {
            return newObjects[0];
        }
        return null;
    }

    protected WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection selection, String[] supportedWorkingSetTypes) {
        if (this.workingSetGroup != null) {
            return this.workingSetGroup;
        }
        this.workingSetGroup = new WorkingSetGroup(composite, selection, supportedWorkingSetTypes);
        return this.workingSetGroup;
    }

    protected WorkingSetGroup createWorkingSetGroupPanel(Composite composite, String[] workingSetTypes) {
        IStructuredSelection structuredSelection = null;
        ISelection currentSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)currentSelection;
        }
        WorkingSetGroup group = this.createWorkingSetGroup(composite, structuredSelection, workingSetTypes);
        return group;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup == null ? new IWorkingSet[]{} : this.workingSetGroup.getSelectedWorkingSets();
    }

    private static final class Resources
    extends NLS {
        public static String WEB_PROJECT_NAME_GROUP_LABEL;
        public static String WEB_PROJECT_NAME_USE_DEFAULT_LABEL;
        public static String WEB_PROJECT_NAME_LABEL;
        public static String NEW_RUNTIME_BUTTON;
        public static String TARGET_RUNTIME_GROUP_LABEL;
        public static String JPA_PROJECT_GROUP_LABEL;
        public static String NEW_JPA_PROJECT_BUTTON;
        public static String EMPTY_WEB_PROJECT_NAME;
        public static String EXISTING_WEB_PROJECT_NAME;
        public static String INVALID_WEB_PROJECT_NAME;

        static {
            Resources.initializeMessages((String)DataModelFacetCreationWizardPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

