/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowData;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowTemplateData;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ADFLibraryUtils {
    private static final int COPY_BUFFER_SIZE = 2048;

    public static IProject getProject(IStructuredSelection selection) {
        Object firstElement;
        IProject project = null;
        if (selection != null && (firstElement = selection.getFirstElement()) instanceof IResource) {
            project = ((IResource)firstElement).getProject();
        }
        return project;
    }

    public static boolean isADFLibrary(String filename) {
        boolean isADFLibrary = false;
        JarFile jarFile = null;
        try {
            JarEntry jarEntry;
            jarFile = ADFLibraryUtils.getJarFile(filename);
            if (jarFile != null && (jarEntry = jarFile.getJarEntry("META-INF/oracle.adf.common.services.ResourceService.sva")) != null) {
                isADFLibrary = true;
            }
        }
        finally {
            ADFLibraryUtils.closeJarFile(jarFile);
        }
        return isADFLibrary;
    }

    public static JarFile getJarFile(String filename) {
        File file;
        JarFile jarFile = null;
        if (filename != null && (file = new File(filename)).canRead()) {
            try {
                jarFile = new JarFile(file, false, 1);
            }
            catch (IOException iOException) {
                jarFile = null;
            }
        }
        return jarFile;
    }

    public static void closeJarFile(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copyToJAR(JarOutputStream out, InputStream in, String entryName) throws IOException {
        if (out != null && in != null && entryName != null && entryName.length() > 0) {
            out.putNextEntry(new JarEntry(entryName));
            byte[] buf = new byte[2048];
            int bytesRead = 0;
            while (bytesRead > -1) {
                bytesRead = in.read(buf, 0, 2048);
                if (bytesRead <= 0) continue;
                out.write(buf, 0, bytesRead);
            }
            out.closeEntry();
        }
    }

    public static List<IPath> getOutputLocations(IProject project) throws JavaModelException {
        IJavaProject javaProject;
        ArrayList<IPath> locations = new ArrayList<IPath>();
        if (project != null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
            boolean addDefaultLocation = false;
            IClasspathEntry[] classPathEntries = javaProject.getResolvedClasspath(false);
            if (classPathEntries != null) {
                IClasspathEntry[] iClasspathEntryArray = classPathEntries;
                int n = classPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                    if (classPathEntry.getEntryKind() == 3) {
                        IPath location = classPathEntry.getOutputLocation();
                        if (location != null) {
                            locations.add(location);
                        } else {
                            addDefaultLocation = true;
                        }
                    }
                    ++n2;
                }
            }
            if (addDefaultLocation) {
                locations.add(javaProject.getOutputLocation());
            }
        }
        return locations;
    }

    public static List<IProject> getDependentProjects(IProject project) throws JavaModelException {
        IClasspathEntry[] classPathEntries;
        IJavaProject javaProject;
        ArrayList<IProject> depProjects = new ArrayList<IProject>();
        if (project != null && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists() && (classPathEntries = javaProject.getResolvedClasspath(false)) != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource;
                IPath path;
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (classPathEntry.getEntryKind() == 2 && (path = classPathEntry.getPath()) != null && (resource = project.getParent().findMember(path)) instanceof IProject) {
                    depProjects.add((IProject)resource);
                }
                ++n2;
            }
        }
        return depProjects;
    }

    public static IPath getWebContentPath(IProject project) {
        IContainer container;
        IVirtualFolder virtFolder;
        IVirtualComponent virtComp;
        IPath path = null;
        if (project != null && WtpProjectUtil.isDynamicWebProject((IProject)project) && (virtComp = ComponentCore.createComponent((IProject)project)) != null && (virtFolder = virtComp.getRootFolder()) != null && (container = virtFolder.getUnderlyingFolder()) != null) {
            path = container.getLocation();
        }
        return path;
    }

    public static void log(int severity, String message, Throwable exception) {
        Activator.log((IStatus)new Status(severity, "oracle.eclipse.tools.adf.view.ui", message, exception));
    }

    public static TaskFlowData getTaskFlowData(String location, IFile file) throws Exception {
        if (location == null || file == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        TaskFlowData data = new TaskFlowData(location);
        data.setTaskFlow(TaskFlowFactory.createTaskFlow((IFile)file));
        return data;
    }

    public static TaskFlowTemplateData getTaskFlowTemplateData(String location, IFile file) throws Exception {
        if (location == null || file == null) {
            throw new IllegalAccessException("Arguments cannot be null");
        }
        return TaskFlowTemplateData.create(location, file);
    }
}

