/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibrary;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.IADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import oracle.eclipse.tools.common.util.StringInputStream;
import org.eclipse.osgi.util.NLS;

public class WebIndexADFLibraryListener
implements IADFLibraryListener {
    private String webContentPath;
    private List<String> webFiles;

    public WebIndexADFLibraryListener(String webContentPath) throws IllegalArgumentException {
        if (webContentPath == null) {
            throw new IllegalArgumentException("webContentPath must not be null");
        }
        this.webContentPath = webContentPath;
        this.webFiles = new ArrayList<String>();
    }

    @Override
    public void entryAdded(ADFLibrary library, String sourceLocation, String destinationLocation) {
        if (sourceLocation != null && destinationLocation != null && sourceLocation.startsWith(this.webContentPath) && !destinationLocation.startsWith("WEB-INF") && !destinationLocation.startsWith("META-INF")) {
            this.webFiles.add(destinationLocation);
        }
    }

    @Override
    public void entryRemoved(ADFLibrary library, String sourceLocation) {
    }

    @Override
    public void libraryWritten(ADFLibrary library, JarOutputStream out) {
        if (!this.webFiles.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String webFile : this.webFiles) {
                sb.append(webFile).append("\r\n");
            }
            try {
                ADFLibraryUtils.copyToJAR(out, (InputStream)new StringInputStream(sb.toString()), "META-INF/adflibWEBINDEX.txt");
            }
            catch (IOException ioex) {
                ADFLibraryUtils.log(4, Resources.ERROR_WRITING_WEBINDEX, ioex);
            }
        }
    }

    private static class Resources
    extends NLS {
        public static String ERROR_WRITING_WEBINDEX;

        static {
            Resources.initializeMessages((String)WebIndexADFLibraryListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

