/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import oracle.eclipse.tools.common.ui.dialogs.CommonDialogs;
import oracle.eclipse.tools.common.util.resources.IProjectFilter;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ADFLibraryWizardPageOne
extends WizardPage {
    public static final int MODE_IMPORT = 0;
    public static final int MODE_EXPORT = 1;
    private int mode;
    private IProject project;
    private Text txtProject;
    private Text txtJARName;
    private Table tblDepProjects;
    private boolean projectIsValid = false;
    private boolean JARNameIsValid = false;

    public ADFLibraryWizardPageOne(int theMode) {
        super("ADFLibraryWizardPageOne", Resources.TITLE_WIZARD, null);
        this.mode = theMode < 0 || theMode > 1 ? 1 : theMode;
        if (this.mode == 0) {
            this.setTitle(Resources.TITLE_IMPORT);
            this.setDescription(Resources.DESC_IMPORT);
        } else {
            this.setTitle(Resources.TITLE_EXPORT);
            this.setDescription(Resources.DESC_EXPORT);
        }
        this.setPageComplete(false);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblProject = new Label(composite, 0);
        lblProject.setText(Resources.LBL_PROJECT);
        this.txtProject = new Text(composite, 2048);
        if (this.project != null) {
            this.txtProject.setText(this.project.getName());
        }
        this.txtProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ADFLibraryWizardPageOne.this.handleTxtProjectModified(true, true);
            }
        });
        this.handleTxtProjectModified(false, false);
        Button btnProject = new Button(composite, 8);
        btnProject.setText(Resources.BTN_PROJECT);
        btnProject.setToolTipText(Resources.BTN_PROJECT_TOOLTIP);
        btnProject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ADFLibraryWizardPageOne.this.handleBtnProjectSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        Label lblJARName = new Label(composite, 0);
        lblJARName.setText(Resources.LBL_JAR_NAME);
        this.txtJARName = new Text(composite, 2048);
        this.txtJARName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtJARName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ADFLibraryWizardPageOne.this.handleTxtJARNameModified();
            }
        });
        Button btnJARName = new Button(composite, 8);
        btnJARName.setText(Resources.BTN_JAR_NAME);
        btnJARName.setToolTipText(Resources.BTN_JAR_NAME_TOOLTIP);
        btnJARName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ADFLibraryWizardPageOne.this.handleBtnJARNameSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        if (this.mode == 1) {
            this.addDepProjectsTable(composite);
            this.addUniquePackageLink(composite);
        }
        this.setControl((Control)composite);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getADFLibraryFilename() {
        String filename = null;
        if (this.txtJARName != null) {
            filename = this.txtJARName.getText();
        }
        return filename;
    }

    public List<IProject> getDependentProjects() {
        TableItem[] items;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (this.tblDepProjects != null && (items = this.tblDepProjects.getItems()) != null) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object objData;
                TableItem item = tableItemArray[n2];
                if (item.getChecked() && (objData = item.getData()) instanceof IProject) {
                    projects.add((IProject)objData);
                }
                ++n2;
            }
        }
        return projects;
    }

    private void handleTxtProjectModified(boolean validate, boolean updateDependentProjectsTable) {
        boolean isValid = false;
        String projectName = this.txtProject.getText();
        IProject newProject = null;
        if (projectName != null && projectName.length() > 0 && (newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && newProject.isAccessible()) {
            isValid = WtpProjectUtil.isDynamicWebProject((IProject)newProject);
        }
        if (isValid) {
            this.project = newProject;
            this.projectIsValid = true;
        } else {
            this.project = null;
            this.projectIsValid = false;
        }
        if (validate) {
            this.validate();
        }
        if (updateDependentProjectsTable) {
            this.updateDependentProjectsTable();
        }
    }

    private void handleBtnProjectSelected() {
        IProject newProject = CommonDialogs.showSelectProjectDialog((Shell)this.getShell(), (IProjectFilter)WtpProjectUtil.createDynamicWebProjectFilter());
        if (newProject != null) {
            this.txtProject.setText(newProject.getName());
            this.handleTxtProjectModified(true, true);
        }
    }

    private void handleTxtJARNameModified() {
        if (this.mode == 0) {
            this.JARNameIsValid = ADFLibraryUtils.isADFLibrary(this.txtJARName.getText());
        } else {
            String filename = this.txtJARName.getText();
            File file = new File(filename);
            this.JARNameIsValid = filename.length() > 0 && (!file.exists() || file.canWrite());
        }
        this.validate();
    }

    private void handleBtnJARNameSelected() {
        int style = this.mode == 0 ? 4096 : 8192;
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog dialog = new FileDialog(shell, style);
        dialog.setOverwrite(true);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.setFilterNames(new String[]{Resources.FILEDIALOG_FILTER_NAME});
        String JARName = dialog.open();
        if (JARName != null) {
            this.txtJARName.setText(JARName);
            this.handleTxtJARNameModified();
        }
    }

    private void handleUniquePackageLinkSelected() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("oracle.eclipse.tools.adf.doc.adf_lifecycle");
    }

    private void addDepProjectsTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Resources.LBL_DEPENDENT_PROJECTS);
        GridData gdLabel = new GridData(4, 128, true, false);
        gdLabel.horizontalSpan = 3;
        label.setLayoutData((Object)gdLabel);
        this.tblDepProjects = new Table(parent, 2850);
        GridData gdTable = new GridData(4, 4, true, true);
        gdTable.horizontalSpan = 3;
        gdTable.horizontalIndent = 8;
        this.tblDepProjects.setLayoutData((Object)gdTable);
        this.updateDependentProjectsTable();
    }

    private void addUniquePackageLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Resources.LINK_UNIQUE_PACKAGE);
        GridData gdLink = new GridData(4, 128, true, false);
        gdLink.horizontalSpan = 3;
        gdLink.verticalIndent = 8;
        link.setLayoutData((Object)gdLink);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ADFLibraryWizardPageOne.this.handleUniquePackageLinkSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    private void updateDependentProjectsTable() {
        this.tblDepProjects.removeAll();
        if (this.project != null) {
            try {
                List<IProject> depProjects = ADFLibraryUtils.getDependentProjects(this.project);
                for (IProject depProject : depProjects) {
                    TableItem item = new TableItem(this.tblDepProjects, 0);
                    item.setData((Object)depProject);
                    item.setText(depProject.getName());
                    item.setImage(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage((Object)depProject));
                    item.setChecked(true);
                }
            }
            catch (JavaModelException jmex) {
                ADFLibraryUtils.log(4, Resources.ERROR_GETTING_DEPENDENT_PROJECTS, jmex);
            }
        }
    }

    private void validate() {
        this.setPageComplete(this.projectIsValid && this.JARNameIsValid);
        if (!this.projectIsValid) {
            this.setErrorMessage(Resources.ERROR_INVALID_PROJECT);
        } else if (!this.JARNameIsValid) {
            this.setErrorMessage(Resources.ERROR_INVALID_ADFLIBRARY);
        } else {
            this.setErrorMessage(null);
        }
    }

    private static class Resources
    extends NLS {
        public static String TITLE_WIZARD;
        public static String TITLE_IMPORT;
        public static String TITLE_EXPORT;
        public static String DESC_IMPORT;
        public static String DESC_EXPORT;
        public static String LBL_PROJECT;
        public static String BTN_PROJECT;
        public static String BTN_PROJECT_TOOLTIP;
        public static String LBL_JAR_NAME;
        public static String BTN_JAR_NAME;
        public static String BTN_JAR_NAME_TOOLTIP;
        public static String LBL_DEPENDENT_PROJECTS;
        public static String LINK_UNIQUE_PACKAGE;
        public static String FILEDIALOG_FILTER_NAME;
        public static String ERROR_INVALID_ADFLIBRARY;
        public static String ERROR_INVALID_PROJECT;
        public static String ERROR_GETTING_DEPENDENT_PROJECTS;

        static {
            Resources.initializeMessages((String)ADFLibraryWizardPageOne.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

