/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.util;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.adf.view.variables.AdfControllerExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class CollectedArtifactUtils {
    private static final String ADF_BEAN_CATEGORY_ID = "adf-managed-bean";

    public static String getTypeName(IFile file, String variable) {
        if (file == null) {
            return null;
        }
        VariablesController controller = VariablesController.getInstance();
        for (Variable var : controller.iterator(file, true).getVariables()) {
            if (!var.getName().equals(variable) || !(var instanceof AdfControllerExternalVariable)) continue;
            DataType varType = var.getType();
            return varType.getName();
        }
        return null;
    }

    public static String getTypeName(Variable var) {
        if (var instanceof AdfControllerExternalVariable) {
            DataType varType = var.getType();
            return varType != null ? varType.getName() : null;
        }
        return null;
    }

    public static Variable getVariable(IFile file, String variable) {
        if (file == null) {
            return null;
        }
        VariablesController controller = VariablesController.getInstance();
        for (Variable var : controller.iterator(file, true).getVariables()) {
            if (!var.getName().equals(variable) || !(var instanceof AdfControllerExternalVariable)) continue;
            return var;
        }
        return null;
    }

    public static Variable.SCOPE getScope(Variable var) {
        if (var instanceof AdfControllerExternalVariable) {
            return var.getScope();
        }
        return Variable.SCOPE.NONE_SCOPE;
    }

    public static final Set<IArtifact> getManagedBeanArtifacts(IProject project) {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        if (model != null) {
            return model.queryArtifactsByTypes(Collections.singleton(ADF_BEAN_CATEGORY_ID), project);
        }
        return Collections.emptySet();
    }
}

