/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.pagedefinition;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.editor.OutlineBlock;
import oracle.eclipse.tools.adf.dtrt.ui.provider.PageDefinitionContextContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseMenuCreator;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.BindingPage;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.CategoryDetailPage;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.DataControlCategoryDetailPage;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.PageDefinitionObjectDetailsPage;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.PageDefinitionOutline;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.ide.IDE;

class PageDefinitionOutlineBlock
extends OutlineBlock<IPageDefinitionContext> {
    private static final String IMAGE_XML_DOC = "icons/full/obj16/xmldoc.gif";

    public PageDefinitionOutlineBlock(BindingPage editorPage) {
        super((EditorPage)editorPage);
    }

    public PageDefinitionOutline getOutline() {
        return (PageDefinitionOutline)super.getOutline();
    }

    protected Outline<IPageDefinitionContext> createOutline(EditorPage<IPageDefinitionContext> editorPage) {
        return new PageDefinitionOutline((BindingPage)editorPage, "PageDefinitionOutline.OutlineBlock");
    }

    protected BindingPage getEditorPage() {
        return (BindingPage)super.getEditorPage();
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)this);
        detailsPart.registerPage(IObject.class, (IDetailsPage)new PageDefinitionObjectDetailsPage(this.getEditorPage()));
        detailsPart.registerPage(IBindingObject.class, (IDetailsPage)new CategoryDetailPage(this.getEditorPage()));
        detailsPart.registerPage(IDataControlObject.class, (IDetailsPage)new DataControlCategoryDetailPage(this.getEditorPage()));
    }

    public Object getPageKey(Object object) {
        return object instanceof IObject ? IObject.class : (object instanceof PageDefinitionContextContentProvider.Category && IBindingObject.class.isAssignableFrom(((PageDefinitionContextContentProvider.Category)object).getType()) ? IBindingObject.class : (object instanceof PageDefinitionContextContentProvider.Category && IDataControlObject.class.isAssignableFrom(((PageDefinitionContextContentProvider.Category)object).getType()) ? IDataControlObject.class : null));
    }

    protected void doUpdateToolBarActions(IToolBarManager toolBarManager) {
        String editorId;
        boolean isXMLEditor;
        block10: {
            IAction openDataBindingsAction;
            IPageDefinition pageDefinition = this.getEditorPage().getContext().getPageDefinition();
            List boundSources = pageDefinition != null ? pageDefinition.getBoundSources() : Collections.emptyList();
            IAction openFileAction = this.computeOpenFileAction(boundSources, Messages.openBoundSource, Messages.noWebPages, false);
            if (openFileAction != null) {
                toolBarManager.add(openFileAction);
            }
            if ((openDataBindingsAction = this.computeOpenFileAction(this.getEditorPage().getContext().getApplications().keySet(), Messages.openDataBindings, Messages.noWebPages, true)) != null) {
                toolBarManager.add(openDataBindingsAction);
            }
            isXMLEditor = false;
            editorId = null;
            if (pageDefinition != null) {
                try {
                    IFile pageDefinitionFile;
                    IEditorDescriptor[] editorDescriptors;
                    IEditorRegistry editorRegistry = this.getEditorPage().getSite().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                    if (editorRegistry == null || (editorDescriptors = editorRegistry.getEditors((pageDefinitionFile = DTRTUIUtil.getAccessiblePageDefinitionFile((IPageDefinitionContext)this.getEditorPage().getContext())).getFullPath().toString())) == null) break block10;
                    IEditorDescriptor[] iEditorDescriptorArray = editorDescriptors;
                    int n = editorDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n2];
                        if (editorDescriptor.isInternal()) {
                            String id = editorDescriptor.getId();
                            if ("org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart".equals(id)) {
                                editorId = id;
                                isXMLEditor = true;
                                break;
                            }
                            if (editorId == null && "org.eclipse.ui.DefaultTextEditor".equals(id)) {
                                editorId = id;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    DTRTViewUIUtil.log(e);
                }
            }
        }
        if (editorId != null) {
            Action openTextEditorAction = new Action(null, 1){

                public void run() {
                    IFile file = DTRTUIUtil.getAccessiblePageDefinitionFile((IPageDefinitionContext)PageDefinitionOutlineBlock.this.getEditorPage().getContext());
                    String editorId = this.getId();
                    try {
                        DTRTUIUtil.openEditor((IFile)file, (String)editorId, (int)-1, (int)-1);
                    }
                    catch (Exception e) {
                        DTRTUIUtil.handleError((Shell)DTRTUIUtil.getShell((IWorkbenchPart)PageDefinitionOutlineBlock.this.getEditorPage()), (Throwable)e);
                    }
                }
            };
            openTextEditorAction.setId(editorId);
            openTextEditorAction.setToolTipText(isXMLEditor ? Messages.openXMLEditor : Messages.openTextEditor);
            openTextEditorAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.PAGE_DEFINITION_XML)));
            toolBarManager.add((IAction)openTextEditorAction);
        }
        super.doUpdateToolBarActions(toolBarManager);
    }

    private IAction computeOpenFileAction(final Collection<? extends IDescribable> describables, String multiFileActionTitle, String noFilesActionTitle, boolean useDescribabaleImageAsMultiFileActionImage) {
        Action openFileAction = null;
        if (describables.size() == 1) {
            IDescribable describable = describables.iterator().next();
            IFile file = this.getOpenFileActionAccessibleFile(describable);
            if (file != null) {
                String text = DTRTUtil.getLabel((IDescribable)describable);
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((IDescribable)describable));
                openFileAction = this.createOpenFileAction(file, text, NLS.bind((String)Messages.openTheFile, (Object)DTRTUtil.getWebResourcePath((IFile)file)), imageDescriptor);
            }
        } else if (describables.size() > 1) {
            BaseMenuCreator menuCreator = new BaseMenuCreator(){

                protected void initializeMenu(Menu menu) {
                    for (IDescribable describable : describables) {
                        IFile file = PageDefinitionOutlineBlock.this.getOpenFileActionAccessibleFile(describable);
                        if (file == null) continue;
                        String text = DTRTUtil.getLabel((IDescribable)describable);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((IDescribable)describable));
                        IAction action = PageDefinitionOutlineBlock.this.createOpenFileAction(file, text, null, imageDescriptor);
                        ActionContributionItem item = new ActionContributionItem(action);
                        item.fill(menu, -1);
                    }
                }
            };
            openFileAction = new Action(multiFileActionTitle, 4){};
            openFileAction.setToolTipText(multiFileActionTitle);
            ImageDescriptor imageDescriptor = useDescribabaleImageAsMultiFileActionImage ? ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((IDescribable)describables.iterator().next())) : Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)IMAGE_XML_DOC);
            openFileAction.setImageDescriptor(imageDescriptor);
            openFileAction.setMenuCreator((IMenuCreator)menuCreator);
        } else {
            openFileAction = new Action(noFilesActionTitle, 1){};
            openFileAction.setToolTipText(noFilesActionTitle);
            openFileAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)IMAGE_XML_DOC));
            openFileAction.setEnabled(false);
        }
        return openFileAction;
    }

    private IFile getOpenFileActionAccessibleFile(IDescribable describable) {
        if (describable instanceof IPageDefinition.IBoundSource) {
            IFile file = ((IPageDefinition.IBoundSource)describable).getFile();
            return file != null && file.isAccessible() ? file : null;
        }
        if (describable instanceof IApplication) {
            return ((IPageDefinitionContext)this.getOutline().getContext()).getAccessibleFile((IObject)((IApplication)describable));
        }
        throw new IllegalArgumentException("Unknown object: " + describable);
    }

    private IAction createOpenFileAction(final IFile file, String text, String toolTipText, ImageDescriptor imageDescriptor) {
        Action action = new Action(text, imageDescriptor){

            public void run() {
                try {
                    IWorkbenchPage page;
                    IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbench != null && (page = workbench.getActivePage()) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (CoreException e) {
                    DTRTUIUtil.handleError((Shell)DTRTUIUtil.getShell((IWorkbenchPart)PageDefinitionOutlineBlock.this.getEditorPage()), (Throwable)e);
                }
            }
        };
        if (toolTipText != null) {
            action.setToolTipText(toolTipText);
        }
        return action;
    }

    private static class Messages
    extends NLS {
        public static String openTheFile;
        public static String openBoundSource;
        public static String openDataBindings;
        public static String openXMLEditor;
        public static String openTextEditor;
        public static String noWebPages;

        static {
            NLS.initializeMessages((String)PageDefinitionOutlineBlock.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

