/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.pagedefinition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.BaseDetailPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.provider.PageDefinitionContextContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.FormTextHTMLGenerator;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.BindingPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

class CategoryDetailPage
extends BaseDetailPage<IPageDefinitionContext> {
    private Section summarySection;
    private Text totalText;
    private Text totalUsedText;
    private Text totalInvalidText;
    private Section validationSection;
    private PageBook validationPageBook;
    private Control validationPageBookDefaultControl;
    private Control validationControl;
    private Section usageSection;
    private PageBook usagePageBook;
    private Control usagePageBookDefaultControl;
    private Control usageControl;
    private DTRTUIUtil.ExpandableCompositeAdapter expandableCompositeAdapter;

    public CategoryDetailPage(BindingPage bindingPage) {
        super((EditorPage)bindingPage);
    }

    public void dispose() {
        if (this.expandableCompositeAdapter != null) {
            this.expandableCompositeAdapter.dispose();
            this.expandableCompositeAdapter = null;
        }
        this.summarySection = null;
        this.totalText = null;
        this.totalUsedText = null;
        this.totalInvalidText = null;
        this.validationSection = null;
        this.validationPageBook = null;
        this.validationPageBookDefaultControl = null;
        this.validationControl = null;
        this.usageSection = null;
        this.usagePageBook = null;
        this.usagePageBookDefaultControl = null;
        this.usageControl = null;
        super.dispose();
    }

    protected BindingPage getEditorPage() {
        return (BindingPage)super.getEditorPage();
    }

    public void createContents(Composite parent) {
        super.createContents(parent);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.summarySection = BaseDetailPage.createSection((IManagedForm)this.getManagedForm(), (Composite)parent, (String)Messages.summary, (boolean)false, (int)64);
        Composite summaryComposite = toolkit.createComposite((Composite)this.summarySection, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(summaryComposite);
        this.summarySection.setClient((Control)summaryComposite);
        this.totalText = DTRTUIUtil.createTextRow((FormToolkit)toolkit, (Composite)summaryComposite, (String)Messages.totalLabel, (int)8);
        this.totalInvalidText = DTRTUIUtil.createTextRow((FormToolkit)toolkit, (Composite)summaryComposite, (String)Messages.totalInvalidLabel, (int)8);
        this.totalInvalidText.setToolTipText(Messages.totalInvalidTooltip);
        this.totalUsedText = DTRTUIUtil.createTextRow((FormToolkit)toolkit, (Composite)summaryComposite, (String)Messages.totalUsedLabel, (int)8);
        this.validationSection = BaseDetailPage.createSection((IManagedForm)this.getManagedForm(), (Composite)parent, (String)Messages.validationDetails, (boolean)false, (int)64);
        this.validationPageBook = new PageBook((Composite)this.validationSection, 0);
        toolkit.adapt((Composite)this.validationPageBook);
        this.validationSection.setClient((Control)this.validationPageBook);
        this.validationPageBookDefaultControl = toolkit.createLabel((Composite)this.validationPageBook, "");
        this.validationPageBook.showPage(this.validationPageBookDefaultControl);
        this.usageSection = BaseDetailPage.createSection((IManagedForm)this.getManagedForm(), (Composite)parent, (String)Messages.usageDetails, (boolean)false, (int)64);
        this.usagePageBook = new PageBook((Composite)this.usageSection, 0);
        toolkit.adapt((Composite)this.usagePageBook);
        this.usageSection.setClient((Control)this.usagePageBook);
        this.usagePageBookDefaultControl = toolkit.createLabel((Composite)this.usagePageBook, "");
        this.usagePageBook.showPage(this.usagePageBookDefaultControl);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (this.summarySection != null) {
            Object selectedObject = DTRTUIUtil.getFirstElement((ISelection)selection);
            if (selectedObject instanceof PageDefinitionContextContentProvider.Category) {
                Class type;
                Class clazz = type = this.getEditorPage().getContext().getPageDefinition() != null ? ((PageDefinitionContextContentProvider.Category)selectedObject).getType() : null;
                if (type == IBinding.class) {
                    this.refreshBindingsInfo();
                } else if (type == IExecutable.class) {
                    this.refreshExecutablesInfo();
                } else {
                    this.validationPageBook.showPage(this.validationPageBookDefaultControl);
                    if (this.validationControl != null) {
                        this.validationControl.dispose();
                        this.validationControl = null;
                    }
                    this.usagePageBook.showPage(this.usagePageBookDefaultControl);
                    if (this.usageControl != null) {
                        this.usageControl.dispose();
                        this.usageControl = null;
                    }
                }
                DTRTUIUtil.controlChanged((Control)this.usagePageBook);
            }
            this.summarySection.setData("Selection", (Object)selection);
        }
    }

    private void refreshBindingsInfo() {
        List bindings = this.getEditorPage().getContext().getPageDefinition().getBindings();
        ArrayList<IBinding> valid = new ArrayList<IBinding>(bindings.size());
        ArrayList<IBinding> notValid = new ArrayList<IBinding>(bindings.size() / 2);
        ArrayList<IBinding> mayNotBeValid = new ArrayList<IBinding>(bindings.size() / 4);
        ArrayList<IBinding> used = new ArrayList<IBinding>(bindings.size());
        ArrayList<IBinding> notUsed = new ArrayList<IBinding>(bindings.size() / 2);
        for (IBinding binding : bindings) {
            IStatus status = (IStatus)this.getEditorPage().getEditor().getValidationMap().get(binding);
            if (status == null || status.isOK()) {
                valid.add(binding);
            } else if (status.getSeverity() == 4) {
                notValid.add(binding);
            } else {
                mayNotBeValid.add(binding);
            }
            if (this.getEditorPage().getUsageManager().getUsages((IBindingObject)binding).isEmpty()) {
                notUsed.add(binding);
                continue;
            }
            used.add(binding);
        }
        this.refreshInfo(Messages.bindingSummary, Messages.validationDetails, Messages.usageDetails, valid, valid.size() == 1 ? Messages.oneBindingValid : Messages.bindingsValid, notValid, notValid.size() == 1 ? Messages.oneBindingNotValid : Messages.bindingsNotValid, mayNotBeValid, mayNotBeValid.size() == 1 ? Messages.oneBindingMayBeNotValid : Messages.bindingsMayBeNotValid, used, used.size() == 1 ? Messages.oneBindingUsed : Messages.bindingsUsed, notUsed, notUsed.size() == 1 ? Messages.oneBindingNotUsed : Messages.bindingsNotUsed);
    }

    private void refreshExecutablesInfo() {
        List executables = this.getEditorPage().getContext().getPageDefinition().getExecutables();
        ArrayList<IExecutable> valid = new ArrayList<IExecutable>(executables.size());
        ArrayList<IExecutable> notValid = new ArrayList<IExecutable>(executables.size() / 2);
        ArrayList<IExecutable> mayBeNotValid = new ArrayList<IExecutable>(executables.size() / 4);
        ArrayList<IExecutable> used = new ArrayList<IExecutable>(executables.size());
        ArrayList<IExecutable> notUsed = new ArrayList<IExecutable>(executables.size() / 2);
        for (IExecutable executable : executables) {
            IStatus status = (IStatus)this.getEditorPage().getEditor().getValidationMap().get(executable);
            if (status == null || status.isOK()) {
                valid.add(executable);
            } else if (status.getSeverity() == 4) {
                notValid.add(executable);
            } else {
                mayBeNotValid.add(executable);
            }
            if (!executable.collectUsage().isEmpty()) {
                used.add(executable);
                continue;
            }
            notUsed.add(executable);
        }
        this.refreshInfo(Messages.executableSummary, Messages.validationDetails, Messages.usageDetails, valid, valid.size() == 1 ? Messages.oneExecutableValid : Messages.executablesValid, notValid, notValid.size() == 1 ? Messages.oneExecutableNotValid : Messages.executablesNotValid, mayBeNotValid, mayBeNotValid.size() == 1 ? Messages.oneExecutableMayBeNotValid : Messages.executablesMayBeNotValid, used, used.size() == 1 ? Messages.oneExecutablesUsed : Messages.executablesUsed, notUsed, notUsed.size() == 1 ? Messages.oneExecutableNotUsed : Messages.executablesNotUsed);
    }

    private void refreshInfo(String summarySectionTitle, String validationSectionTitle, String usageSectionTitle, List<? extends IBindingObject> validObjects, String validMessage, List<? extends IBindingObject> notValidObjects, String notValidMessage, List<? extends IBindingObject> mayNotBeValidObjects, String mayNotBeValidMessage, List<? extends IBindingObject> usedObjects, String usedMessage, List<? extends IBindingObject> notUsedObjects, String notUsedMessage) {
        this.summarySection.setText(summarySectionTitle);
        this.totalText.setText(String.valueOf(validObjects.size() + notValidObjects.size() + mayNotBeValidObjects.size()));
        this.totalInvalidText.setText(String.valueOf(notValidObjects.size() + mayNotBeValidObjects.size()));
        this.totalUsedText.setText(String.valueOf(usedObjects.size()));
        this.usageSection.setText(usageSectionTitle);
        Control vControl = this.refreshInfo(this.validationPageBook, validMessage, validObjects, notValidMessage, notValidObjects, mayNotBeValidMessage, mayNotBeValidObjects);
        Control uControl = this.refreshInfo(this.usagePageBook, usedMessage, usedObjects, notUsedMessage, notUsedObjects);
        if (this.validationControl != null) {
            this.validationControl.dispose();
        }
        this.validationControl = vControl;
        if (this.usageControl != null) {
            this.usageControl.dispose();
        }
        this.usageControl = uControl;
    }

    private Control refreshInfo(PageBook pageBook, String title1, List<? extends IBindingObject> objects1, String title2, List<? extends IBindingObject> objects2, String title3, List<? extends IBindingObject> objects3) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite composite = toolkit.createComposite((Composite)pageBook, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.refreshInfo(composite, title1, objects1);
        this.refreshInfo(composite, title2, objects2);
        this.refreshInfo(composite, title3, objects3);
        pageBook.showPage((Control)composite);
        return composite;
    }

    private Control refreshInfo(PageBook pageBook, String title1, List<? extends IBindingObject> objects1, String title2, List<? extends IBindingObject> objects2) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite composite = toolkit.createComposite((Composite)pageBook, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.refreshInfo(composite, title1, objects1);
        this.refreshInfo(composite, title2, objects2);
        pageBook.showPage((Control)composite);
        return composite;
    }

    private void refreshInfo(Composite parent, String baseTitle, List<? extends IBindingObject> objects) {
        if (!objects.isEmpty()) {
            HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    Object object = FormTextHTMLGenerator.decodeHRef((FormText)((FormText)event.widget), (Object)event.getHref());
                    if (object instanceof IObject) {
                        CategoryDetailPage.this.getManagedForm().fireSelectionChanged((IFormPart)CategoryDetailPage.this, (ISelection)new StructuredSelection(object));
                    }
                }
            };
            if (this.expandableCompositeAdapter == null) {
                this.expandableCompositeAdapter = new DTRTUIUtil.ExpandableCompositeAdapter(this.getManagedForm());
            }
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            int style = 20;
            style = this.expandableCompositeAdapter.adjustExpandedState(baseTitle, style);
            ExpandableComposite expandableComposite = DTRTUIUtil.createExpandableComposite((FormToolkit)toolkit, (Composite)parent, (int)style, (boolean)true);
            this.expandableCompositeAdapter.setId(expandableComposite, baseTitle);
            expandableComposite.setText(NLS.bind((String)baseTitle, (Object)objects.size()));
            expandableComposite.addExpansionListener((IExpansionListener)this.expandableCompositeAdapter);
            FormText formText = DTRTUIUtil.createFormText((FormToolkit)toolkit, (Composite)expandableComposite, (int)(0x48 | toolkit.getOrientation()));
            formText.addHyperlinkListener((IHyperlinkListener)hyperlinkAdapter);
            this.refreshFormText(formText, objects);
            expandableComposite.setClient((Control)formText);
        }
    }

    private void refreshFormText(FormText formText, List<? extends IBindingObject> bindingObjects) {
        Collections.sort(bindingObjects);
        FormTextHTMLGenerator.HTMLUnorderedList generator = new FormTextHTMLGenerator.HTMLUnorderedList(formText);
        for (IBindingObject iBindingObject : bindingObjects) {
            IDescriptor descriptor = iBindingObject.getDescriptor();
            if (descriptor == null) continue;
            generator.addLI(DTRTUIUtil.getImage((IDescriptor)descriptor), (Object)iBindingObject, descriptor.getLabel());
        }
        generator.flush();
    }

    public void refresh() {
        if (this.summarySection != null) {
            ISelection selection = (ISelection)this.summarySection.getData("Selection");
            this.selectionChanged(null, selection);
        }
    }

    public void setFocus() {
    }

    public boolean isStale() {
        return true;
    }

    private static class Messages
    extends NLS {
        public static String summary;
        public static String bindingSummary;
        public static String executableSummary;
        public static String totalLabel;
        public static String totalUsedLabel;
        public static String totalInvalidLabel;
        public static String validationDetails;
        public static String usageDetails;
        public static String bindingsValid;
        public static String oneBindingValid;
        public static String bindingsNotValid;
        public static String oneBindingNotValid;
        public static String executablesValid;
        public static String oneExecutableValid;
        public static String executablesNotValid;
        public static String oneExecutableNotValid;
        public static String bindingsUsed;
        public static String oneBindingUsed;
        public static String bindingsNotUsed;
        public static String oneBindingNotUsed;
        public static String executablesUsed;
        public static String oneExecutablesUsed;
        public static String executablesNotUsed;
        public static String oneExecutableNotUsed;
        public static String executablesMayBeNotValid;
        public static String oneExecutableMayBeNotValid;
        public static String bindingsMayBeNotValid;
        public static String oneBindingMayBeNotValid;
        public static String totalInvalidTooltip;

        static {
            NLS.initializeMessages((String)CategoryDetailPage.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

