/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.AbstractDataModelWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaClassInputComposite;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewSessionBeanFromEntitiesWizard;
import oracle.eclipse.tools.adf.view.ui.util.JavaUtils;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SessionBeanInputPage
extends AbstractDataModelWizardPage
implements PropertyChangeListener {
    private JavaClassInputComposite javaClassComposite;
    private Label border;
    private boolean isEdit = false;
    private static final int HORIZONTAL_OFFSET = 10;
    private static final int HORIZONTAL_GAP = 10;
    private static final int VERTICAL_OFFSET = 10;
    private static final int VERTICAL_GAP = 8;
    public static final IProjectFacet EJB_MODULE_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    public static final IProjectFacet WEB_MODULE_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    private Label sessionTypeLabel;
    private Combo transactionTypeCombo;
    private Combo concurrencyTypeCombo;

    public SessionBeanInputPage(IDataModel dataModel, String pageName, boolean isEdit, IStructuredSelection selection, String helpContextID) {
        super(dataModel, pageName, helpContextID);
        this.setTitle(Messages.SessionBeanInputPage_title);
        this.setDescription(Messages.SessionBeanInputPage_description);
        this.isEdit = isEdit;
        if (isEdit) {
            this.computeDataModel(selection);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        if (!this.isEdit) {
            this.javaClassComposite = new JavaClassInputComposite(comp, 0);
            this.javaClassComposite.setProjectInputAndSelection(this.getJpaProjects(((DataModelWizard)this.getWizard()).getSelection()), (ISelection)((DataModelWizard)this.getWizard()).getSelection());
            this.javaClassComposite.addPropertyChangeListener(this);
            FormData fd_javaClassComposite = new FormData();
            fd_javaClassComposite.top = new FormAttachment(0);
            fd_javaClassComposite.left = new FormAttachment(0, 0);
            fd_javaClassComposite.right = new FormAttachment(100, 0);
            this.javaClassComposite.setLayoutData(fd_javaClassComposite);
            this.addSeperator(comp);
        }
        Composite sComp = new Composite(comp, 0);
        sComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.border, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        sComp.setLayoutData((Object)data);
        this.createSessionGroup(sComp);
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)comp, this.helpContextID);
        }
        return comp;
    }

    @Override
    protected IStatus getStatus() {
        if (!this.isEdit) {
            IStatus webProjStatus = this.evaluateForWebProject();
            if (webProjStatus != null && webProjStatus.getSeverity() == 4) {
                return webProjStatus;
            }
            IStatus javaClassStatus = this.javaClassComposite.validate("oracle.eclipse.tools.adf.view.ui", Messages.JavaClassInputComposite_selectModelProjectError);
            if (javaClassStatus != null && javaClassStatus.getSeverity() == 4) {
                return javaClassStatus;
            }
            IStatus ejbProjStatus = this.evaluateForEJBProject();
            if (ejbProjStatus != null && ejbProjStatus.getSeverity() == 4) {
                return ejbProjStatus;
            }
            IStatus ejb3_1IStatus = this.evaluateValidSelectionEJB3_1();
            if (ejb3_1IStatus != null && ejb3_1IStatus.getSeverity() == 4) {
                return ejb3_1IStatus;
            }
            if (javaClassStatus != null && javaClassStatus.getSeverity() == 2) {
                return javaClassStatus;
            }
            if (ejbProjStatus != null && ejbProjStatus.getSeverity() == 2) {
                return ejbProjStatus;
            }
            if (webProjStatus != null && webProjStatus.getSeverity() == 2) {
                return webProjStatus;
            }
            if (ejb3_1IStatus != null && ejb3_1IStatus.getSeverity() == 2) {
                return ejb3_1IStatus;
            }
        } else {
            IStatus ejb3_1IStatus = this.evaluateValidSelectionEJB3_1();
            if (ejb3_1IStatus != null && ejb3_1IStatus.getSeverity() == 4) {
                return ejb3_1IStatus;
            }
            if (ejb3_1IStatus != null && ejb3_1IStatus.getSeverity() == 2) {
                return ejb3_1IStatus;
            }
        }
        return null;
    }

    public IWizardPage getNextPage() {
        if (!this.isEdit) {
            this.saveDataToModel();
            EntitiesSelectionPage entitiesPage = (EntitiesSelectionPage)this.getWizard().getPage("EntitiesSelection");
            IStructuredSelection ss = (IStructuredSelection)this.javaClassComposite.projectViewer.getSelection();
            IProject project = (IProject)ss.getFirstElement();
            entitiesPage.setJpaProjectName(project.getName());
            return entitiesPage;
        }
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        if (status == null || status.getSeverity() != 4) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.isEdit) {
            ISelection selection = this.javaClassComposite.projectViewer.getSelection();
            if (selection == null || selection.isEmpty()) {
                this.javaClassComposite.projectViewer.getControl().setFocus();
            } else {
                String pkg = this.javaClassComposite.textJavaPkg.getText();
                if (pkg == null || pkg.isEmpty()) {
                    this.javaClassComposite.textJavaPkg.setFocus();
                } else {
                    this.javaClassComposite.classNameText.selectAll();
                    this.javaClassComposite.classNameText.setFocus();
                }
            }
        }
    }

    private List<IProject> getJpaProjects(IStructuredSelection selection) {
        ArrayList<IProject> jpaProjList = new ArrayList<IProject>();
        Object o = selection.getFirstElement();
        IProject selectionProject = null;
        if (o instanceof IResource) {
            selectionProject = ((IResource)o).getProject();
        }
        if (selectionProject == null && o instanceof IAdaptable) {
            selectionProject = (IProject)((IAdaptable)o).getAdapter(IProject.class);
        }
        if (selectionProject != null) {
            for (JpaProject jpaProj : JPAUtils.getJpaProjects((IProject)selectionProject)) {
                jpaProjList.add(jpaProj.getProject());
            }
            return jpaProjList;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            JpaProject jpaProj = (JpaProject)proj.getAdapter(JpaProject.class);
            if (jpaProj != null) {
                jpaProjList.add(jpaProj.getProject());
            }
            ++n2;
        }
        return jpaProjList;
    }

    private void saveDataToModel() {
        DataWizardModel wizardModel = null;
        if (this.getWizard() instanceof NewADFDataModelComponentsWizard) {
            wizardModel = ((NewADFDataModelComponentsWizard)this.getWizard()).wizardModel;
        } else if (this.getWizard() instanceof NewSessionBeanFromEntitiesWizard) {
            wizardModel = ((NewSessionBeanFromEntitiesWizard)this.getWizard()).wizardModel;
        }
        this.javaClassComposite.saveDataToWizardModel(wizardModel, false);
    }

    private IStatus evaluateForEJBProject() {
        IFacetedProject facetedProject;
        IStructuredSelection ss = (IStructuredSelection)this.javaClassComposite.projectViewer.getSelection();
        IProject project = (IProject)ss.getFirstElement();
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectJPAProjError, null);
        }
        if (facetedProject != null && !facetedProject.hasProjectFacet(EJB_MODULE_FACET)) {
            return new Status(1, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectJPAProjEJBWarning, null);
        }
        return null;
    }

    private IStatus evaluateForWebProject() {
        IFacetedProject facetedProject;
        IStructuredSelection ss = (IStructuredSelection)this.javaClassComposite.projectViewer.getSelection();
        IProject project = (IProject)ss.getFirstElement();
        if (project == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_jpaProjectRequired, null);
        }
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectJPAProjError, null);
        }
        if (facetedProject != null && facetedProject.hasProjectFacet(WEB_MODULE_FACET)) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectJPAProjWebError, null);
        }
        return null;
    }

    private IStatus evaluateValidSelectionEJB3_1() {
        IFacetedProject facetedProject;
        IStructuredSelection ss = ((DataModelWizard)this.getWizard()).getSelection();
        Object element = ss.getFirstElement();
        IProject project = null;
        IResource resource = JavaUtils.getResource(element);
        if (resource != null) {
            project = resource.getProject();
        }
        if (project == null) {
            return null;
        }
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (facetedProject != null) {
            IProjectFacetVersion version3_1 = EJB_MODULE_FACET.getVersion("3.1");
            boolean isSingleton = this.model.getBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON");
            if (isSingleton && !facetedProject.hasProjectFacet(EJB_MODULE_FACET)) {
                Set runtimes = facetedProject.getTargetedRuntimes();
                for (IRuntime rt : runtimes) {
                    if (rt.supports(version3_1)) continue;
                    return new Status(2, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectionEJBVersionRuntimeWarning, null);
                }
            } else if (isSingleton && !facetedProject.hasProjectFacet(version3_1)) {
                return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_selectionEJBVersionError, null);
            }
        }
        return null;
    }

    protected void createSessionGroup(Composite composite) {
        this.sessionTypeLabel = new Label(composite, 16384);
        Label transactionTypeLabel = new Label(composite, 16384);
        this.sessionTypeLabel.setText(Messages.SessionBeanInputPage_sessionTypeLabel);
        FormData fd_lbSessionType = new FormData();
        fd_lbSessionType.left = new FormAttachment(0, 10);
        fd_lbSessionType.top = new FormAttachment(0, 10);
        this.sessionTypeLabel.setLayoutData((Object)fd_lbSessionType);
        this.transactionTypeCombo = new Combo(composite, 8);
        Button stateless = new Button(composite, 16);
        Button stateful = new Button(composite, 16);
        Button singleton = new Button(composite, 16);
        FormData fd_sessionTypeButton = new FormData();
        fd_sessionTypeButton.left = new FormAttachment((Control)transactionTypeLabel, 10);
        fd_sessionTypeButton.top = new FormAttachment(0, 10);
        stateless.setText("Stateless");
        stateless.setLayoutData((Object)fd_sessionTypeButton);
        this.synchHelper.synchRadio(stateless, "IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS", null);
        fd_sessionTypeButton = new FormData();
        fd_sessionTypeButton.left = new FormAttachment((Control)stateless, 10);
        fd_sessionTypeButton.top = new FormAttachment(0, 10);
        stateful.setText("Stateful");
        stateful.setLayoutData((Object)fd_sessionTypeButton);
        this.synchHelper.synchRadio(stateful, "IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL", null);
        fd_sessionTypeButton = new FormData();
        fd_sessionTypeButton.left = new FormAttachment((Control)stateful, 10);
        fd_sessionTypeButton.top = new FormAttachment(0, 10);
        singleton.setText("Singleton");
        singleton.setLayoutData((Object)fd_sessionTypeButton);
        this.synchHelper.synchRadio(singleton, "IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON", null);
        transactionTypeLabel.setText(Messages.SessionBeanInputPage_transactionTypeLabel);
        FormData fd_transactionTypeLabel = new FormData();
        fd_transactionTypeLabel.left = new FormAttachment(0, 10);
        fd_transactionTypeLabel.top = new FormAttachment((Control)singleton, 10);
        transactionTypeLabel.setLayoutData((Object)fd_transactionTypeLabel);
        FormData fd_transactionTypeCombo = new FormData();
        fd_transactionTypeCombo.left = new FormAttachment((Control)transactionTypeLabel, 10);
        fd_transactionTypeCombo.top = new FormAttachment((Control)singleton, 8);
        this.transactionTypeCombo.setLayoutData((Object)fd_transactionTypeCombo);
        String value = this.model.getStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE");
        DataModelPropertyDescriptor[] descriptors = this.model.getValidPropertyDescriptors("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE");
        int cnt = 0;
        int transactionSelect = 0;
        DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DataModelPropertyDescriptor descriptor = dataModelPropertyDescriptorArray[n2];
            if (descriptor.getPropertyValue().equals(value)) {
                transactionSelect = cnt;
            }
            this.transactionTypeCombo.add(descriptor.getPropertyDescription());
            ++cnt;
            ++n2;
        }
        if (this.isEdit) {
            this.transactionTypeCombo.select(transactionSelect);
        } else {
            this.transactionTypeCombo.select(0);
        }
        this.synchHelper.synchCombo(this.transactionTypeCombo, "IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", null);
        Label concurrencyTypeLabel = new Label(composite, 16384);
        concurrencyTypeLabel.setText(Messages.SessionBeanInputPage_concurrencyTypeLabel);
        this.concurrencyTypeCombo = new Combo(composite, 8);
        FormData fd_concurrencyTypeLabel = new FormData();
        fd_concurrencyTypeLabel.left = new FormAttachment(0, 10);
        fd_concurrencyTypeLabel.top = new FormAttachment((Control)this.concurrencyTypeCombo, 0, 0x1000000);
        concurrencyTypeLabel.setLayoutData((Object)fd_concurrencyTypeLabel);
        FormData fd_concurrencyTypeCombo = new FormData();
        fd_concurrencyTypeCombo.left = new FormAttachment((Control)this.transactionTypeCombo, 0, 16384);
        fd_concurrencyTypeCombo.top = new FormAttachment((Control)this.transactionTypeCombo, 8);
        fd_concurrencyTypeCombo.right = new FormAttachment((Control)this.transactionTypeCombo, 0, 131072);
        this.concurrencyTypeCombo.setLayoutData((Object)fd_concurrencyTypeCombo);
        value = this.model.getStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE");
        descriptors = this.model.getValidPropertyDescriptors("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE");
        cnt = 0;
        int concurrencySelect = 0;
        DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray2 = descriptors;
        int n3 = descriptors.length;
        int n4 = 0;
        while (n4 < n3) {
            DataModelPropertyDescriptor descriptor = dataModelPropertyDescriptorArray2[n4];
            if (descriptor.getPropertyValue().equals(value)) {
                concurrencySelect = cnt;
            }
            this.concurrencyTypeCombo.add(descriptor.getPropertyDescription());
            ++cnt;
            ++n4;
        }
        if (this.isEdit) {
            this.concurrencyTypeCombo.select(concurrencySelect);
        } else {
            this.concurrencyTypeCombo.select(0);
        }
        this.synchHelper.synchCombo(this.concurrencyTypeCombo, "IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE", null);
        if (!this.isEdit) {
            stateless.setSelection(true);
        }
        IDataModelListener listener = new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getPropertyName().equals("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS") || event.getPropertyName().equals("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL") || event.getPropertyName().equals("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON")) {
                    SessionBeanInputPage.this.model.setStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE", null);
                    SessionBeanInputPage.this.model.setStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", null);
                    SessionBeanInputPage.this.synchHelper.synchUIWithModel("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", 4);
                    SessionBeanInputPage.this.synchHelper.synchUIWithModel("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE", 4);
                    SessionBeanInputPage.this.transactionTypeCombo.select(0);
                    SessionBeanInputPage.this.concurrencyTypeCombo.select(0);
                }
                SessionBeanInputPage.this.updateStatus();
            }
        };
        this.model.addListener(listener);
    }

    protected void addSeperator(Composite composite) {
        this.border = new Label(composite, 258);
        FormData borderData = new FormData();
        borderData.top = new FormAttachment((Control)this.javaClassComposite, 10);
        borderData.left = new FormAttachment(0, 10);
        borderData.right = new FormAttachment(100, -10);
        this.border.setLayoutData((Object)borderData);
    }

    private void computeDataModel(IStructuredSelection selection) {
        if (selection != null) {
            Object o = selection.getFirstElement();
            if (!(o instanceof IFile)) {
                return;
            }
            IFile sbFile = (IFile)o;
            SessionBeanUtil.GeneratedSessionBean gsb = SessionBeanUtil.getGeneratedSessionBean((IFile)sbFile);
            if (gsb != null) {
                SessionBeanUtil.reconstructDataModel((IProject)sbFile.getProject(), (SessionBeanUtil.GeneratedSessionBean)gsb, (IDataModel)this.model);
            }
        }
    }
}

