/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ManagedBeanInputPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewSessionBeanFromEntitiesWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;

public class SessionBeanEntitiesSelectionPage
extends EntitiesSelectionPage {
    private final List<String> existingEntityNames = new ArrayList<String>();
    private boolean hasNextPage;
    private IStatus infoStatus = null;

    SessionBeanEntitiesSelectionPage(String pageName, boolean editWizard, boolean hasNextPage, IStructuredSelection selection, String helpContextID) {
        super(pageName, helpContextID);
        this.hasNextPage = hasNextPage;
        this.setDescription(Messages.SessionBeanEntitiesSelectionPage_description);
        if (editWizard) {
            this.computeServiceDefn(selection);
            this.infoStatus = new Status(1, "oracle.eclipse.tools.common.services", Messages.SessionBeanEntitiesSelectionPage_overwriteExisting);
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        if (this.hasNextPage) {
            ManagedBeanInputPage managedBeanPage = (ManagedBeanInputPage)this.getWizard().getPage("ManagedBeanInputPage");
            managedBeanPage.initialize();
            return managedBeanPage;
        }
        return null;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.hasNextPage) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    boolean hasEntitiesChanged() {
        boolean found;
        DataWizardModel wizardModel = this.getDataWizardModel();
        List<String> entities = wizardModel.getSelectedEntities();
        if (this.existingEntityNames.size() != entities.size()) {
            return true;
        }
        for (String entityName : entities) {
            found = false;
            for (String name : this.existingEntityNames) {
                if (!entityName.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        for (String name : this.existingEntityNames) {
            found = false;
            for (String entityName : entities) {
                if (!name.equals(entityName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveDataToModel() {
        DataWizardModel wizardModel = this.getDataWizardModel();
        if (wizardModel != null) {
            wizardModel.setSelectedEntities(this.entitiesComposite.getSelectedEntities());
        }
        if (this.serviceDefinition != null) {
            this.serviceDefinition.removeAllEntities();
            for (String entityName : this.entitiesComposite.getSelectedEntities()) {
                this.serviceDefinition.addEntityName(entityName);
            }
        }
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = super.getStatus();
        if (status == null) {
            return this.infoStatus;
        }
        return status;
    }

    private void computeServiceDefn(IStructuredSelection selection) {
        if (selection != null) {
            Object o = selection.getFirstElement();
            if (!(o instanceof IFile)) {
                return;
            }
            IFile sbFile = (IFile)o;
            this.jpaProjectName = sbFile.getProject().getName();
            SessionBeanUtil.GeneratedSessionBean gsb = SessionBeanUtil.getGeneratedSessionBean((IFile)sbFile);
            if (gsb != null) {
                this.serviceDefinition = SessionBeanUtil.getServiceDefinition((IProject)sbFile.getProject(), (SessionBeanUtil.GeneratedSessionBean)gsb);
                if (this.serviceDefinition != null) {
                    for (String entityName : this.serviceDefinition.getEntityNames()) {
                        this.existingEntityNames.add(entityName);
                    }
                }
            }
        }
    }

    private DataWizardModel getDataWizardModel() {
        if (this.getWizard() instanceof NewADFDataModelComponentsWizard) {
            return ((NewADFDataModelComponentsWizard)this.getWizard()).wizardModel;
        }
        if (this.getWizard() instanceof NewSessionBeanFromEntitiesWizard) {
            return ((NewSessionBeanFromEntitiesWizard)this.getWizard()).wizardModel;
        }
        return null;
    }
}

