/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.ServiceDefinitionFactory;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;

public class ServiceDefinitionUtil {
    static IServiceDefinition createBasicServiceDefn(DataWizardModel wizardModel) {
        IServiceDefinition serviceDefn = ServiceDefinitionFactory.createServiceDefinition();
        serviceDefn.setJpaProjectName(wizardModel.getJpaProjectName());
        for (String sdEntity : wizardModel.getSelectedEntities()) {
            serviceDefn.addEntityName(sdEntity);
        }
        return serviceDefn;
    }

    static IServiceDefinition createBasicServiceDefn(IServiceDefinition sessionBeanSD) {
        if (sessionBeanSD == null) {
            return null;
        }
        IServiceDefinition serviceDefn = ServiceDefinitionFactory.createServiceDefinition();
        serviceDefn.setJpaProjectName(sessionBeanSD.getJpaProjectName());
        for (String sbEntity : sessionBeanSD.getEntityNames()) {
            serviceDefn.addEntityName(sbEntity);
        }
        return serviceDefn;
    }

    static final IServiceDefinitionInfo createSBServiceDefinitionInfo(IServiceDefinition serviceDefn, DataWizardModel wizardModel) {
        IServiceDefinitionInfo sbSDInfo = ServiceDefinitionFactory.createServiceDefinitionInfo((IServiceDefinition)serviceDefn);
        sbSDInfo.setSessionBeanInfo(wizardModel.getSessionBeanName(), wizardModel.getSessionBeanPackageName(), wizardModel.getDataModel());
        return sbSDInfo;
    }

    static final IServiceDefinitionInfo createSBAndMBServiceDefinitionInfo(IServiceDefinition serviceDefn, DataWizardModel wizardModel) {
        IServiceDefinitionInfo mbSDInfo = ServiceDefinitionFactory.createServiceDefinitionInfo((IServiceDefinition)serviceDefn);
        mbSDInfo.setSessionBeanInfo(wizardModel.getSessionBeanName(), wizardModel.getSessionBeanPackageName());
        mbSDInfo.setManagedBeanInfo(wizardModel.getManagedBeanName(), wizardModel.getManagedBeanPackageName(), wizardModel.getWebProjectName());
        return mbSDInfo;
    }
}

