/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.ServiceGeneratorFactory;
import oracle.eclipse.tools.adf.view.appgen.utils.DefaultWebProjectFileProvider;
import oracle.eclipse.tools.adf.view.ui.datacontrol.CreateDataControlHandler;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ManagedBeanInputPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewSessionBeanFromEntitiesWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ServiceDefinitionUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.SessionBeanEntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.SessionBeanInputPage;
import oracle.eclipse.tools.common.services.appgen.compare.IChangeCompareFactory;
import oracle.eclipse.tools.common.services.appgen.generators.DefaultGenerator;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerator;
import oracle.eclipse.tools.common.services.appgen.utils.DefaultJavaProjectFileProvider;
import oracle.eclipse.tools.common.services.appgen.utils.IJavaProjectFileProvider;
import oracle.eclipse.tools.common.services.appgen.utils.IWebProjectFileProvider;
import oracle.eclipse.tools.common.services.ui.appgen.compare.ChangeCompareFactory;
import oracle.eclipse.tools.common.services.ui.appgen.utils.GenerationActionUtil;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewADFDataModelComponentsWizard
extends DataModelWizard {
    static final String PAGE_ENTITIES_SELECTION = "EntitiesSelection";
    static final String PAGE_SESSION_BEANS_INPUT = "SessionBeanInputPage";
    static final String PAGE_MANAGED_BEANS_INPUT = "ManagedBeanInputPage";
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.view.ui.NewADFDataModelComponentsWizard";
    private SessionBeanInputPage inputPage;
    private EntitiesSelectionPage entitiesSelectionPage;
    private ManagedBeanInputPage managedBeanInputPage;
    DataWizardModel wizardModel = new DataWizardModel();

    public NewADFDataModelComponentsWizard() {
        this.setWindowTitle(Messages.NewADFDataModelComponentsWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)"icons/wizards/data-model-components-banner.png"));
    }

    public void addPages() {
        IDataModel dataModel = this.createDataModel();
        this.wizardModel.setDataModel(dataModel);
        this.inputPage = new SessionBeanInputPage(dataModel, PAGE_SESSION_BEANS_INPUT, false, null, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.inputPage);
        this.entitiesSelectionPage = new SessionBeanEntitiesSelectionPage(PAGE_ENTITIES_SELECTION, false, true, null, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.entitiesSelectionPage);
        this.managedBeanInputPage = new ManagedBeanInputPage(PAGE_MANAGED_BEANS_INPUT, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.managedBeanInputPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.inputPage || currentPage == this.entitiesSelectionPage) {
            return false;
        }
        if (currentPage == this.managedBeanInputPage) {
            return ((ManagedBeanInputPage)currentPage).isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewADFDataModelComponentsWizard.this.doFinish(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Activator.log(realException);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewADFDataModelComponentsWizard_generateDataComponentsTaskError, (String)realException.getMessage());
            return false;
        }
        NewADFDataModelComponentsWizard.openEditor(this.getShell(), this.getFileList());
        return true;
    }

    private IFile[] getFileList() {
        StringBuilder classname;
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        if (this.wizardModel.getWebProjectName() != null) {
            IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.wizardModel.getWebProjectName());
            String managedBeanName = this.wizardModel.getManagedBeanName();
            String managedBeanPackageName = this.wizardModel.getManagedBeanPackageName();
            if (managedBeanName != null) {
                classname = new StringBuilder();
                if (managedBeanPackageName != null && !managedBeanPackageName.isEmpty()) {
                    classname.append(managedBeanPackageName);
                    classname.append('.');
                }
                classname.append(managedBeanName);
                IFile mbFile = JavaUtil.getExistingJavaFile((IProject)webProject, (String)classname.toString());
                if (mbFile != null) {
                    fileList.add(mbFile);
                }
            }
        }
        if (this.wizardModel.getJpaProjectName() != null) {
            IProject jpaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.wizardModel.getJpaProjectName());
            String sessionBeanName = this.wizardModel.getSessionBeanName();
            String sessionBeanPackageName = this.wizardModel.getSessionBeanPackageName();
            if (sessionBeanName != null) {
                classname = new StringBuilder();
                if (sessionBeanPackageName != null && !sessionBeanPackageName.isEmpty()) {
                    classname.append(sessionBeanPackageName);
                    classname.append('.');
                }
                classname.append(sessionBeanName);
                IFile sbFile = JavaUtil.getExistingJavaFile((IProject)jpaProject, (String)classname.toString());
                if (sbFile != null) {
                    fileList.add(sbFile);
                }
            }
        }
        return fileList.toArray(new IFile[fileList.size()]);
    }

    private void doFinish(IProgressMonitor monitor) throws ExecutionException {
        monitor.beginTask(Messages.NewADFDataModelComponentsWizard_generateDataComponentsTask, 3);
        IServiceDefinition sbServiceDefn = ServiceDefinitionUtil.createBasicServiceDefn(this.wizardModel);
        IServiceDefinition mbServiceDefn = ServiceDefinitionUtil.createBasicServiceDefn(sbServiceDefn);
        IProject jpaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.wizardModel.getJpaProjectName());
        IStatus status = NewSessionBeanFromEntitiesWizard.addEJBFacetOperation(jpaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (status != null && status.getSeverity() == 4) {
            this.openStatusDialog(this.getShell(), Messages.NewSessionBeanFromEntitiesWizard_sessionBeanGenError, status);
            return;
        }
        IServiceDefinitionInfo sbSDInfo = ServiceDefinitionUtil.createSBServiceDefinitionInfo(sbServiceDefn, this.wizardModel);
        IServiceDefinitionInfo mbSDInfo = ServiceDefinitionUtil.createSBAndMBServiceDefinitionInfo(mbServiceDefn, this.wizardModel);
        monitor.subTask(Messages.NewADFDataModelComponentsWizard_generateSubTaskLabel);
        Set<IGenerationContextFactory.GenerationOption> genOptions = Collections.emptySet();
        if (this.wizardModel.getDataTechnologyType() == DataWizardModel.DataTechnologyType.DataControl) {
            genOptions = EnumSet.of(IGenerationContextFactory.GenerationOption.SESSION_BEAN);
        } else if (this.wizardModel.getDataTechnologyType() == DataWizardModel.DataTechnologyType.ManagedBeans) {
            genOptions = EnumSet.of(IGenerationContextFactory.GenerationOption.SESSION_BEAN, IGenerationContextFactory.GenerationOption.MANAGED_BEAN);
        }
        status = NewADFDataModelComponentsWizard.generateBeans(sbSDInfo, this.wizardModel.getJpaProjSrcFolderName(), mbSDInfo, this.wizardModel.getWebProjSrcFolderName(), genOptions, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.setTaskName(Messages.NewADFDataModelComponentsWizard_generateDataComponentsTask);
        if (status == null || status.isOK() && this.wizardModel.getDataTechnologyType() == DataWizardModel.DataTechnologyType.DataControl) {
            monitor.subTask(Messages.NewADFDataModelComponentsWizard_generateDCSubTaskLabel);
            status = this.generateDataControl(this.wizardModel.getJpaProjectName(), this.wizardModel.getSessionBeanPackageName(), this.wizardModel.getSessionBeanName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
        if (status != null && status.getSeverity() == 4) {
            this.openStatusDialog(this.getShell(), Messages.NewADFDataModelComponentsWizard_generateDataComponentsTaskError, status);
        }
    }

    static IStatus generateBeans(IServiceDefinitionInfo sbSDInfo, String sbSrcFolderName, IServiceDefinitionInfo mbAppSpecModel, String webSrcFolderName, Set<IGenerationContextFactory.GenerationOption> genOptions, IProgressMonitor monitor) {
        IGenerationContextFactory contextFactory = NewADFDataModelComponentsWizard.createGenerationContextFactory(sbSDInfo, sbSrcFolderName, mbAppSpecModel, webSrcFolderName, genOptions);
        return NewADFDataModelComponentsWizard.generateBeansFromContextFactory(contextFactory, monitor);
    }

    static IStatus generateBeansFromContextFactory(IGenerationContextFactory contextFactory, IProgressMonitor monitor) {
        DefaultGenerator generator = new DefaultGenerator(contextFactory, (IChangeCompareFactory)new ChangeCompareFactory());
        return GenerationActionUtil.run((IGenerator)generator, (IProgressMonitor)monitor);
    }

    static IGenerationContextFactory createGenerationContextFactory(IServiceDefinitionInfo sbSDInfo, String sbSrcFolderName, IServiceDefinitionInfo mbSDInfo, String webSrcFolderName, Set<IGenerationContextFactory.GenerationOption> genOptions) {
        List entityInfos;
        IProject modelProject = null;
        IProject webProject = null;
        if (sbSDInfo != null && (entityInfos = sbSDInfo.getEntityInfoList()) != null && !entityInfos.isEmpty()) {
            modelProject = ((IEntityInfo)entityInfos.get(0)).getJpaProject().getProject();
        }
        if (mbSDInfo != null) {
            webProject = mbSDInfo.getManagedBeanProject();
        }
        DefaultJavaProjectFileProvider modelFileProvider = null;
        if (genOptions.contains(IGenerationContextFactory.GenerationOption.SESSION_BEAN) || genOptions.contains(IGenerationContextFactory.GenerationOption.JAVA_SERVICE)) {
            modelFileProvider = new DefaultJavaProjectFileProvider(modelProject, sbSrcFolderName);
        }
        IGenerationContextFactory contextFactory = ServiceGeneratorFactory.createGenerationContextFactory((IServiceDefinitionInfo)sbSDInfo, (IServiceDefinitionInfo)mbSDInfo, (IJavaProjectFileProvider)modelFileProvider, (IWebProjectFileProvider)(genOptions.contains(IGenerationContextFactory.GenerationOption.MANAGED_BEAN) ? new DefaultWebProjectFileProvider(webProject, webSrcFolderName) : null), genOptions);
        return contextFactory;
    }

    private IStatus generateDataControl(String jpaProjectName, String sessionBeanPackageName, String sessionBeanName, IProgressMonitor monitor) {
        IJavaProject javaProject;
        IProject jpaProject;
        Status status = new Status(4, "oracle.eclipse.tools.adf.view.ui", Messages.NewADFDataModelComponentsWizard_generateDataControlError);
        if (jpaProjectName != null && sessionBeanPackageName != null && sessionBeanName != null && (jpaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(jpaProjectName)) != null && jpaProject.exists() && (javaProject = JavaCore.create((IProject)jpaProject)) != null && javaProject.exists()) {
            String sPath = sessionBeanPackageName.length() > 0 ? sessionBeanPackageName.concat(".").concat(sessionBeanName) : sessionBeanName;
            sPath = sPath.replaceAll("\\.", "/");
            sPath = sPath.concat(".java");
            Path path = new Path(sPath);
            try {
                IJavaElement element = javaProject.findElement((IPath)path);
                if (element instanceof ITypeRoot && element.exists()) {
                    try {
                        this.executeCreateDataControlCommand((ITypeRoot)element, monitor);
                        status = Status.OK_STATUS;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return status;
    }

    static IStatus validateEdit(IGenerationContextFactory contextFactory) {
        try {
            IStatus status;
            List genContexts = contextFactory.getGenerationContexts();
            ArrayList<IFile> fileList = new ArrayList<IFile>();
            for (IGenerationContext genContext : genContexts) {
                fileList.add(genContext.getTargetFile());
            }
            if (!fileList.isEmpty() && !(status = ValidateEditUtil.validateEdit((IFile[])fileList.toArray(new IFile[fileList.size()]))).isOK()) {
                return status;
            }
        }
        catch (GenerationException e) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", Messages.NewADFDataModelComponentsWizard_generateDataComponentsTaskError, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    static void saveFile(IGenerationContextFactory contextFactory, IProgressMonitor monitor) {
        try {
            List genContexts = contextFactory.getGenerationContexts();
            for (IGenerationContext genContext : genContexts) {
                IFile file = genContext.getTargetFile();
                if (file == null || !file.exists()) {
                    return;
                }
                ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
                if (cu == null) continue;
                if (cu.hasUnsavedChanges()) {
                    cu.becomeWorkingCopy(monitor);
                    cu.commitWorkingCopy(true, monitor);
                    cu.discardWorkingCopy();
                }
                cu.save(null, true);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
        }
        catch (GenerationException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void executeCreateDataControlCommand(ITypeRoot selection, IProgressMonitor monitor) throws Exception {
        if (selection != null) {
            Command command;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
            ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
            if (handlerService != null && commandService != null && (command = commandService.getCommand("oracle.eclipse.tools.adf.view.ui.command.CreateDataControl")) != null) {
                CreateDataControlHandler handler = new CreateDataControlHandler();
                EvaluationContext context = new EvaluationContext(handlerService.getCurrentState(), (Object)selection);
                context.addVariable("selection", (Object)selection);
                context.addVariable("shell", (Object)this.getShell());
                ExecutionEvent event = new ExecutionEvent(command, Collections.EMPTY_MAP, null, (Object)context);
                handler.execute(event);
            }
        }
    }
}

