/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.AbstractWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.BindingTypeComposite;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ManagedBeanInputPage
extends AbstractWizardPage
implements PropertyChangeListener {
    protected BindingTypeComposite bindingComposite;

    public ManagedBeanInputPage(String pageName, String helpContextID) {
        super(pageName, helpContextID);
        this.setTitle(Messages.ManagedBeanInputPage_title);
        this.setDescription(Messages.ManagedBeanInputPage_desc);
    }

    public void createControl(Composite parent) {
        this.bindingComposite = new BindingTypeComposite(parent, 0);
        this.bindingComposite.addPropertyChangeListener(this);
        this.setControl((Control)this.bindingComposite);
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)this.bindingComposite, this.helpContextID);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        if (status == null || status.getSeverity() != 4) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    public void initialize() {
        IProject jpaProject;
        NewADFDataModelComponentsWizard wizard = (NewADFDataModelComponentsWizard)this.getWizard();
        String jpaProjectName = wizard.wizardModel.getJpaProjectName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null && (jpaProject = root.getProject(jpaProjectName)) != null) {
            this.bindingComposite.setJpaProjectAndSelection(jpaProject, (ISelection)((DataModelWizard)this.getWizard()).getSelection());
            this.finalInitialStatusCheck(jpaProject);
        }
    }

    private void finalInitialStatusCheck(IProject jpaProject) {
        Status status = null;
        List webProjects = ProjectUtils.getWebProjects((IProject)jpaProject);
        if (webProjects == null || webProjects.size() == 0) {
            status = new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_noWebProjectsError, null);
        }
        this.applyToStatusLine((IStatus)status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }

    @Override
    protected IStatus getStatus() {
        return this.bindingComposite.getStatus();
    }

    protected void saveDataToModel() {
        DataWizardModel wizardModel = ((NewADFDataModelComponentsWizard)this.getWizard()).wizardModel;
        this.bindingComposite.saveDataToModel(wizardModel);
    }
}

