/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.utils.JavaServiceUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.AbstractDataModelWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaClassInputComposite;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewJavaServiceFromEntitiesWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewSessionBeanFromEntitiesWizard;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JavaServiceInputPage
extends AbstractDataModelWizardPage
implements PropertyChangeListener {
    private JavaClassInputComposite javaClassComposite;
    private Label border;
    private boolean isEdit = false;
    private static final int HORIZONTAL_OFFSET = 10;
    private static final int HORIZONTAL_GAP = 10;
    private static final int VERTICAL_OFFSET = 10;
    private Label commitBehaviorLabel;

    public JavaServiceInputPage(IDataModel dataModel, String pageName, IStructuredSelection selection, boolean isEdit, String helpContextID) {
        super(dataModel, pageName, helpContextID);
        this.setTitle(Messages.JavaServiceInputPage_title);
        this.setDescription(Messages.JavaServiceInputPage_description);
        this.isEdit = isEdit;
        if (isEdit) {
            this.computeDataModel(selection);
        }
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        if (!this.isEdit) {
            this.javaClassComposite = new JavaClassInputComposite(comp, 0);
            this.javaClassComposite.setProjectInputAndSelection(this.getJpaProjects(((DataModelWizard)this.getWizard()).getSelection()), (ISelection)((DataModelWizard)this.getWizard()).getSelection());
            this.javaClassComposite.addPropertyChangeListener(this);
            FormData fd_javaClassComposite = new FormData();
            fd_javaClassComposite.top = new FormAttachment(0);
            fd_javaClassComposite.left = new FormAttachment(0, 0);
            fd_javaClassComposite.right = new FormAttachment(100, 0);
            this.javaClassComposite.setLayoutData(fd_javaClassComposite);
            this.addSeperator(comp);
        }
        Composite sComp = new Composite(comp, 0);
        sComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.border, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        sComp.setLayoutData((Object)data);
        this.createServiceGroup(sComp);
        if (!this.isEdit) {
            this.javaClassComposite.projectViewer.getControl().setFocus();
        } else {
            this.commitBehaviorLabel.setFocus();
        }
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)comp, this.helpContextID);
        }
        return comp;
    }

    @Override
    protected IStatus getStatus() {
        if (!this.isEdit) {
            IStatus webProjStatus = this.evaluateForWebProject();
            if (webProjStatus != null && webProjStatus.getSeverity() == 4) {
                return webProjStatus;
            }
            IStatus javaClassStatus = this.javaClassComposite.validate("oracle.eclipse.tools.adf.view.ui", Messages.JavaClassInputComposite_selectModelProjectError);
            if (javaClassStatus != null && javaClassStatus.getSeverity() == 4) {
                return javaClassStatus;
            }
            if (javaClassStatus != null && javaClassStatus.getSeverity() == 2) {
                return javaClassStatus;
            }
            if (webProjStatus != null && webProjStatus.getSeverity() == 2) {
                return webProjStatus;
            }
        }
        return null;
    }

    public IWizardPage getNextPage() {
        if (!this.isEdit) {
            this.saveDataToModel();
            EntitiesSelectionPage entitiesPage = (EntitiesSelectionPage)this.getWizard().getPage("EntitiesSelection");
            IStructuredSelection ss = (IStructuredSelection)this.javaClassComposite.projectViewer.getSelection();
            IProject project = (IProject)ss.getFirstElement();
            entitiesPage.setJpaProjectName(project.getName());
            return entitiesPage;
        }
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        if (status == null || status.getSeverity() != 4) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.isEdit) {
            ISelection selection = this.javaClassComposite.projectViewer.getSelection();
            if (selection == null || selection.isEmpty()) {
                this.javaClassComposite.projectViewer.getControl().setFocus();
            } else {
                String pkg = this.javaClassComposite.textJavaPkg.getText();
                if (pkg == null || pkg.isEmpty()) {
                    this.javaClassComposite.textJavaPkg.setFocus();
                } else {
                    this.javaClassComposite.classNameText.selectAll();
                    this.javaClassComposite.classNameText.setFocus();
                }
            }
        }
    }

    private List<IProject> getJpaProjects(IStructuredSelection selection) {
        ArrayList<IProject> jpaProjList = new ArrayList<IProject>();
        Object o = selection.getFirstElement();
        IProject selectionProject = null;
        if (o instanceof IResource) {
            selectionProject = ((IResource)o).getProject();
        }
        if (selectionProject == null && o instanceof IAdaptable) {
            selectionProject = (IProject)((IAdaptable)o).getAdapter(IProject.class);
        }
        if (selectionProject != null) {
            for (JpaProject jpaProj : JPAUtils.getJpaProjects((IProject)selectionProject)) {
                jpaProjList.add(jpaProj.getProject());
            }
            return jpaProjList;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            JpaProject jpaProj = (JpaProject)proj.getAdapter(JpaProject.class);
            if (jpaProj != null) {
                jpaProjList.add(jpaProj.getProject());
            }
            ++n2;
        }
        return jpaProjList;
    }

    private void saveDataToModel() {
        DataWizardModel wizardModel = null;
        if (this.getWizard() instanceof NewADFDataModelComponentsWizard) {
            wizardModel = ((NewADFDataModelComponentsWizard)this.getWizard()).wizardModel;
        } else if (this.getWizard() instanceof NewSessionBeanFromEntitiesWizard) {
            wizardModel = ((NewSessionBeanFromEntitiesWizard)this.getWizard()).wizardModel;
        } else if (this.getWizard() instanceof NewJavaServiceFromEntitiesWizard) {
            wizardModel = ((NewJavaServiceFromEntitiesWizard)this.getWizard()).wizardModel;
        }
        if (!this.isEdit) {
            this.javaClassComposite.saveDataToWizardModel(wizardModel, false);
        }
    }

    private IStatus evaluateForWebProject() {
        IStructuredSelection ss = (IStructuredSelection)this.javaClassComposite.projectViewer.getSelection();
        IProject project = (IProject)ss.getFirstElement();
        if (project == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.SessionBeanInputPage_jpaProjectRequired, null);
        }
        return null;
    }

    protected void createServiceGroup(Composite composite) {
        this.commitBehaviorLabel = new Label(composite, 16384);
        this.commitBehaviorLabel.setText(Messages.JavaServiceInputPage_commitLabel);
        FormData fd_lbCommitBehavior = new FormData();
        fd_lbCommitBehavior.left = new FormAttachment(0, 10);
        fd_lbCommitBehavior.top = new FormAttachment(0, 10);
        this.commitBehaviorLabel.setLayoutData((Object)fd_lbCommitBehavior);
        Button implicit = new Button(composite, 16);
        Button explicit = new Button(composite, 16);
        FormData fd_commitButton = new FormData();
        fd_commitButton.left = new FormAttachment((Control)this.commitBehaviorLabel, 10);
        fd_commitButton.top = new FormAttachment(0, 10);
        implicit.setText("Implicit");
        implicit.setLayoutData((Object)fd_commitButton);
        this.synchHelper.synchRadio(implicit, "IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.IMPLICIT", null);
        if (!this.isEdit) {
            implicit.setSelection(true);
        }
        fd_commitButton = new FormData();
        fd_commitButton.left = new FormAttachment((Control)implicit, 10);
        fd_commitButton.top = new FormAttachment(0, 10);
        explicit.setText("Explicit");
        explicit.setLayoutData((Object)fd_commitButton);
        this.synchHelper.synchRadio(explicit, "IServiceDefinitionDataModelProperties.COMMIT_BEHAVIOR.EXPLICIT", null);
        fd_commitButton = new FormData();
        fd_commitButton.left = new FormAttachment((Control)explicit, 10);
        fd_commitButton.top = new FormAttachment(0, 10);
    }

    protected void addSeperator(Composite composite) {
        this.border = new Label(composite, 258);
        FormData borderData = new FormData();
        borderData.top = new FormAttachment((Control)this.javaClassComposite, 10);
        borderData.left = new FormAttachment(0, 10);
        borderData.right = new FormAttachment(100, -10);
        this.border.setLayoutData((Object)borderData);
    }

    private void computeDataModel(IStructuredSelection selection) {
        if (selection != null) {
            Object o = selection.getFirstElement();
            if (!(o instanceof IFile)) {
                return;
            }
            IFile jsFile = (IFile)o;
            IType[] types = null;
            try {
                types = JavaServiceUtil.getTypes((IFile)jsFile);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (types != null) {
                JavaServiceUtil.reconstructDataModel((IProject)jsFile.getProject(), (String)types[0].getFullyQualifiedName(), (IDataModel)this.model);
            }
        }
    }
}

