/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.util.JavaUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class JavaClassInputComposite
extends Composite {
    public static final String PROP_JAVA_PROJECT_SELECTED = "JavaProjectSelected";
    public static final String PROP_CLASS_NAME_CHANGED = "ClassNameChanged";
    public static final String PROP_JAVA_PACKAGE_SELECTED = "JavaPackageSelected";
    public static final String PROP_SRC_FOLDER_SELECTED = "JavaSrcFolderSelected";
    private static final int HORIZONTAL_OFFSET = 10;
    private static final int HORIZONTAL_GAP = 10;
    private static final int VERTICAL_OFFSET = 10;
    private static final int VERTICAL_GAP = 8;
    private Label lblProject;
    private ModifyListener textSrcFolderListener;
    private ModifyListener textJavaPkgListener;
    private ModifyListener classNameTextModifyListener;
    private SelectionListener btnJavaPkgSelectionListener;
    private SelectionListener btnSrcFolderSelectionListener;
    private ISelectionChangedListener projectViewerListener;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport((Object)this);
    ComboViewer projectViewer;
    Text textJavaPkg;
    Text classNameText;
    Button btnJavaPkg;
    Text textSrcFolder;
    Button btnSrcFolder;

    JavaClassInputComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        Label labelJavaPkg = new Label((Composite)this, 0);
        this.lblProject = new Label((Composite)this, 0);
        this.lblProject.setText(Messages.JavaClassInputComposite_labelJPAProject);
        FormData fd_lblJavaProject = new FormData();
        fd_lblJavaProject.left = new FormAttachment(0, 10);
        fd_lblJavaProject.top = new FormAttachment(0, 10);
        this.lblProject.setLayoutData((Object)fd_lblJavaProject);
        this.projectViewer = new ComboViewer((Composite)this);
        this.textSrcFolder = new Text((Composite)this, 2048);
        this.btnSrcFolder = new Button((Composite)this, 8);
        FormData fd_projectViewer = new FormData();
        fd_projectViewer.left = new FormAttachment((Control)labelJavaPkg, 10);
        fd_projectViewer.top = new FormAttachment((Control)this.lblProject, 0, 0x1000000);
        fd_projectViewer.right = new FormAttachment((Control)this.textSrcFolder, 0, 131072);
        this.projectViewer.getControl().setLayoutData((Object)fd_projectViewer);
        this.projectViewer.setContentProvider((IContentProvider)new ProjectListContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectListLabelProvider());
        Label labelSrcFolder = new Label((Composite)this, 0);
        labelSrcFolder.setText(Messages.JavaClassInputComposite_labelSrcFolder);
        FormData fd_labelSrcFolder = new FormData();
        fd_labelSrcFolder.left = new FormAttachment((Control)this.lblProject, 0, 16384);
        fd_labelSrcFolder.top = new FormAttachment((Control)this.textSrcFolder, 0, 0x1000000);
        labelSrcFolder.setLayoutData((Object)fd_labelSrcFolder);
        FormData fd_textSrcFolder = new FormData();
        fd_textSrcFolder.left = new FormAttachment(this.projectViewer.getControl(), 0, 16384);
        fd_textSrcFolder.top = new FormAttachment(this.projectViewer.getControl(), 8);
        fd_textSrcFolder.right = new FormAttachment((Control)this.btnSrcFolder, -10);
        this.textSrcFolder.setLayoutData((Object)fd_textSrcFolder);
        this.btnSrcFolder.setText(Messages.JavaClassInputComposite_browseSrcStr);
        FormData fd_btnSrcFolder = new FormData();
        fd_btnSrcFolder.top = new FormAttachment((Control)this.textSrcFolder, 0, 0x1000000);
        fd_btnSrcFolder.right = new FormAttachment(100, -10);
        this.btnSrcFolder.setLayoutData((Object)fd_btnSrcFolder);
        this.textJavaPkg = new Text((Composite)this, 2048);
        this.btnJavaPkg = new Button((Composite)this, 8);
        labelJavaPkg.setText(Messages.JavaClassInputComposite_javaPackage);
        FormData fd_labelJavaPkg = new FormData();
        fd_labelJavaPkg.left = new FormAttachment((Control)this.lblProject, 0, 16384);
        fd_labelJavaPkg.top = new FormAttachment((Control)this.textJavaPkg, 0, 0x1000000);
        labelJavaPkg.setLayoutData((Object)fd_labelJavaPkg);
        FormData fd_textJavaPkg = new FormData();
        fd_textJavaPkg.left = new FormAttachment((Control)this.textSrcFolder, 0, 16384);
        fd_textJavaPkg.top = new FormAttachment((Control)this.textSrcFolder, 8);
        fd_textJavaPkg.right = new FormAttachment((Control)this.textSrcFolder, 0, 131072);
        this.textJavaPkg.setLayoutData((Object)fd_textJavaPkg);
        this.btnJavaPkg.setText(Messages.JavaClassInputComposite_browsePkgStr);
        FormData fd_btnJavaPkg = new FormData();
        fd_btnJavaPkg.left = new FormAttachment((Control)this.btnSrcFolder, 0, 16384);
        fd_btnJavaPkg.top = new FormAttachment((Control)this.textJavaPkg, 0, 0x1000000);
        fd_btnJavaPkg.right = new FormAttachment((Control)this.btnSrcFolder, 0, 131072);
        this.btnJavaPkg.setLayoutData((Object)fd_btnJavaPkg);
        this.classNameText = new Text((Composite)this, 2048);
        Label classNameLabel = new Label((Composite)this, 0);
        classNameLabel.setText(Messages.JavaClassInputComposite_classNameLabel);
        FormData fd_classNameLabel = new FormData();
        fd_classNameLabel.left = new FormAttachment((Control)this.lblProject, 0, 16384);
        fd_classNameLabel.top = new FormAttachment((Control)this.classNameText, 0, 0x1000000);
        classNameLabel.setLayoutData((Object)fd_classNameLabel);
        FormData fd_classNameText = new FormData();
        fd_classNameText.left = new FormAttachment((Control)this.textSrcFolder, 0, 16384);
        fd_classNameText.top = new FormAttachment((Control)this.textJavaPkg, 8);
        fd_classNameText.right = new FormAttachment((Control)this.textSrcFolder, 0, 131072);
        this.classNameText.setLayoutData((Object)fd_classNameText);
        this.setTabList(new Control[]{this.projectViewer.getControl(), this.textSrcFolder, this.btnSrcFolder, this.textJavaPkg, this.btnJavaPkg, this.classNameText});
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void setProjectLabel(String label) {
        this.lblProject.setText(label);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ISelection selection = this.projectViewer.getSelection();
            if (selection == null || selection.isEmpty()) {
                this.projectViewer.getControl().setFocus();
            } else {
                String pkg = this.textJavaPkg.getText();
                if (pkg == null || pkg.isEmpty()) {
                    this.textJavaPkg.setFocus();
                } else {
                    this.classNameText.selectAll();
                    this.classNameText.setFocus();
                }
            }
        }
    }

    void setProjectInputAndSelection(List<IProject> viewerInput, ISelection selection) {
        IProject project;
        if (this.projectViewer.getInput() != viewerInput) {
            this.projectViewer.setInput(viewerInput);
        }
        if ((project = this.determineInitialProjectForSelection(selection)) == null) {
            return;
        }
        this.projectViewer.removeSelectionChangedListener(this.projectViewerListener);
        this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)project), true);
        this.projectViewer.addSelectionChangedListener(this.projectViewerListener);
        this.propChangeSupport.firePropertyChange(PROP_JAVA_PROJECT_SELECTED, null, project);
        this.setSrcFolder(selection, project);
        this.setPackage(selection, project);
    }

    void saveDataToWizardModel(DataWizardModel wizardModel, boolean isWebProject) {
        IStructuredSelection ss = (IStructuredSelection)this.projectViewer.getSelection();
        IProject project = (IProject)ss.getFirstElement();
        if (isWebProject) {
            wizardModel.setWebProjectName(project.getName());
            wizardModel.setWebProjSrcFolderName(this.textSrcFolder.getText());
            wizardModel.setManagedBeanPackageName(this.textJavaPkg.getText());
            wizardModel.setManagedBeanName(this.classNameText.getText());
        } else {
            wizardModel.setJpaProjectName(project.getName());
            wizardModel.setJpaProjSrcFolderName(this.textSrcFolder.getText());
            wizardModel.setSessionBeanPackageName(this.textJavaPkg.getText());
            wizardModel.setSessionBeanName(this.classNameText.getText());
        }
    }

    IStatus validate(String pluginID, String selectProjectError) {
        IStructuredSelection ss = (IStructuredSelection)this.projectViewer.getSelection();
        if (ss.getFirstElement() == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, selectProjectError, null);
        }
        IProject project = (IProject)ss.getFirstElement();
        IJavaProject javaProj = JavaCore.create((IProject)project);
        if (javaProj == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.JavaClassInputComposite_notAJavaProjectError, null);
        }
        String srcFolderName = this.textSrcFolder.getText();
        if (!JavaUtils.isValidSourceFolder(javaProj, srcFolderName)) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.JavaClassInputComposite_invalidSrcFolderValidation, null);
        }
        String javaPkg = this.textJavaPkg.getText();
        Object javaPkgStatus = null;
        javaPkgStatus = javaPkg.equals("") ? new Status(2, "oracle.eclipse.tools.adf.view.ui", 0, Messages.JavaClassInputComposite_defaultPkgWarning, null) : JavaConventions.validatePackageName((String)javaPkg, (String)"1.3", (String)"1.3");
        if (javaPkgStatus != null && javaPkgStatus.getSeverity() == 4) {
            return javaPkgStatus;
        }
        String className = this.classNameText.getText();
        IStatus classNameStatus = JavaUtils.validateJavaClassName(className);
        if (classNameStatus != null && classNameStatus.getSeverity() == 4) {
            return classNameStatus;
        }
        IStatus pkgClassStatus = this.validateCanCreateType(javaProj, srcFolderName, javaPkg, className);
        if (pkgClassStatus != null && pkgClassStatus.getSeverity() == 4) {
            return pkgClassStatus;
        }
        if (classNameStatus != null && classNameStatus.getSeverity() == 2) {
            return classNameStatus;
        }
        if (javaPkgStatus != null && javaPkgStatus.getSeverity() == 2) {
            return javaPkgStatus;
        }
        if (pkgClassStatus != null && pkgClassStatus.getSeverity() == 2) {
            return pkgClassStatus;
        }
        return null;
    }

    IStatus validateCanCreateType(IJavaProject project, String srcFolder, String packageName, String typeName) {
        return JavaUtils.canCreateTypeInClasspath(project, srcFolder, packageName, typeName);
    }

    private void init() {
        this.createListeners();
        this.addListeners();
    }

    private void createListeners() {
        this.projectViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IProject) {
                    JavaClassInputComposite.this.propChangeSupport.firePropertyChange(JavaClassInputComposite.PROP_JAVA_PROJECT_SELECTED, null, element);
                    JavaClassInputComposite.this.setSrcFolder(null, (IProject)element);
                }
            }
        };
        this.textJavaPkgListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaClassInputComposite.this.propChangeSupport.firePropertyChange(JavaClassInputComposite.PROP_JAVA_PACKAGE_SELECTED, null, JavaClassInputComposite.this.textJavaPkg.getText());
            }
        };
        this.btnJavaPkgSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss;
                String pkgName;
                IStructuredSelection selection = (IStructuredSelection)JavaClassInputComposite.this.projectViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IProject && (pkgName = JavaUtils.showPackageSelectionDlg((IProject)(ss = (IStructuredSelection)JavaClassInputComposite.this.projectViewer.getSelection()).getFirstElement(), JavaClassInputComposite.this.textSrcFolder.getText(), e.display.getActiveShell())) != null) {
                    JavaClassInputComposite.this.textJavaPkg.setText(pkgName);
                    JavaClassInputComposite.this.propChangeSupport.firePropertyChange(JavaClassInputComposite.PROP_JAVA_PACKAGE_SELECTED, null, JavaClassInputComposite.this.textJavaPkg.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.classNameTextModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaClassInputComposite.this.propChangeSupport.firePropertyChange(JavaClassInputComposite.PROP_CLASS_NAME_CHANGED, null, JavaClassInputComposite.this.classNameText.getText());
            }
        };
        this.textSrcFolderListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaClassInputComposite.this.propChangeSupport.firePropertyChange(JavaClassInputComposite.PROP_SRC_FOLDER_SELECTED, null, JavaClassInputComposite.this.textSrcFolder.getText());
            }
        };
        this.btnSrcFolderSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)JavaClassInputComposite.this.projectViewer.getSelection();
                IProject project = (IProject)ss.getFirstElement();
                if (project == null) {
                    return;
                }
                IContainer container = JavaUtils.handleFolderButtonPressed(project, JavaClassInputComposite.this.getShell());
                if (container != null) {
                    JavaClassInputComposite.this.textSrcFolder.setText(container.getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    private void addListeners() {
        this.btnSrcFolder.addSelectionListener(this.btnSrcFolderSelectionListener);
        this.btnJavaPkg.addSelectionListener(this.btnJavaPkgSelectionListener);
        this.projectViewer.addSelectionChangedListener(this.projectViewerListener);
        this.textSrcFolder.addModifyListener(this.textSrcFolderListener);
        this.textJavaPkg.addModifyListener(this.textJavaPkgListener);
        this.classNameText.addModifyListener(this.classNameTextModifyListener);
    }

    private IProject determineInitialProjectForSelection(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object element = ss.getFirstElement();
        ProjectListContentProvider cProvider = (ProjectListContentProvider)this.projectViewer.getContentProvider();
        List<IProject> projects = cProvider.projList;
        if ((selection == null || element == null) && projects != null && projects.size() == 1) {
            return projects.get(0);
        }
        IResource resource = JavaUtils.getResource(element);
        if (resource != null) {
            IProject project = resource.getProject();
            if (projects != null && projects.size() > 0) {
                for (IProject proj : projects) {
                    if (!proj.equals((Object)project)) continue;
                    return proj;
                }
                return projects.get(0);
            }
        }
        return null;
    }

    private void setSrcFolder(ISelection selection, IProject project) {
        this.textSrcFolder.removeModifyListener(this.textSrcFolderListener);
        IFolder folder = null;
        try {
            folder = JavaUtils.getSourceFolder(selection, project);
        }
        catch (JavaModelException jme) {
            Activator.log(jme);
        }
        if (folder != null) {
            this.textSrcFolder.setText(folder.getName());
        } else {
            this.textSrcFolder.setText("");
        }
        this.propChangeSupport.firePropertyChange(PROP_SRC_FOLDER_SELECTED, null, this.textSrcFolder);
        this.textSrcFolder.addModifyListener(this.textSrcFolderListener);
    }

    private void setPackage(ISelection selection, IProject project) {
        this.textJavaPkg.removeModifyListener(this.textJavaPkgListener);
        IPackageFragment pkgFragment = null;
        try {
            pkgFragment = JavaUtils.getPackageFragment(selection, project);
        }
        catch (JavaModelException javaModelException) {
            pkgFragment = null;
        }
        if (pkgFragment != null) {
            this.textJavaPkg.setText(pkgFragment.getElementName());
        } else {
            this.textJavaPkg.setText("");
        }
        this.propChangeSupport.firePropertyChange(PROP_JAVA_PACKAGE_SELECTED, null, this.textJavaPkg.getText());
        this.textJavaPkg.addModifyListener(this.textJavaPkgListener);
    }

    static class ProjectListContentProvider
    implements IStructuredContentProvider {
        List<IProject> projList = new ArrayList<IProject>();

        ProjectListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.projList = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.projList.toArray();
        }
    }

    static class ProjectListLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        ProjectListLabelProvider() {
        }

        public String getText(Object element) {
            return element instanceof IProject ? ((IProject)element).getName() : "";
        }
    }
}

